/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.preprocessor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.preprocessor.PreprocessedProjectClasspathContainer;

public class PreprocessedProjectClasspathInitializer
extends ClasspathContainerInitializer {
    public boolean canUpdateClasspathContainer(IPath iPath, IJavaProject iJavaProject) {
        boolean bl = false;
        try {
            bl = this.isPreprocessorContainerPath(iPath) && iJavaProject.getProject().hasNature("org.eclipse.mtj.core.preprocessedNature");
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log(2, coreException);
        }
        return bl;
    }

    public void initialize(IPath iPath, IJavaProject iJavaProject) throws CoreException {
        if (this.isPreprocessorContainerPath(iPath)) {
            this.initializeContainer(iPath, iJavaProject);
        }
    }

    public void requestClasspathContainerUpdate(IPath iPath, IJavaProject iJavaProject, IClasspathContainer iClasspathContainer) throws CoreException {
        this.initializeContainer(iPath, iJavaProject);
    }

    private void initializeContainer(IPath iPath, IJavaProject iJavaProject) throws JavaModelException {
        String string = iPath.segment(1);
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
        if (iProject != null && iProject.exists()) {
            IJavaProject iJavaProject2 = JavaCore.create((IProject)iProject);
            IClasspathContainer[] iClasspathContainerArray = new IClasspathContainer[]{new PreprocessedProjectClasspathContainer(iJavaProject2)};
            IJavaProject[] iJavaProjectArray = new IJavaProject[]{iJavaProject};
            JavaCore.setClasspathContainer((IPath)iPath, (IJavaProject[])iJavaProjectArray, (IClasspathContainer[])iClasspathContainerArray, null);
        }
    }

    private boolean isPreprocessorContainerPath(IPath iPath) {
        boolean bl = false;
        if (iPath.segmentCount() == 2) {
            bl = iPath.segment(0).equals("org.eclipse.mtj.core.PP_CONTAINER");
        }
        return bl;
    }
}

