/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.device;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mtj.core.importer.IDeviceImporter;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.device.DeviceImporterElement;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.device.IFoundDevicesList;

public class DeviceFactory {
    public static final String EXT_DEVICE_IMPORTERS = "deviceImporter";
    private static IDeviceImporter[] deviceImporters;

    public static void findDevices(File file, IFoundDevicesList iFoundDevicesList, IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        iProgressMonitor.beginTask("Device Search", -1);
        IDeviceImporter[] iDeviceImporterArray = DeviceFactory.getDeviceImporters();
        DeviceFactory.addDevices(iFoundDevicesList, file, iDeviceImporterArray, iProgressMonitor);
        iProgressMonitor.done();
    }

    private static void addDevices(IFoundDevicesList iFoundDevicesList, File file, IDeviceImporter[] iDeviceImporterArray, IProgressMonitor iProgressMonitor) throws InterruptedException {
        SubProgressMonitor subProgressMonitor;
        SubProgressMonitor subProgressMonitor2;
        if (iProgressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        iProgressMonitor.setTaskName("Searching in " + file);
        IDeviceImporter[] iDeviceImporterArray2 = iDeviceImporterArray;
        int n = iDeviceImporterArray.length;
        int n2 = 0;
        while (n2 < n) {
            subProgressMonitor2 = iDeviceImporterArray2[n2];
            subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
            IDevice[] iDeviceArray = subProgressMonitor2.getMatchingDevices(file, (IProgressMonitor)subProgressMonitor);
            if (iDeviceArray != null) {
                iFoundDevicesList.addDevices(iDeviceArray);
            }
            ++n2;
        }
        subProgressMonitor = subProgressMonitor2 = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        int n3 = ((File[])subProgressMonitor).length;
        n = 0;
        while (n < n3) {
            SubProgressMonitor subProgressMonitor3 = subProgressMonitor[n];
            DeviceFactory.addDevices(iFoundDevicesList, (File)subProgressMonitor3, iDeviceImporterArray, iProgressMonitor);
            ++n;
        }
        iProgressMonitor.worked(1);
    }

    private static IDeviceImporter[] getDeviceImporters() throws CoreException {
        if (deviceImporters == null) {
            deviceImporters = DeviceFactory.readDeviceImporters();
        }
        return deviceImporters;
    }

    private static IDeviceImporter[] readDeviceImporters() throws CoreException {
        String string = MTJCorePlugin.getDefault().getBundle().getSymbolicName();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string, EXT_DEVICE_IMPORTERS);
        DeviceImporterElement[] deviceImporterElementArray = new DeviceImporterElement[iConfigurationElementArray.length];
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            deviceImporterElementArray[n] = new DeviceImporterElement(iConfigurationElementArray[n]);
            ++n;
        }
        Arrays.sort(deviceImporterElementArray, new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                DeviceImporterElement deviceImporterElement = (DeviceImporterElement)object;
                DeviceImporterElement deviceImporterElement2 = (DeviceImporterElement)object2;
                return deviceImporterElement.getPriority() - deviceImporterElement2.getPriority();
            }
        });
        IDeviceImporter[] iDeviceImporterArray = new IDeviceImporter[iConfigurationElementArray.length];
        int n2 = 0;
        while (n2 < deviceImporterElementArray.length) {
            iDeviceImporterArray[n2] = deviceImporterElementArray[n2].getDeviceImporter();
            ++n2;
        }
        return iDeviceImporterArray;
    }

    private DeviceFactory() {
    }
}

