/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.packaging;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.internal.signing.SignatureUtils;
import org.eclipse.mtj.core.internal.utils.ColonDelimitedProperties;
import org.eclipse.mtj.core.model.jad.ApplicationDescriptor;
import org.eclipse.mtj.core.model.jad.IJadSignature;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;

public class DeployedJADWriter {
    private IMidletSuiteProject midletSuite;
    private IFolder deploymentFolder;
    private File deployedJarFile;

    public DeployedJADWriter(IMidletSuiteProject iMidletSuiteProject, IFolder iFolder, File file) {
        this.midletSuite = iMidletSuiteProject;
        this.deploymentFolder = iFolder;
        this.deployedJarFile = file;
    }

    public void writeDeployedJAD(boolean bl, IProgressMonitor iProgressMonitor) throws IOException, CoreException {
        IJadSignature iJadSignature;
        ApplicationDescriptor applicationDescriptor = this.midletSuite.getApplicationDescriptor();
        ColonDelimitedProperties colonDelimitedProperties = applicationDescriptor.getManifestProperties();
        colonDelimitedProperties.setProperty("MIDlet-Jar-Size", Long.valueOf(this.deployedJarFile.length()).toString());
        if (bl) {
            colonDelimitedProperties.setProperty("MIDlet-Jar-URL", this.deployedJarFile.getName());
        }
        this.writeJad(applicationDescriptor);
        if (!bl && (iJadSignature = SignatureUtils.getSignatureObject(this.midletSuite)) != null) {
            this.signJad(iJadSignature, this.deployedJarFile, colonDelimitedProperties);
            this.writeJad(applicationDescriptor);
        }
    }

    private void signJad(IJadSignature iJadSignature, File file, ColonDelimitedProperties colonDelimitedProperties) throws CoreException {
        iJadSignature.computeSignature(file);
        colonDelimitedProperties.setProperty("MIDlet-Jar-RSA-SHA1", iJadSignature.getJarSignatureString());
        String[] stringArray = iJadSignature.getCertificateStrings();
        int n = 1;
        while (n <= stringArray.length) {
            colonDelimitedProperties.setProperty("MIDlet-Certificate-1-" + n, stringArray[n - 1]);
            ++n;
        }
    }

    private void writeJad(ApplicationDescriptor applicationDescriptor) throws IOException {
        IFile iFile = this.deploymentFolder.getFile(this.midletSuite.getJadFileName());
        applicationDescriptor.store(iFile.getLocation().toFile());
    }
}

