/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.configuration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mtj.core.internal.utils.XMLUtils;
import org.eclipse.mtj.core.model.configuration.ConfigDeviceChangeEvent;
import org.eclipse.mtj.core.model.configuration.ConfigNameChangeEvent;
import org.eclipse.mtj.core.model.configuration.ConfigWorkspaceSymbolSetsChangeEvent;
import org.eclipse.mtj.core.model.configuration.ConfigurationsUtils;
import org.eclipse.mtj.core.model.configuration.IConfigurationChangeListener;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSet;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSetRegistry;
import org.eclipse.mtj.core.model.preprocessor.symbol.Symbol;
import org.eclipse.mtj.core.model.preprocessor.symbol.SymbolSet;
import org.eclipse.mtj.core.model.preprocessor.symbol.SymbolSetFactory;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ACTIVE = "active";
    public static final String ELEM_DEVICE = "device";
    public static final String ATTR_DEVICEGROUP = "group";
    public static final String ATTR_DEVICENAME = "name";
    public static final String ELEM_SYMBOL_SET = "symbolSet";
    public static final String ELEM_WORKSPACE_SYMBOLSET = "workspaceSymbolSet";
    public static final String ELEM_SYMBOL = "symbol";
    public static final String ATTR_VALUE = "value";
    private String name;
    private boolean active;
    private IDevice device;
    private SymbolSet symbolSet;
    private List<SymbolDefinitionSet> workspaceScopeSymbolSets;
    private List<IConfigurationChangeListener> listeners = new ArrayList<IConfigurationChangeListener>();

    public Configuration(Element element) throws PersistenceException {
        this.name = element.getAttribute("name");
        this.active = Boolean.valueOf(element.getAttribute(ATTR_ACTIVE));
        this.loadDevice(element);
        this.loadSymbolSet(element);
        this.loadWorkspaceSymbolSets(element);
    }

    public Configuration(String string) {
        this.name = string;
    }

    public void addConfigChangeListener(IConfigurationChangeListener iConfigurationChangeListener) {
        this.listeners.add(iConfigurationChangeListener);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Configuration configuration = (Configuration)object;
        return !(this.name == null ? configuration.name != null : !this.name.equals(configuration.name));
    }

    public void fireSymbolSetChanged() {
        for (IConfigurationChangeListener iConfigurationChangeListener : this.listeners) {
            iConfigurationChangeListener.symbolSetChanged();
        }
    }

    public IDevice getDevice() {
        return this.device;
    }

    public String getName() {
        return this.name;
    }

    public SymbolSet getSymbolSet() {
        if (this.symbolSet == null) {
            this.symbolSet = new SymbolSet();
        }
        return this.symbolSet;
    }

    public SymbolSet getSymbolSetForPreprocessing() {
        SymbolSet symbolSet = new SymbolSet();
        symbolSet.addAll(this.symbolSet);
        String string = this.getName().replace(' ', '_');
        string = SymbolSetFactory.replaceFirstNonLetterChar(string);
        Symbol symbol = new Symbol(string, "true");
        symbol.setType(1);
        symbolSet.add(symbol);
        return symbolSet;
    }

    public List<SymbolDefinitionSet> getWorkspaceScopeSymbolSets() {
        if (this.workspaceScopeSymbolSets == null) {
            this.workspaceScopeSymbolSets = new ArrayList<SymbolDefinitionSet>();
        }
        return this.workspaceScopeSymbolSets;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean isActive() {
        return this.active;
    }

    private void loadDevice(Element element) throws PersistenceException {
        Element element2 = XMLUtils.getFirstElementWithTagName(element, ELEM_DEVICE);
        if (element2 != null) {
            String string = element2.getAttribute(ATTR_DEVICEGROUP);
            String string2 = element2.getAttribute("name");
            this.device = DeviceRegistry.singleton.getDevice(string, string2);
        }
    }

    private void loadSymbolSet(Element element) {
        this.symbolSet = this.getSymbolSet();
        Element element2 = XMLUtils.getFirstElementWithTagName(element, ELEM_SYMBOL_SET);
        NodeList nodeList = element2.getElementsByTagName(ELEM_SYMBOL);
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element3 = (Element)nodeList.item(n);
            String string = element3.getAttribute("name");
            String string2 = element3.getAttribute(ATTR_VALUE);
            Symbol symbol = new Symbol(string, string2);
            this.symbolSet.add(symbol);
            ++n;
        }
    }

    private void loadWorkspaceSymbolSets(Element element) throws PersistenceException {
        NodeList nodeList = element.getElementsByTagName(ELEM_WORKSPACE_SYMBOLSET);
        if (nodeList == null || nodeList.getLength() == 0) {
            return;
        }
        this.workspaceScopeSymbolSets = new ArrayList<SymbolDefinitionSet>();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            String string = element2.getAttribute("name");
            SymbolDefinitionSet symbolDefinitionSet = SymbolDefinitionSetRegistry.singleton.getSymbolDefinitionSet(string);
            if (symbolDefinitionSet != null) {
                this.workspaceScopeSymbolSets.add(symbolDefinitionSet);
            }
            ++n;
        }
    }

    public void removeConfigChangeListener(IConfigurationChangeListener iConfigurationChangeListener) {
        this.listeners.remove(iConfigurationChangeListener);
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setDevice(IDevice iDevice) {
        if (this.device == iDevice) {
            return;
        }
        IDevice iDevice2 = this.device;
        this.device = iDevice;
        ConfigDeviceChangeEvent configDeviceChangeEvent = new ConfigDeviceChangeEvent(this, iDevice2, iDevice);
        for (IConfigurationChangeListener iConfigurationChangeListener : this.listeners) {
            iConfigurationChangeListener.deviceChanged(configDeviceChangeEvent);
        }
    }

    public void setName(String string) {
        if (this.name.equals(string)) {
            return;
        }
        String string2 = this.name;
        this.name = string;
        ConfigNameChangeEvent configNameChangeEvent = new ConfigNameChangeEvent(this, string2, string);
        for (IConfigurationChangeListener iConfigurationChangeListener : this.listeners) {
            iConfigurationChangeListener.nameChanged(configNameChangeEvent);
        }
    }

    public void setSymbolSet(SymbolSet symbolSet) {
        this.symbolSet = symbolSet;
    }

    public void setWorkspaceScopeSymbolSets(List<SymbolDefinitionSet> list) {
        if (ConfigurationsUtils.workspaceSymbolsetsEquals(this.workspaceScopeSymbolSets, list)) {
            return;
        }
        List<SymbolDefinitionSet> list2 = this.workspaceScopeSymbolSets;
        this.workspaceScopeSymbolSets = list;
        ConfigWorkspaceSymbolSetsChangeEvent configWorkspaceSymbolSetsChangeEvent = new ConfigWorkspaceSymbolSetsChangeEvent(this, list2, list);
        for (IConfigurationChangeListener iConfigurationChangeListener : this.listeners) {
            iConfigurationChangeListener.workspaceScopeSymbolSetsChanged(configWorkspaceSymbolSetsChangeEvent);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("name=").append(this.name).append("|active=").append(this.active).append("|device=").append(this.device).append("|symbolSet=").append(this.symbolSet);
        return stringBuffer.toString();
    }
}

