/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.preprocessor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.mtj.core.model.preprocessor.symbol.SymbolUtils;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolDefinitionSet
implements IPersistable {
    private static final String NAME_KEY = "mtjName";
    private static final String KEYS_KEY = "mtjKeys";
    private String name;
    private HashMap<String, String> map;

    public SymbolDefinitionSet() {
        this(null);
    }

    public SymbolDefinitionSet(String string) {
        this.name = string;
        this.map = new HashMap();
    }

    public void define(String string) {
        this.define(string, "true");
    }

    public void define(String string, String string2) {
        this.map.put(string, string2);
    }

    public boolean equals(Object object) {
        return object instanceof SymbolDefinitionSet && this.equals((SymbolDefinitionSet)object);
    }

    public boolean equals(SymbolDefinitionSet symbolDefinitionSet) {
        return this.safeEquals(this.name, symbolDefinitionSet.name) && this.safeEquals(this.map, symbolDefinitionSet.map);
    }

    public Map<String, String> getDefinedSymbols() {
        return new HashMap<String, String>(this.map);
    }

    public String getName() {
        return this.name;
    }

    String getStorableName() {
        return this.name.replaceAll("\\ ", "_");
    }

    public String getValue(String string) {
        return this.map.get(string);
    }

    public int hashCode() {
        return this.safeHash(this.name) ^ this.safeHash(this.map);
    }

    public boolean isDefined(String string) {
        return this.map.containsKey(string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        String[] stringArray;
        this.name = iPersistenceProvider.loadString(NAME_KEY);
        this.map.clear();
        String string = iPersistenceProvider.loadString(KEYS_KEY + this.getStorableName());
        if (string != null && string.length() > 0) {
            void string4;
            String[] stringArray2 = stringArray = string.split(",");
            int n = stringArray.length;
            boolean n2 = false;
            while (string4 < n) {
                String string2 = stringArray2[string4];
                String string3 = iPersistenceProvider.loadString(string2);
                this.map.put(string2, string3);
                ++string4;
            }
        }
        if ((stringArray = iPersistenceProvider.loadProperties(KEYS_KEY)) != null) {
            for (String string4 : stringArray.keySet()) {
                String string5 = stringArray.getProperty(string4);
                this.map.put(string4, string5);
            }
        }
    }

    private boolean safeEquals(Object object, Object object2) {
        boolean bl = false;
        if (object == null && object2 == null) {
            bl = true;
        } else if (object != null && object2 != null) {
            bl = object.equals(object2);
        }
        return bl;
    }

    private int safeHash(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public void setDefinitions(Map<String, String> map) {
        this.map = new HashMap<String, String>(map);
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        iPersistenceProvider.storeString(NAME_KEY, this.name);
        Iterator<Map.Entry<String, String>> iterator = this.map.entrySet().iterator();
        Properties properties = new Properties();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            properties.put(entry.getKey(), entry.getValue());
        }
        iPersistenceProvider.storeProperties(KEYS_KEY, properties);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Map.Entry<String, String>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            stringBuffer.append(entry.getKey()).append("=").append(SymbolUtils.getSafeSymbolValue(entry.getValue()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public void undefine(String string) {
        this.map.remove(string);
    }
}

