/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.core.api;

import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.internal.jmunit.core.api.AbstractTestWriter;
import org.eclipse.osgi.util.NLS;

public class TestSuiteWriter
extends AbstractTestWriter {
    private String suiteName;

    public TestSuiteWriter(IType iType, String string) throws JavaModelException {
        super(iType);
        this.suiteName = string;
    }

    public void writeCode(String[] stringArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        this.writeConstructor(iProgressMonitor);
        this.writeSuiteSetup(stringArray, iProgressMonitor);
    }

    private IMethod writeConstructor(IProgressMonitor iProgressMonitor) throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[]{"TestSuite Class constructor initializes the test suite."};
        this.writeMethodComment(stringBuffer, stringArray, this.delimiter);
        String string = NLS.bind((String)"public {0}()", (Object)this.type.getElementName());
        String[] stringArray2 = new String[]{NLS.bind((String)"super(\"{0}\");", (Object)this.suiteName), "this.setupSuite();"};
        this.writeMethodDeclaration(stringBuffer, string, stringArray2, this.delimiter);
        return this.type.createMethod(stringBuffer.toString(), null, false, iProgressMonitor);
    }

    private IMethod writeSuiteSetup(String[] stringArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray2 = new String[]{"This method adds all suite test cases to be run."};
        this.writeMethodComment(stringBuffer, stringArray2, this.delimiter);
        String string = "private void setupSuite()";
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("//$JMUnit-BEGIN$");
        String[] stringArray3 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray3[n2];
            linkedList.add(NLS.bind((String)"add(new {0}());", (Object)string2));
            ++n2;
        }
        linkedList.add("//$JMUnit-END$");
        this.writeMethodDeclaration(stringBuffer, string, linkedList.toArray(new String[linkedList.size()]), this.delimiter);
        return this.type.createMethod(stringBuffer.toString(), null, false, iProgressMonitor);
    }
}

