/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.internal.jmunit.core.api.JMUnitTestFinder;
import org.eclipse.mtj.internal.jmunit.core.api.TestSuiteWriter;
import org.eclipse.mtj.internal.jmunit.ui.actions.Messages;
import org.eclipse.mtj.internal.jmunit.ui.wizards.testsuite.SuiteClassesContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class UpdateJMUnitTestSuiteAction
implements IObjectActionDelegate {
    private ICompilationUnit testSuite;

    public static IType[] findAllTests(IPackageFragmentRoot[] iPackageFragmentRootArray, IType[] iTypeArray) throws CoreException {
        IPackageFragmentRoot iPackageFragmentRoot;
        HashSet<IType> hashSet = new HashSet<IType>();
        JMUnitTestFinder jMUnitTestFinder = null;
        IPackageFragmentRoot[] iPackageFragmentRootArray2 = iPackageFragmentRootArray;
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            iPackageFragmentRoot = iPackageFragmentRootArray2[n2];
            if (iPackageFragmentRoot.getKind() == 1) {
                jMUnitTestFinder = new JMUnitTestFinder("jmunit.framework.cldc11.TestCase");
                jMUnitTestFinder.findTestsInContainer((IJavaElement)iPackageFragmentRoot, hashSet, null);
            }
            ++n2;
        }
        iPackageFragmentRootArray2 = iTypeArray;
        n = iTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            iPackageFragmentRoot = iPackageFragmentRootArray2[n2];
            if (hashSet.contains(iPackageFragmentRoot)) {
                hashSet.remove(iPackageFragmentRoot);
            }
            ++n2;
        }
        return hashSet.toArray(new IType[hashSet.size()]);
    }

    public void run(IAction iAction) {
        try {
            IType iType = this.testSuite.findPrimaryType();
            ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType iType2 = iTypeHierarchy.getSuperclass(iType);
            if (iType2.getFullyQualifiedName().equals("jmunit.framework.cldc11.TestSuite")) {
                TestsContentProvider testsContentProvider = new TestsContentProvider(new IType[]{iType});
                JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
                ListSelectionDialog listSelectionDialog = new ListSelectionDialog(Display.getDefault().getActiveShell(), (Object)this.testSuite.getJavaProject(), (IStructuredContentProvider)testsContentProvider, (ILabelProvider)javaElementLabelProvider, Messages.UpdateJMUnitTestSuiteAction_UpdateTestSuiteTests);
                listSelectionDialog.setTitle(Messages.UpdateJMUnitTestSuiteAction_UpdateTestSuite);
                listSelectionDialog.setInitialSelections((Object[])this.findSuiteTests(iType));
                int n = listSelectionDialog.open();
                if (n == 0) {
                    this.updateTestSuiteSetupMethod(iType, listSelectionDialog.getResult());
                }
            }
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.UpdateJMUnitTestSuiteAction_ErrorUpdatingTestSuite, (String)coreException.getMessage());
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        StructuredSelection structuredSelection;
        Object object;
        if (iSelection instanceof StructuredSelection && (object = (structuredSelection = (StructuredSelection)iSelection).getFirstElement()) instanceof ICompilationUnit) {
            this.testSuite = (ICompilationUnit)object;
        }
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    private String buildSetupSuiteMarkerExp() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("//");
        stringBuffer.append("(\\s)*");
        stringBuffer.append("JMUnit-BEGIN");
        stringBuffer.append("(.)*");
        stringBuffer.append("//");
        stringBuffer.append("(\\s)*");
        stringBuffer.append("JMUnit-END");
        return stringBuffer.toString();
    }

    private IType[] findSuiteTests(IType iType) throws CoreException {
        IType[] iTypeArray = new IType[]{};
        IMethod iMethod = iType.getMethod("setupSuite", new String[0]);
        if (iMethod != null) {
            Pattern pattern = Pattern.compile(this.buildSetupSuiteMarkerExp(), 40);
            Matcher matcher = pattern.matcher(iMethod.getSource());
            if (matcher.find()) {
                StringBuffer stringBuffer = new StringBuffer(matcher.group());
                int n = 0;
                int n2 = 0;
                n2 = stringBuffer.indexOf("JMUnit-BEGIN") + "JMUnit-BEGIN".length();
                stringBuffer.delete(0, n2);
                n = stringBuffer.indexOf("//");
                n2 = stringBuffer.indexOf("JMUnit-END", n) + "JMUnit-END".length();
                stringBuffer.delete(n, n2);
                iTypeArray = this.parseSetupSuite(stringBuffer, iType.getJavaProject());
            } else {
                MTJCorePlugin.throwCoreException((int)4, (int)-999, (String)Messages.UpdateJMUnitTestSuiteAction_MarkersNotFound);
            }
        }
        return iTypeArray;
    }

    private IType[] parseSetupSuite(StringBuffer stringBuffer, IJavaProject iJavaProject) throws CoreException {
        int n;
        IType[] iTypeArray;
        IType iType;
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<IType> linkedList2 = new LinkedList<IType>();
        String string = stringBuffer.toString();
        IType iType2 = iType = string.split(System.getProperty("line.separator"));
        int n2 = ((String[])iType2).length;
        int n3 = 0;
        while (n3 < n2) {
            iTypeArray = iType2[n3];
            String string2 = iTypeArray.trim();
            if (string2.length() > 0) {
                n = string2.indexOf("new ") + "new ".length();
                int n4 = string2.indexOf("(", n);
                String string3 = string2.substring(n, n4);
                linkedList.add(string3);
            }
            ++n3;
        }
        iTypeArray = UpdateJMUnitTestSuiteAction.findAllTests(iJavaProject.getPackageFragmentRoots(), new IType[0]);
        block1: for (String string4 : linkedList) {
            IType[] iTypeArray2 = iTypeArray;
            n = iTypeArray.length;
            int n5 = 0;
            while (n5 < n) {
                iType2 = iTypeArray2[n5];
                if (iType2.getFullyQualifiedName().equals(string4)) {
                    linkedList2.add(iType2);
                    continue block1;
                }
                ++n5;
            }
        }
        return linkedList2.toArray(new IType[linkedList2.size()]);
    }

    private void updateTestSuiteSetupMethod(IType iType, Object[] objectArray) throws JavaModelException {
        Object object;
        LinkedList<String> linkedList = new LinkedList<String>();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = objectArray2[n2];
            IType iType2 = (IType)object;
            linkedList.add(iType2.getFullyQualifiedName());
            ++n2;
        }
        object = new TestSuiteWriter(iType, iType.getElementName());
        ((TestSuiteWriter)object).updateSetupSuiteMethod(linkedList.toArray(new String[linkedList.size()]), (IProgressMonitor)new NullProgressMonitor());
    }

    private class TestsContentProvider
    extends SuiteClassesContentProvider {
        private IType[] exclusion;

        public TestsContentProvider(IType[] iTypeArray) {
            this.exclusion = iTypeArray == null ? new IType[0] : iTypeArray;
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = super.getElements(object);
            ArrayList arrayList = new ArrayList(Arrays.asList(objectArray));
            IType[] iTypeArray = this.exclusion;
            int n = this.exclusion.length;
            int n2 = 0;
            while (n2 < n) {
                IType iType = iTypeArray[n2];
                if (arrayList.contains(iType)) {
                    arrayList.remove(iType);
                }
                ++n2;
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

