/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.microemu;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.core.model.LaunchEnvironment;
import org.eclipse.mtj.core.model.ReplaceableParametersProcessor;
import org.eclipse.mtj.core.model.device.impl.JavaEmulatorDevice;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.toolkit.microemu.internal.MicroEmuDeviceSkin;

public class MicroEmuDevice
extends JavaEmulatorDevice {
    private File root;
    private MicroEmuDeviceSkin skin;

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor iProgressMonitor) throws CoreException {
        IMidletSuiteProject iMidletSuiteProject = launchEnvironment.getMidletSuite();
        ILaunchConfiguration iLaunchConfiguration = launchEnvironment.getLaunchConfiguration();
        boolean bl = this.shouldDirectLaunchJAD(iLaunchConfiguration);
        File file = this.copyForLaunch(iMidletSuiteProject, iProgressMonitor, bl);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("executable", this.getJavaExecutable());
        hashMap.put("toolkitroot", this.root);
        hashMap.put("skinJarFile", this.skin.getJarFile());
        hashMap.put("skinPathInJar", this.skin.getPath());
        hashMap.put("pathSeparator", System.getProperty("path.separator"));
        if (launchEnvironment.isDebugLaunch()) {
            hashMap.put("debugPort", new Integer(launchEnvironment.getDebugListenerPort()));
        }
        hashMap.put("userSpecifiedArguments", iLaunchConfiguration.getAttribute("mtj.launch_params", ""));
        if (bl) {
            hashMap.put("jadfile", this.getSpecifiedJadURL(iLaunchConfiguration));
        } else {
            File file2 = this.getJadForLaunch(iMidletSuiteProject, file, iProgressMonitor);
            if (file2.exists()) {
                hashMap.put("jadfile", file2.toString());
            }
        }
        return ReplaceableParametersProcessor.processReplaceableValues((String)this.launchCommandTemplate, hashMap);
    }

    public File getRoot() {
        return this.root;
    }

    public MicroEmuDeviceSkin getSkin() {
        return this.skin;
    }

    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.loadUsing(iPersistenceProvider);
        String string = iPersistenceProvider.loadString("toolkitRoot");
        this.root = new File(string);
        String string2 = iPersistenceProvider.loadString("skinJar");
        String string3 = iPersistenceProvider.loadString("skinPathInJar");
        String string4 = iPersistenceProvider.loadString("skinName");
        this.skin = new MicroEmuDeviceSkin(string2, string3, string4);
    }

    public void setRoot(File file) {
        this.root = file;
    }

    public void setSkin(MicroEmuDeviceSkin microEmuDeviceSkin) {
        this.skin = microEmuDeviceSkin;
    }

    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.storeUsing(iPersistenceProvider);
        iPersistenceProvider.storeString("toolkitRoot", this.root.toString());
        iPersistenceProvider.storeString("skinJar", this.skin.getJarFile());
        iPersistenceProvider.storeString("skinPathInJar", this.skin.getPath());
        iPersistenceProvider.storeString("skinName", this.skin.getName());
    }
}

