/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.uei;

import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.mtj.core.importer.JavadocDetector;
import org.eclipse.mtj.core.importer.LibraryImporter;
import org.eclipse.mtj.core.model.Classpath;
import org.eclipse.mtj.core.model.LaunchEnvironment;
import org.eclipse.mtj.core.model.ReplaceableParametersProcessor;
import org.eclipse.mtj.core.model.device.IDevice2;
import org.eclipse.mtj.core.model.device.impl.AbstractDevice;
import org.eclipse.mtj.core.model.device.launch.properties.LaunchTemplateProperties;
import org.eclipse.mtj.core.model.preverifier.IPreverifier;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.toolkit.uei.Messages;
import org.eclipse.mtj.toolkit.uei.UeiPlugin;
import org.eclipse.mtj.toolkit.uei.internal.properties.UEIDeviceDefinition;
import org.eclipse.mtj.toolkit.uei.model.properties.DeviceSpecificProperties;

public class UEIDevice
extends AbstractDevice
implements IDevice2 {
    public UEIDevice() {
    }

    public UEIDevice(String string, String string2, String string3, Properties properties, UEIDeviceDefinition uEIDeviceDefinition, File file, IPreverifier iPreverifier) throws IllegalArgumentException {
        if (properties == null) {
            throw new IllegalArgumentException(Messages.UEIDevice_null_properties);
        }
        if (uEIDeviceDefinition == null) {
            throw new IllegalArgumentException(Messages.UEIDevice_null_definition);
        }
        this.setName(string);
        this.setDescription(string3);
        this.setGroupName(string2);
        this.setDeviceProperties(properties);
        this.setClasspath(this.getBootClasspath(properties));
        this.setProtectionDomains(this.getProtectionDomains(properties));
        this.setExecutable(file);
        this.setPreverifier(iPreverifier);
        this.setDebugServer(uEIDeviceDefinition.isDebugServer());
        this.setLaunchCommandTemplate(uEIDeviceDefinition.getLaunchTemplate());
        this.setBundle(UeiPlugin.getDefault().getBundle().getSymbolicName());
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof UEIDevice) {
            bl = this.equals((UEIDevice)((Object)object));
        }
        return bl;
    }

    public boolean equals(UEIDevice uEIDevice) {
        return super.equals((AbstractDevice)uEIDevice) && this.launchCommandTemplate.equals(uEIDevice.launchCommandTemplate);
    }

    private Classpath getBootClasspath(Properties properties) {
        Classpath classpath = new Classpath();
        String string = properties.getProperty(DeviceSpecificProperties.BOOTCLASSPATH.toString(), "");
        String[] stringArray = string.split(",");
        JavadocDetector javadocDetector = new JavadocDetector().addJavadocSearchStrategy((JavadocDetector.IJavadocSearchStrategy)new JavadocDetector.GenericLocalFSSearch());
        LibraryImporter libraryImporter = new LibraryImporter();
        libraryImporter.setJavadocDetector(javadocDetector);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            File file = new File(string2);
            if (file.exists()) {
                classpath.addEntry(libraryImporter.createLibraryFor(file));
            }
            ++n2;
        }
        return classpath;
    }

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        String string;
        boolean bl = Platform.getOS().equals("win32");
        IMidletSuiteProject iMidletSuiteProject = launchEnvironment.getMidletSuite();
        ILaunchConfiguration iLaunchConfiguration = launchEnvironment.getLaunchConfiguration();
        boolean bl2 = this.shouldDirectLaunchJAD(iLaunchConfiguration);
        File file = this.copyForLaunch(iMidletSuiteProject, iProgressMonitor, bl2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(LaunchTemplateProperties.EXECUTABLE.toString(), bl ? this.executable.getName() : this.executable.getAbsolutePath());
        hashMap.put(LaunchTemplateProperties.DEVICE.toString(), this.getName());
        if (launchEnvironment.isDebugLaunch()) {
            hashMap.put(LaunchTemplateProperties.DEBUGPORT.toString(), Integer.toString(launchEnvironment.getDebugListenerPort()));
        }
        if (!bl2) {
            string = this.getProjectClasspathString(launchEnvironment.getMidletSuite(), file, iProgressMonitor);
            hashMap.put(LaunchTemplateProperties.CLASSPATH.toString(), string);
        }
        this.addLaunchConfigurationValue(hashMap, LaunchTemplateProperties.VERBOSE.toString(), iLaunchConfiguration, "mtj.verbosity_options");
        this.addLaunchConfigurationValue(hashMap, LaunchTemplateProperties.HEAPSIZE.toString(), iLaunchConfiguration, "mtj.heap_size");
        string = iLaunchConfiguration.getAttribute("mtj.security_domain", "None");
        if (!string.equals("None")) {
            hashMap.put(LaunchTemplateProperties.SECURITYDOMAIN.toString(), string);
        }
        String string2 = iLaunchConfiguration.getAttribute("mtj.launch_params", "");
        hashMap.put(LaunchTemplateProperties.USERSPECIFIEDARGUMENTS.toString(), string2);
        if (bl2) {
            hashMap.put(LaunchTemplateProperties.JADFILE.toString(), this.getSpecifiedJadURL(iLaunchConfiguration));
        } else if (this.shouldDoOTA(iLaunchConfiguration)) {
            object = this.getOTAURL(iLaunchConfiguration, iMidletSuiteProject);
            hashMap.put(LaunchTemplateProperties.OTAURL.toString(), object);
        } else {
            object = this.getJadForLaunch(iMidletSuiteProject, file, iProgressMonitor);
            if (((File)object).exists()) {
                hashMap.put(LaunchTemplateProperties.JADFILE.toString(), ((File)object).toString());
            }
            this.addLaunchConfigurationValue(hashMap, LaunchTemplateProperties.TARGET.toString(), iLaunchConfiguration, IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME);
        }
        object = ReplaceableParametersProcessor.processReplaceableValues((String)this.launchCommandTemplate, hashMap);
        return bl ? "cmd /c " + (String)object : object;
    }

    private String[] getProtectionDomains(Properties properties) {
        String string = properties.getProperty(DeviceSpecificProperties.SECURITY_DOMAINS.toString(), "");
        return string.split(",");
    }

    public File getWorkingDirectory() {
        return this.executable.getParentFile();
    }

    public int hashCode() {
        return this.classpath.hashCode() ^ this.executable.hashCode() ^ this.name.hashCode() ^ this.launchCommandTemplate.hashCode() ^ this.groupName.hashCode();
    }
}

