/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.uei.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import org.eclipse.mtj.toolkit.uei.Messages;
import org.eclipse.mtj.toolkit.uei.UeiPlugin;
import org.eclipse.mtj.toolkit.uei.internal.properties.UEIDeviceDefinition;

public class DeviceDefinitionManager {
    public static final String PROPS_FILE = "uei_device.properties";
    private static final String DEVICES = "devices";
    private static DeviceDefinitionManager instance;
    private List<UEIDeviceDefinition> deviceDefinitions = null;

    public static synchronized DeviceDefinitionManager getInstance() {
        if (instance == null) {
            instance = new DeviceDefinitionManager();
        }
        return instance;
    }

    private DeviceDefinitionManager() {
        if (this.deviceDefinitions == null) {
            this.initializeDeviceDefinitions();
        }
    }

    public UEIDeviceDefinition getDeviceDefinition(String string) {
        UEIDeviceDefinition uEIDeviceDefinition = null;
        Iterator<UEIDeviceDefinition> iterator = this.deviceDefinitions.iterator();
        while (iterator.hasNext() && uEIDeviceDefinition == null) {
            UEIDeviceDefinition uEIDeviceDefinition2 = iterator.next();
            Matcher matcher = uEIDeviceDefinition2.getMatchPattern().matcher(string);
            if (!matcher.find()) continue;
            uEIDeviceDefinition = uEIDeviceDefinition2;
        }
        return uEIDeviceDefinition;
    }

    private InputStream getUEIDevicesPropertiesStream() {
        InputStream inputStream = null;
        try {
            URL uRL = UeiPlugin.getDefault().getBundle().getEntry(PROPS_FILE);
            if (uRL != null) {
                inputStream = uRL.openStream();
            } else {
                UeiPlugin.debugLog(Messages.UEIDeviceImporter_getUEIDevicesPropertiesStream_file_not_found);
            }
        }
        catch (IllegalStateException illegalStateException) {
            UeiPlugin.debugLog(Messages.UEIDeviceImporter_getUEIDevicesPropertiesStream_IllegalState, illegalStateException);
        }
        catch (IOException iOException) {
            UeiPlugin.debugLog(Messages.UEIDeviceImporter_getUEIDevicesPropertiesStream_IOError, iOException);
        }
        return inputStream;
    }

    private void initializeDeviceDefinitions() {
        this.deviceDefinitions = new ArrayList<UEIDeviceDefinition>();
        Properties properties = new Properties();
        InputStream inputStream = this.getUEIDevicesPropertiesStream();
        if (inputStream != null) {
            block21: {
                try {
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                    UeiPlugin.debugLog(Messages.DeviceDefinitionManager_failed_reading_file, iOException);
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        UeiPlugin.debugLog(Messages.DeviceDefinitionManager_readDeviceDefinitions_closeStream_fail);
                    }
                    break block21;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        UeiPlugin.debugLog(Messages.DeviceDefinitionManager_malformed_unicode_esc_seq, illegalArgumentException);
                    }
                    catch (Throwable throwable) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            UeiPlugin.debugLog(Messages.DeviceDefinitionManager_readDeviceDefinitions_closeStream_fail);
                        }
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        UeiPlugin.debugLog(Messages.DeviceDefinitionManager_readDeviceDefinitions_closeStream_fail);
                    }
                    break block21;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    UeiPlugin.debugLog(Messages.DeviceDefinitionManager_readDeviceDefinitions_closeStream_fail);
                }
            }
            String string = properties.getProperty(DEVICES, "");
            if (!string.equals("")) {
                String[] stringArray;
                String[] stringArray2 = stringArray = string.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray2[n2];
                    try {
                        this.deviceDefinitions.add(new UEIDeviceDefinition(string2, properties));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        UeiPlugin.debugLog(illegalArgumentException.getMessage(), illegalArgumentException);
                    }
                    catch (NullPointerException nullPointerException) {
                        UeiPlugin.debugLog(nullPointerException.getMessage(), nullPointerException);
                    }
                    ++n2;
                }
            } else {
                UeiPlugin.debugLog(Messages.DeviceDefinitionManager_readDeviceDefinitions_invalid_file);
            }
        }
    }
}

