/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.editors.jad.form;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.ui.editors.jad.AbstractJADEditorPage;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.editors.jad.form.JADEditorPageConfigElement;
import org.eclipse.mtj.ui.internal.editors.jad.form.pages.JADSourceEditorPage;
import org.eclipse.mtj.ui.internal.editors.jad.form.pages.OverviewEditorPage;
import org.eclipse.mtj.ui.internal.utils.ManifestPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class JADFormEditor
extends FormEditor {
    private static JADEditorPageConfigElement[] jadEditorPageConfigElements;
    private boolean cleanRequired;
    private List<AbstractJADEditorPage> configPages = new ArrayList<AbstractJADEditorPage>();
    private JADSourceEditorPage sourceEditor;
    private IFile jadFile;
    private long modificationStamp;
    private ManifestPreferenceStore preferenceStore;

    public void doSave(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask("Saving Application descriptor", this.getPageCount() + 1);
        boolean bl = this.sourceEditor.isDirty();
        int n = 0;
        for (AbstractJADEditorPage abstractJADEditorPage : this.configPages) {
            AbstractJADEditorPage abstractJADEditorPage2;
            if (abstractJADEditorPage instanceof IFormPage && (abstractJADEditorPage2 = abstractJADEditorPage) != null && abstractJADEditorPage2.getPartControl() != null) {
                if (abstractJADEditorPage2.isDirty() && !bl) {
                    abstractJADEditorPage2.doSave(iProgressMonitor);
                    iProgressMonitor.subTask("Saving " + abstractJADEditorPage2.getTitle() + " page");
                } else {
                    iProgressMonitor.subTask("Ignoring " + abstractJADEditorPage2.getTitle() + " page");
                    abstractJADEditorPage2.setDirty(false);
                }
            }
            iProgressMonitor.worked(n + 1);
        }
        if (bl) {
            this.sourceEditor.doSave(iProgressMonitor);
            this.updateEditorInput();
            iProgressMonitor.subTask("Saving " + this.sourceEditor.getTitle() + " page");
            iProgressMonitor.worked(n + 1);
        }
        try {
            if (this.jadFile.exists() && this.jadFile.isReadOnly()) {
                AbstractJADEditorPage abstractJADEditorPage;
                abstractJADEditorPage = this.jadFile.getResourceAttributes();
                abstractJADEditorPage.setReadOnly(false);
                this.jadFile.setResourceAttributes((ResourceAttributes)abstractJADEditorPage);
            }
            this.preferenceStore.save();
            if (this.jadFile != null && this.jadFile.exists()) {
                this.jadFile.refreshLocal(0, iProgressMonitor);
            }
            if (this.jadFile != null && this.cleanRequired) {
                this.jadFile.getProject().build(15, iProgressMonitor);
            }
        }
        catch (IOException iOException) {
            MTJCorePlugin.log((int)4, (Throwable)iOException);
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)4, (Throwable)coreException);
        }
        iProgressMonitor.done();
        this.editorDirtyStateChanged();
        this.reloadLocalFile();
    }

    public void doSaveAs() {
    }

    public IFile getJadFile() {
        return this.jadFile;
    }

    public ManifestPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public boolean isDirty() {
        boolean bl = false;
        for (Object e : this.pages) {
            IFormPage iFormPage;
            if (!(e instanceof IFormPage) || (iFormPage = (IFormPage)e) == null || iFormPage.getPartControl() == null || !iFormPage.isDirty()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isUserDefinedPropertyKey(String string) {
        for (AbstractJADEditorPage abstractJADEditorPage : this.configPages) {
            if (abstractJADEditorPage == null || !abstractJADEditorPage.isManagingProperty(string)) continue;
            return false;
        }
        return true;
    }

    public void setCleanRequired(boolean bl) {
        this.cleanRequired = bl;
    }

    public void setFocus() {
        File file = this.getLocalFile();
        if (file != null && file.lastModified() > this.modificationStamp && this.shouldReloadLocalFile()) {
            this.reloadLocalFile();
        }
        super.setFocus();
    }

    private JADEditorPageConfigElement[] getAllEditorPageConfigElements() {
        if (jadEditorPageConfigElements == null) {
            jadEditorPageConfigElements = this.readAllVendorSpecJADAttributes();
        }
        return jadEditorPageConfigElements;
    }

    private File getLocalFile() {
        return this.jadFile.getLocation().toFile();
    }

    private JADEditorPageConfigElement[] readAllVendorSpecJADAttributes() {
        String string = MTJUIPlugin.getDefault().getBundle().getSymbolicName();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(string, "jadEditorPages");
        JADEditorPageConfigElement[] jADEditorPageConfigElementArray = new JADEditorPageConfigElement[iConfigurationElementArray.length];
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            jADEditorPageConfigElementArray[n] = new JADEditorPageConfigElement(iConfigurationElementArray[n]);
            ++n;
        }
        return jADEditorPageConfigElementArray;
    }

    private void reloadLocalFile() {
        this.updateEditorInput();
        for (AbstractJADEditorPage abstractJADEditorPage : this.configPages) {
            if (abstractJADEditorPage == null) continue;
            abstractJADEditorPage.editorInputChanged();
        }
    }

    private boolean shouldReloadLocalFile() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"File Updated", (String)"The file has been updated.  Would you like to reload?");
    }

    private void updateEditorInput() {
        File file = this.getLocalFile();
        this.modificationStamp = file.lastModified();
        String string = file.toString();
        this.preferenceStore = new ManifestPreferenceStore(string);
        try {
            this.preferenceStore.load();
        }
        catch (IOException iOException) {
            MTJCorePlugin.log((int)2, (Throwable)iOException);
        }
    }

    protected void addPages() {
        Object object;
        super.setPartName(this.jadFile.getProject().getName());
        JADEditorPageConfigElement[] jADEditorPageConfigElementArray = this.getAllEditorPageConfigElements();
        Arrays.sort(jADEditorPageConfigElementArray, new Comparator<JADEditorPageConfigElement>(){

            @Override
            public int compare(JADEditorPageConfigElement jADEditorPageConfigElement, JADEditorPageConfigElement jADEditorPageConfigElement2) {
                return jADEditorPageConfigElement.getPriority() - jADEditorPageConfigElement2.getPriority();
            }
        });
        try {
            object = new OverviewEditorPage(this);
            this.addPage((IFormPage)object);
            this.configPages.add((AbstractJADEditorPage)((Object)object));
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
        JADEditorPageConfigElement[] jADEditorPageConfigElementArray2 = jADEditorPageConfigElementArray;
        int n = jADEditorPageConfigElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = jADEditorPageConfigElementArray2[n2];
            try {
                AbstractJADEditorPage abstractJADEditorPage = ((JADEditorPageConfigElement)object).getJADEditorPage();
                abstractJADEditorPage.initialize(this);
                this.addPage((IFormPage)abstractJADEditorPage);
                this.configPages.add(abstractJADEditorPage);
            }
            catch (Exception exception) {
                MTJCorePlugin.log((int)4, (Throwable)exception);
            }
            ++n2;
        }
        this.sourceEditor = new JADSourceEditorPage(this);
        try {
            this.addPage((IEditorPart)this.sourceEditor, super.getEditorInput());
        }
        catch (PartInitException partInitException) {
            MTJCorePlugin.log((int)4, (Throwable)partInitException);
        }
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (iEditorInput instanceof IStorageEditorInput) {
            IStorageEditorInput iStorageEditorInput = (IStorageEditorInput)iEditorInput;
            try {
                IPath iPath = iStorageEditorInput.getStorage().getFullPath();
                if (iPath != null) {
                    IWorkspaceRoot iWorkspaceRoot = MTJCorePlugin.getWorkspace().getRoot();
                    this.jadFile = iWorkspaceRoot.getFile(iPath.makeAbsolute());
                    if (this.jadFile != null && this.jadFile.exists()) {
                        this.updateEditorInput();
                    }
                }
            }
            catch (Exception exception) {
                MTJCorePlugin.log((int)2, (Throwable)exception);
            }
        }
    }
}

