/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.wizards.midlet;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.core.model.jad.ApplicationDescriptor;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.MidletSuiteFactory;
import org.eclipse.mtj.ui.MTJUIStrings;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.wizards.midlet.page.NewMidletWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewMidletWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private NewMidletWizardPage midletPage;

    public NewMidletWizard() {
        this.setWindowTitle(MTJUIStrings.getString("wiz.newmidlet.dialogtitle"));
        this.setDialogSettings(MTJUIPlugin.getDialogSettings("NewMidletWizard"));
        this.setDefaultPageImageDescriptor(MTJUIPlugin.getIconImageDescriptor("newclass_wiz_M.gif"));
    }

    public void addPages() {
        this.midletPage = new NewMidletWizardPage();
        this.addPage((IWizardPage)this.midletPage);
        this.midletPage.setWizard((IWizard)this);
        this.midletPage.init(this.selection);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
    }

    public boolean performFinish() {
        boolean bl = true;
        IRunnableWithProgress iRunnableWithProgress = this.getCreateMidletOperation();
        try {
            this.getContainer().run(false, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            bl = false;
        }
        catch (InterruptedException interruptedException) {
            bl = false;
        }
        return bl;
    }

    private void addMidletToJAD(IType iType, IProgressMonitor iProgressMonitor) throws IOException, CoreException {
        IJavaProject iJavaProject = (IJavaProject)iType.getAncestor(2);
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)iJavaProject);
        ApplicationDescriptor applicationDescriptor = iMidletSuiteProject.getApplicationDescriptor();
        if (applicationDescriptor != null) {
            ApplicationDescriptor.MidletDefinition midletDefinition = new ApplicationDescriptor.MidletDefinition(applicationDescriptor.getMidletCount() + 1, iType.getElementName(), "", iType.getFullyQualifiedName());
            applicationDescriptor.addMidletDefinition(midletDefinition);
            applicationDescriptor.store();
            IFile iFile = iMidletSuiteProject.getApplicationDescriptorFile();
            iFile.refreshLocal(1, iProgressMonitor);
        }
    }

    private IRunnableWithProgress getCreateMidletOperation() {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation(NewMidletWizard.this.midletPage.getRunnable());
                workspaceModifyDelegatingOperation.run(iProgressMonitor);
                IType iType = NewMidletWizard.this.midletPage.getCreatedType();
                if (iType != null) {
                    IResource iResource = iType.getResource();
                    if (iResource != null) {
                        BasicNewResourceWizard.selectAndReveal((IResource)iResource, (IWorkbenchWindow)NewMidletWizard.this.workbench.getActiveWorkbenchWindow());
                        NewMidletWizard.this.openResource((IFile)iResource);
                    }
                    if (NewMidletWizard.this.midletPage.isAddToJadSelected()) {
                        try {
                            NewMidletWizard.this.addMidletToJAD(iType, iProgressMonitor);
                        }
                        catch (IOException iOException) {
                            throw new InvocationTargetException(iOException);
                        }
                        catch (CoreException coreException) {
                            throw new InvocationTargetException(coreException);
                        }
                    }
                }
            }
        };
        return new WorkspaceModifyDelegatingOperation(iRunnableWithProgress);
    }

    private void openResource(final IFile iFile) {
        Display display;
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = this.workbench.getActiveWorkbenchWindow().getActivePage()) != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
                    }
                    catch (PartInitException partInitException) {
                        partInitException.printStackTrace();
                    }
                }
            });
        }
    }
}

