/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.preprocess.contentAssistant.template;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.preprocess.contentAssistant.PreprocessContext;
import org.eclipse.mtj.ui.internal.preprocess.contentAssistant.template.PreprocessTemplateFormatter;

public class PreprocessTemplateContext
extends DocumentTemplateContext {
    int ppDirectiveBeginOffset = 0;
    PreprocessContext ppContext;

    public PreprocessTemplateContext(TemplateContextType templateContextType, IDocument iDocument, Position position, PreprocessContext preprocessContext) {
        super(templateContextType, iDocument, position);
        this.ppDirectiveBeginOffset = preprocessContext.getStatementStartOffset();
        this.ppContext = preprocessContext;
    }

    public boolean canEvaluate(Template template) {
        String string = this.getKey();
        return template.matches(string, this.getContextType().getId()) && template.getName().toLowerCase().startsWith(string.toLowerCase());
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        TemplateBuffer templateBuffer = this.evaluateWithoutFormatter(template);
        if (templateBuffer == null) {
            return null;
        }
        IPreferenceStore iPreferenceStore = MTJUIPlugin.getDefault().getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("org.eclipse.mtj.ui.template.format");
        if (bl) {
            IJavaProject iJavaProject = JavaCore.create((IProject)this.ppContext.getContainedProject());
            PreprocessTemplateFormatter preprocessTemplateFormatter = new PreprocessTemplateFormatter();
            preprocessTemplateFormatter.format(templateBuffer, (TemplateContext)this, iJavaProject);
        }
        return templateBuffer;
    }

    public TemplateBuffer evaluateWithoutFormatter(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator templateTranslator = new TemplateTranslator();
        TemplateBuffer templateBuffer = templateTranslator.translate(template);
        this.getContextType().resolve(templateBuffer, (TemplateContext)this);
        return templateBuffer;
    }

    public String getKey() {
        int n = this.getPpDirectiveBeginOffset();
        int n2 = this.getEnd() - n;
        try {
            return this.getDocument().get(n, n2);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public int getPpDirectiveBeginOffset() {
        return this.ppDirectiveBeginOffset;
    }
}

