/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.wizards.dialogfields;

import org.eclipse.mtj.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SelectionButtonDialogField
extends DialogField {
    private DialogField[] fAttachedDialogFields = null;
    private Button fButton;
    private int fButtonStyle;
    private boolean fIsSelected = false;

    public SelectionButtonDialogField(int n) {
        this.fButtonStyle = n;
    }

    public void attachDialogField(DialogField dialogField) {
        this.attachDialogFields(new DialogField[]{dialogField});
    }

    public void attachDialogFields(DialogField[] dialogFieldArray) {
        this.fAttachedDialogFields = dialogFieldArray;
        DialogField[] dialogFieldArray2 = dialogFieldArray;
        int n = dialogFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            DialogField dialogField = dialogFieldArray2[n2];
            dialogField.setEnabled(this.fIsSelected);
            ++n2;
        }
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        Button button = this.getSelectionButton(composite);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        return new Control[]{button};
    }

    public int getNumberOfControls() {
        return 1;
    }

    public Button getSelectionButton(Composite composite) {
        if (this.fButton == null) {
            this.assertCompositeNotNull(composite);
            this.fButton = new Button(composite, this.fButtonStyle);
            this.fButton.setFont(composite.getFont());
            this.fButton.setText(this.fLabelText);
            this.fButton.setEnabled(this.isEnabled());
            this.fButton.setSelection(this.fIsSelected);
            this.fButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    SelectionButtonDialogField.this.doWidgetSelected(selectionEvent);
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SelectionButtonDialogField.this.doWidgetSelected(selectionEvent);
                }
            });
        }
        return this.fButton;
    }

    public boolean isAttached(DialogField dialogField) {
        if (this.fAttachedDialogFields != null) {
            DialogField[] dialogFieldArray = this.fAttachedDialogFields;
            int n = this.fAttachedDialogFields.length;
            int n2 = 0;
            while (n2 < n) {
                DialogField dialogField2 = dialogFieldArray[n2];
                if (dialogField2 == dialogField) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isSelected() {
        return this.fIsSelected;
    }

    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setSelection(this.fIsSelected);
        }
    }

    public void setLabelText(String string) {
        this.fLabelText = string;
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setText(string);
        }
    }

    public void setSelection(boolean bl) {
        this.changeValue(bl);
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setSelection(bl);
        }
    }

    private void changeValue(boolean bl) {
        if (this.fIsSelected != bl) {
            this.fIsSelected = bl;
            if (this.fAttachedDialogFields != null) {
                boolean bl2 = false;
                DialogField[] dialogFieldArray = this.fAttachedDialogFields;
                int n = this.fAttachedDialogFields.length;
                int n2 = 0;
                while (n2 < n) {
                    DialogField dialogField = dialogFieldArray[n2];
                    dialogField.setEnabled(this.fIsSelected);
                    if (this.fIsSelected && !bl2) {
                        bl2 = dialogField.setFocus();
                    }
                    ++n2;
                }
            }
            this.dialogFieldChanged();
        } else if (this.fButtonStyle == 8) {
            this.dialogFieldChanged();
        }
    }

    private void doWidgetSelected(SelectionEvent selectionEvent) {
        if (this.isOkToUse((Control)this.fButton)) {
            this.changeValue(this.fButton.getSelection());
        }
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setEnabled(this.isEnabled());
        }
    }
}

