/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mtj.internal.ui.IPreferenceConstants;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editor.EmptyOutlinePage;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.ToggleLinkWithEditorAction;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class MTJMultiPageContentOutline
extends Page
implements IContentOutlinePage,
ISelectionProvider,
ISelectionChangedListener,
IPreferenceConstants {
    private IActionBars actionBars;
    private ISortableContentOutlinePage currentPage;
    private MTJFormEditor editor;
    private ISortableContentOutlinePage emptyPage;
    private ArrayList<ISelectionChangedListener> listeners;
    private PageBook pagebook;
    private ISelection selection;
    private boolean sortingOn;

    public MTJMultiPageContentOutline(MTJFormEditor mTJFormEditor) {
        this.editor = mTJFormEditor;
        this.listeners = new ArrayList();
        this.sortingOn = MTJUIPlugin.getDefault().getPreferenceStore().getBoolean("PDEMultiPageContentOutline.SortingAction.isChecked");
    }

    public void addFocusListener(FocusListener focusListener) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.add(iSelectionChangedListener);
    }

    public void createControl(Composite composite) {
        this.pagebook = new PageBook(composite, 0);
    }

    public void dispose() {
        if (this.pagebook != null && !this.pagebook.isDisposed()) {
            this.pagebook.dispose();
        }
        if (this.emptyPage != null) {
            this.emptyPage.dispose();
            this.emptyPage = null;
        }
        this.pagebook = null;
        this.listeners = null;
    }

    public IActionBars getActionBars() {
        return this.actionBars;
    }

    public Control getControl() {
        return this.pagebook;
    }

    public PageBook getPagebook() {
        return this.pagebook;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public boolean isDisposed() {
        return this.listeners == null;
    }

    public void makeContributions(IMenuManager iMenuManager, IToolBarManager iToolBarManager, IStatusLineManager iStatusLineManager) {
    }

    public void removeFocusListener(FocusListener focusListener) {
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.remove(iSelectionChangedListener);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.setSelection(selectionChangedEvent.getSelection());
    }

    public void setActionBars(IActionBars iActionBars) {
        this.actionBars = iActionBars;
        this.registerToolbarActions(iActionBars);
        if (this.currentPage != null) {
            this.setPageActive(this.currentPage);
        }
    }

    public void setFocus() {
        if (this.currentPage != null) {
            this.currentPage.setFocus();
        }
    }

    public void setPageActive(ISortableContentOutlinePage iSortableContentOutlinePage) {
        if (iSortableContentOutlinePage == null) {
            iSortableContentOutlinePage = this.getEmptyPage();
        }
        if (this.currentPage != null) {
            this.currentPage.removeSelectionChangedListener(this);
        }
        iSortableContentOutlinePage.sort(this.sortingOn);
        iSortableContentOutlinePage.addSelectionChangedListener(this);
        this.currentPage = iSortableContentOutlinePage;
        if (this.pagebook == null) {
            return;
        }
        Control control = iSortableContentOutlinePage.getControl();
        if (control == null || control.isDisposed()) {
            iSortableContentOutlinePage.createControl((Composite)this.pagebook);
            iSortableContentOutlinePage.setActionBars(this.getActionBars());
            control = iSortableContentOutlinePage.getControl();
        }
        this.pagebook.showPage(control);
        this.currentPage = iSortableContentOutlinePage;
    }

    public void setSelection(ISelection iSelection) {
        this.selection = iSelection;
        if (this.listeners == null) {
            return;
        }
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, iSelection);
        int n = 0;
        while (n < this.listeners.size()) {
            this.listeners.get(n).selectionChanged(selectionChangedEvent);
            ++n;
        }
    }

    private ISortableContentOutlinePage getEmptyPage() {
        if (this.emptyPage == null) {
            this.emptyPage = new EmptyOutlinePage();
        }
        return this.emptyPage;
    }

    private void registerToolbarActions(IActionBars iActionBars) {
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        if (iToolBarManager != null) {
            iToolBarManager.add((IAction)new ToggleLinkWithEditorAction(this.editor));
            iToolBarManager.add((IAction)new SortingAction());
        }
    }

    class SortingAction
    extends Action {
        public SortingAction() {
            this.setText(MTJUIMessages.MTJMultiPageContentOutline_sortingAction_text);
            this.setImageDescriptor(MTJUIPluginImages.DESC_ALPHAB_SORT_CO);
            this.setDisabledImageDescriptor(MTJUIPluginImages.DESC_ALPHAB_SORT_CO_DISABLED);
            this.setToolTipText(MTJUIMessages.MTJMultiPageContentOutline_toolTipText);
            this.setDescription(MTJUIMessages.MTJMultiPageContentOutline_description);
            this.setChecked(MTJMultiPageContentOutline.this.sortingOn);
        }

        public void run() {
            this.setChecked(this.isChecked());
            this.valueChanged(this.isChecked());
        }

        private void valueChanged(boolean bl) {
            MTJMultiPageContentOutline.this.sortingOn = bl;
            if (MTJMultiPageContentOutline.this.currentPage != null) {
                MTJMultiPageContentOutline.this.currentPage.sort(bl);
            }
            MTJUIPlugin.getDefault().getPreferenceStore().setValue("MTJMultiPageContentOutline.SortingAction.isChecked", bl);
        }
    }
}

