/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.core.internal.preprocessor.PreprocessorHelper;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.ui.internal.IEmbeddableWorkbenchPreferencePage;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;

public class PreprocessPreferencePage
extends PreferencePage
implements IEmbeddableWorkbenchPreferencePage {
    private static final String DEBUGLEVEL_NONE = "none";
    private Combo debugLevelCombo;
    private Label debugLevelLabel;
    private boolean embeddedInProperties;

    public PreprocessPreferencePage() {
        this(false, MTJUIPlugin.getDefault().getCorePreferenceStore());
    }

    public PreprocessPreferencePage(boolean bl, IPreferenceStore iPreferenceStore) {
        this.embeddedInProperties = bl;
        this.setPreferenceStore(iPreferenceStore);
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void performApply() {
        super.performApply();
    }

    public void performDefaults() {
        this.setControlsFromDefaults();
        super.performDefaults();
    }

    public boolean performOk() {
        this.setPreferencesFromControls();
        return super.performOk();
    }

    private void addDebugLevelControls(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(MTJUIMessages.PreprocessPreferencePage_debugLevelSettingGroup_label_text);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.debugLevelLabel = new Label((Composite)group, 0);
        this.debugLevelLabel.setFont(composite.getFont());
        this.debugLevelLabel.setText(MTJUIMessages.PreprocessPreferencePage_debugLevel_label_text);
        this.debugLevelCombo = new Combo((Composite)group, 8);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 15;
        this.debugLevelCombo.setLayoutData((Object)gridData);
        String[] stringArray = PreprocessorHelper.getSupportDebugLevels();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = DEBUGLEVEL_NONE;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        this.debugLevelCombo.setItems(stringArray2);
    }

    private void selectDebuglevel(String string) {
        int n = 0;
        String[] stringArray = this.debugLevelCombo.getItems();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            if (string2.equalsIgnoreCase(string)) break;
            ++n;
            ++n3;
        }
        if (n < this.debugLevelCombo.getItems().length) {
            this.debugLevelCombo.select(n);
        }
    }

    private void setControlsFromDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        String string = iPreferenceStore.getDefaultString("preprocess_debuglevel");
        this.selectDebuglevel(string);
    }

    private void setControlsFromPreferences() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        String string = iPreferenceStore.getString("preprocess_debuglevel");
        this.selectDebuglevel(string);
    }

    private void setPreferencesFromControls() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        int n = this.debugLevelCombo.getSelectionIndex();
        iPreferenceStore.setValue("preprocess_debuglevel", this.debugLevelCombo.getItem(n));
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        this.addDebugLevelControls(composite2);
        if (this.embeddedInProperties) {
            this.noDefaultAndApplyButton();
        }
        this.setControlsFromPreferences();
        return composite2;
    }
}

