/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.launching.midp.ota;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.launching.midp.ota.OTAHandler;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.NotFoundHandler;
import org.mortbay.log.LogImpl;
import org.mortbay.log.LogSink;
import org.mortbay.log.OutputStreamLogSink;

public class OTAServer {
    private static OTAServer instance;
    private HttpServer httpServer;
    private LogImpl logImpl = new LogImpl();
    private HttpServer server = this.getHttpServer();

    public static synchronized OTAServer getInstance() {
        if (instance == null) {
            instance = new OTAServer();
        }
        return instance;
    }

    public static synchronized int getPort() {
        HttpListener httpListener = OTAServer.getInstance().getHttpServer().getListeners()[0];
        return httpListener.getPort();
    }

    private OTAServer() {
    }

    public synchronized void start() throws Exception {
        if (!this.server.isStarted()) {
            this.server.start();
        }
    }

    public synchronized void stop() throws InterruptedException {
        HttpServer httpServer = this.getHttpServer();
        if (httpServer.isStarted()) {
            httpServer.stop();
        }
    }

    private void configureContext(HttpServer httpServer) {
        HttpContext httpContext = new HttpContext();
        httpContext.setContextPath("/ota/*");
        httpServer.addContext(httpContext);
        httpContext.addHandler((HttpHandler)new OTAHandler());
        httpContext.addHandler((HttpHandler)new NotFoundHandler());
    }

    private void configureListener(HttpServer httpServer) {
        SocketListener socketListener = new SocketListener();
        socketListener.setMinThreads(1);
        socketListener.setMaxThreads(2);
        socketListener.setMaxIdleTimeMs(10000);
        socketListener.setDaemon(true);
        Preferences preferences = MTJCore.getMTJCore().getPluginPreferences();
        if (preferences.getBoolean("ota_port_defined")) {
            int n = preferences.getInt("ota_port");
            socketListener.setPort(n);
        }
        httpServer.addListener((HttpListener)socketListener);
    }

    private void configureLogging() throws Exception {
        System.setProperty("LOG_FILE_RETAIN_DAYS", "5");
        IPath iPath = MTJCore.getMTJCore().getStateLocation();
        IPath iPath2 = iPath.append("jetty");
        File file = iPath2.toFile();
        if (!file.exists()) {
            file.mkdir();
        }
        File file2 = new File(file, "logfile");
        String string = file2 + "yyyy_mm_dd.txt";
        OutputStreamLogSink outputStreamLogSink = new OutputStreamLogSink(string);
        outputStreamLogSink.start();
        this.logImpl.add((LogSink)outputStreamLogSink);
    }

    private HttpServer createHttpServer() {
        HttpServer httpServer = new HttpServer();
        this.configureListener(httpServer);
        this.configureContext(httpServer);
        return httpServer;
    }

    private HttpServer getHttpServer() {
        if (this.httpServer == null) {
            this.httpServer = this.createHttpServer();
            try {
                this.configureLogging();
            }
            catch (Exception exception) {
                MTJLogger.log(2, "configureLogging", exception);
            }
        }
        return this.httpServer;
    }
}

