/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device.midp;

import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class MIDPAPI
implements IMIDPAPI {
    private static final String VERSION_ENTRY = "version";
    private static final String TYPE_ENTRY = "type";
    private static final String NAME_ENTRY = "name";
    private static final String IDENTIFIER_ENTRY = "identifier";
    private String identifier;
    private String name;
    private MIDPAPIType type = MIDPAPIType.UNKNOWN;
    private Version version;

    public MIDPAPI() {
        this.identifier = MIDPAPIType.UNKNOWN.toString();
        this.name = MIDPAPIType.UNKNOWN.toString();
        this.version = Version.emptyVersion;
    }

    public MIDPAPIType getType() {
        return this.type;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(MIDPAPIType mIDPAPIType) {
        this.type = mIDPAPIType;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        this.identifier = iPersistenceProvider.loadString(IDENTIFIER_ENTRY);
        this.version = new Version(iPersistenceProvider.loadString(VERSION_ENTRY));
        this.name = iPersistenceProvider.loadString(NAME_ENTRY);
        int n = iPersistenceProvider.loadInteger(TYPE_ENTRY);
        this.type = MIDPAPIType.getMIDPAPITypeByCode(n);
    }

    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        iPersistenceProvider.storeString(IDENTIFIER_ENTRY, this.identifier);
        iPersistenceProvider.storeString(NAME_ENTRY, this.name);
        iPersistenceProvider.storeInteger(TYPE_ENTRY, this.type.getTypecode());
        iPersistenceProvider.storeString(VERSION_ENTRY, NLS.bind((String)"{0}.{1}", (Object[])new Object[]{this.version.getMajor(), this.version.getMinor()}));
    }

    public String toString() {
        return String.valueOf(this.getIdentifier()) + "-" + this.getVersion().getMajor() + "." + this.getVersion().getMinor();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.identifier == null ? 0 : this.identifier.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        n = 31 * n + (this.version == null ? 0 : this.version.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MIDPAPI mIDPAPI = (MIDPAPI)object;
        if (this.identifier == null ? mIDPAPI.identifier != null : !this.identifier.equals(mIDPAPI.identifier)) {
            return false;
        }
        if (this.name == null ? mIDPAPI.name != null : !this.name.equals(mIDPAPI.name)) {
            return false;
        }
        if (this.type == null ? mIDPAPI.type != null : !this.type.equals((Object)mIDPAPI.type)) {
            return false;
        }
        return !(this.version == null ? mIDPAPI.version != null : !this.version.equals((Object)mIDPAPI.version));
    }
}

