/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sign;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.sign.PermissionsGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionsGroupsRegistry
implements IRegistryChangeListener {
    private static final String NAME = "name";
    private static final String EXT_SECURITY_PERMISSION = "securitypermission";
    private static final String EXT_ID = "org.eclipse.mtj.core.securitypermission";
    private List<PermissionsGroup> permissions;
    private static PermissionsGroupsRegistry instance;

    public static synchronized PermissionsGroupsRegistry getInstance() {
        if (instance == null) {
            instance = new PermissionsGroupsRegistry();
            Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)instance);
        }
        return instance;
    }

    private PermissionsGroupsRegistry() {
        IExtensionRegistry iExtensionRegistry = null;
        IConfigurationElement[] iConfigurationElementArray = null;
        this.permissions = new ArrayList<PermissionsGroup>();
        iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(EXT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            String string = iConfigurationElement.getAttribute(NAME);
            List<String> list = this.getClassPermissions(iConfigurationElement.getChildren());
            this.permissions.add(new PermissionsGroup(string, list));
            ++n2;
        }
    }

    private List<String> getClassPermissions(IConfigurationElement[] iConfigurationElementArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            String string = iConfigurationElement.getAttribute(NAME);
            arrayList.add(string);
            ++n2;
        }
        return arrayList;
    }

    public List<PermissionsGroup> getPermissions() {
        ArrayList<PermissionsGroup> arrayList = new ArrayList<PermissionsGroup>();
        arrayList.addAll(this.permissions);
        return arrayList;
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        String string = MTJCore.getMTJCore().getBundle().getSymbolicName();
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas(string, EXT_SECURITY_PERMISSION);
        int n = 0;
        while (n < iExtensionDeltaArray.length) {
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionDeltaArray[n].getExtension().getConfigurationElements();
            int n2 = iConfigurationElementArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n3];
                String string2 = iConfigurationElement.getAttribute(NAME);
                List<String> list = this.getClassPermissions(iConfigurationElement.getChildren());
                if (iExtensionDeltaArray[n].getKind() == 1) {
                    this.permissions.add(new PermissionsGroup(string2, list));
                } else {
                    int n4 = 0;
                    while (n < this.permissions.size()) {
                        if (string2.equals(this.permissions.get(n4).getClassName())) {
                            this.permissions.remove(n4);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
            ++n;
        }
    }
}

