/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.build.pages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.build.BuildStateMachine;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.build.MTJBuildPropertiesChangeListener;
import org.eclipse.mtj.internal.core.util.ClasspathChangeMonitor;
import org.eclipse.mtj.internal.core.util.IClasspathChangeListener;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPropertiesPage
extends FormPage
implements MTJBuildPropertiesChangeListener,
IClasspathChangeListener {
    private static final String PAGE_TITLE = MTJUIMessages.BuildPropertiesPage_pageTitle;
    private static final String PAGE_ID = "buildPropertiesPage";
    private MTJBuildProperties properties;
    private IMTJProject mtjProject;
    private MTJRuntime currentRuntime;
    private ContainerCheckedTreeViewer resourcesViewer;
    private ComboViewer configurationsViewer;
    private boolean dirty;

    public BuildPropertiesPage(FormEditor formEditor, MTJBuildProperties mTJBuildProperties) {
        super(formEditor, PAGE_ID, PAGE_TITLE);
        this.properties = mTJBuildProperties;
        this.properties.addPropertiesChangeListener((MTJBuildPropertiesChangeListener)this);
        this.mtjProject = mTJBuildProperties.getMTJProject();
        ClasspathChangeMonitor.getInstance().addClasspathChangeListener(this.mtjProject, (IClasspathChangeListener)this);
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        ScrolledForm scrolledForm = iManagedForm.getForm();
        formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledForm.setExpandHorizontal(true);
        scrolledForm.setExpandVertical(true);
        scrolledForm.setText(this.getTitle());
        Composite composite = scrolledForm.getBody();
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.verticalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        this.createConfigurationsSection(iManagedForm, composite);
        this.createResourcesSection(iManagedForm, composite);
        scrolledForm.reflow(true);
    }

    public void setActive(boolean bl) {
        super.setActive(bl);
        if (bl) {
            this.configurationsViewer.refresh();
            this.updateViewer();
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        try {
            this.properties.store();
            this.setDirty(false);
            BuildStateMachine buildStateMachine = BuildStateMachine.getInstance((IMTJProject)this.mtjProject);
            buildStateMachine.start(iProgressMonitor);
            this.mtjProject.getProject().build(6, "org.eclipse.mtj.core.packageBuilder", new HashMap(), iProgressMonitor);
        }
        catch (IOException iOException) {
            MTJLogger.log((int)4, (Throwable)iOException);
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)4, (Throwable)coreException);
        }
    }

    private void createConfigurationsSection(IManagedForm iManagedForm, Composite composite) {
        GridData gridData = null;
        gridData = new GridData(4, 4, true, false);
        Composite composite2 = this.createSection(iManagedForm, composite, MTJUIMessages.BuildPropertiesPage_runtimeSectionTitle, MTJUIMessages.BuildPropertiesPage_runtimeSectionDetails, gridData);
        composite2.setLayout((Layout)new GridLayout(1, true));
        Combo combo = new Combo(composite2, 12);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        combo.setFocus();
        this.configurationsViewer = new ComboViewer(combo);
        this.configurationsViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                ArrayList arrayList = new ArrayList();
                if (object instanceof MTJRuntimeList) {
                    MTJRuntimeList mTJRuntimeList = (MTJRuntimeList)object;
                    arrayList.addAll(mTJRuntimeList);
                }
                return arrayList.toArray();
            }

            public void dispose() {
            }
        });
        this.configurationsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object object) {
                return null;
            }

            public String getText(Object object) {
                String string = null;
                if (object instanceof MTJRuntime) {
                    MTJRuntime mTJRuntime = (MTJRuntime)object;
                    string = mTJRuntime.getName();
                }
                return string;
            }
        });
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPropertiesPage.this.updateViewer();
            }
        });
        MTJRuntimeList mTJRuntimeList = this.mtjProject.getRuntimeList();
        this.currentRuntime = mTJRuntimeList.getActiveMTJRuntime();
        this.configurationsViewer.setInput((Object)mTJRuntimeList);
        this.configurationsViewer.setSelection((ISelection)new StructuredSelection((Object)this.currentRuntime));
    }

    private void updateViewer() {
        ISelection iSelection = this.configurationsViewer.getSelection();
        if (!(iSelection instanceof IStructuredSelection) || iSelection.isEmpty()) {
            this.currentRuntime = this.mtjProject.getRuntimeList().getActiveMTJRuntime();
            this.configurationsViewer.setSelection((ISelection)new StructuredSelection((Object)this.currentRuntime));
        } else {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            this.currentRuntime = (MTJRuntime)iStructuredSelection.getFirstElement();
        }
        this.updateCheckedElements();
    }

    private void updateCheckedElements() {
        this.resourcesViewer.setCheckedElements(new Object[0]);
        IResource[] iResourceArray = this.properties.getIncludes(this.currentRuntime);
        IResource[] iResourceArray2 = this.properties.getExcludes(this.currentRuntime);
        IResource[] iResourceArray3 = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray3[n2];
            IPath iPath = iResource.getFullPath();
            ArrayList<IResource> arrayList = new ArrayList<IResource>();
            IResource[] iResourceArray4 = iResourceArray2;
            int n3 = iResourceArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource iResource2 = iResourceArray4[n4];
                IPath iPath2 = iResource2.getFullPath();
                if (iPath.isPrefixOf(iPath2)) {
                    arrayList.add(iResource2);
                }
                ++n4;
            }
            if (arrayList.size() > 0) {
                this.selectNonExcludedResources(iResource, arrayList);
            } else {
                this.resourcesViewer.setChecked((Object)iResource, true);
            }
            ++n2;
        }
    }

    private void selectNonExcludedResources(IResource iResource, List<IResource> list) {
        if (!(iResource instanceof IFolder)) {
            return;
        }
        try {
            IResource[] iResourceArray;
            IResource[] iResourceArray2 = iResourceArray = ((IFolder)iResource).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource2 = iResourceArray2[n2];
                IPath iPath = iResource2.getFullPath();
                boolean bl = true;
                boolean bl2 = false;
                for (IResource iResource3 : list) {
                    IPath iPath2 = iResource3.getFullPath();
                    if (iResource2.equals((Object)iResource3)) {
                        bl2 = true;
                        break;
                    }
                    if (!iPath.isPrefixOf(iPath2)) continue;
                    bl = false;
                    break;
                }
                if (!bl2) {
                    if (bl) {
                        this.resourcesViewer.setChecked((Object)iResource2, true);
                    } else {
                        this.selectNonExcludedResources(iResource2, list);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)4, (Throwable)coreException);
        }
    }

    private void createResourcesSection(IManagedForm iManagedForm, Composite composite) {
        GridData gridData = null;
        gridData = new GridData(4, 4, true, true);
        Composite composite2 = this.createSection(iManagedForm, composite, MTJUIMessages.BuildPropertiesPage_resourcesSectionTitle, MTJUIMessages.BuildPropertiesPage_resourcesSectionDescription, gridData);
        composite2.setLayout((Layout)new GridLayout(1, true));
        Tree tree = new Tree(composite2, 2082);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.resourcesViewer = new ContainerCheckedTreeViewer(tree);
        this.resourcesViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.resourcesViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.resourcesViewer.setInput((Object)this.mtjProject.getProject());
        this.resourcesViewer.setFilters(new ViewerFilter[]{new SourceFolderFilter(this.mtjProject.getJavaProject())});
        this.resourcesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                Object object = checkStateChangedEvent.getElement();
                if (object instanceof IResource) {
                    IResource iResource = (IResource)object;
                    if (checkStateChangedEvent.getChecked()) {
                        this.includeTopMostResource(iResource);
                    } else {
                        this.excludeTopMostResource(iResource);
                    }
                }
                BuildPropertiesPage.this.setDirty(true);
            }

            private void excludeTopMostResource(IResource iResource) {
                ExcludesVisitor excludesVisitor = new ExcludesVisitor(BuildPropertiesPage.this.resourcesViewer, iResource);
                try {
                    IResource[] iResourceArray;
                    IResource[] iResourceArray2 = iResourceArray = Utils.getSourceFolders((IJavaProject)BuildPropertiesPage.this.mtjProject.getJavaProject());
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource iResource2 = iResourceArray2[n2];
                        IPath iPath = iResource2.getFullPath();
                        if (iPath.isPrefixOf(iResource.getFullPath())) {
                            iResource2.accept((IResourceVisitor)excludesVisitor);
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {
                    MTJLogger.log((int)4, (Throwable)coreException);
                }
                BuildPropertiesPage.this.properties.excludeResource(excludesVisitor.getExclude(), BuildPropertiesPage.this.currentRuntime);
            }

            private void includeTopMostResource(IResource iResource) {
                IncludesVisitor includesVisitor = new IncludesVisitor(BuildPropertiesPage.this.resourcesViewer, iResource);
                try {
                    IResource[] iResourceArray;
                    IResource[] iResourceArray2 = iResourceArray = Utils.getSourceFolders((IJavaProject)BuildPropertiesPage.this.mtjProject.getJavaProject());
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource iResource2 = iResourceArray2[n2];
                        IPath iPath = iResource2.getFullPath();
                        if (iPath.isPrefixOf(iResource.getFullPath())) {
                            iResource2.accept((IResourceVisitor)includesVisitor);
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {
                    MTJLogger.log((int)4, (Throwable)coreException);
                }
                BuildPropertiesPage.this.properties.includeResource(includesVisitor.getInclude(), BuildPropertiesPage.this.currentRuntime);
            }
        });
    }

    private Composite createSection(IManagedForm iManagedForm, Composite composite, String string, String string2, GridData gridData) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Section section = formToolkit.createSection(composite, 384);
        if (string != null) {
            section.setText(string);
        }
        if (string2 != null) {
            section.setDescription(string2);
        }
        section.setLayoutData((Object)gridData);
        section.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = formToolkit.createComposite((Composite)section, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        section.setClient((Control)composite2);
        return composite2;
    }

    private void setDirty(boolean bl) {
        this.dirty = bl;
        this.getEditor().editorDirtyStateChanged();
    }

    public boolean isDirty() {
        return this.dirty || super.isDirty();
    }

    public void propertiesChanged(MTJBuildProperties mTJBuildProperties) {
        if (this.isActive() && this.currentRuntime != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    BuildPropertiesPage.this.updateViewer();
                    BuildPropertiesPage.this.setDirty(false);
                }
            });
        }
    }

    public void classpathChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                BuildPropertiesPage.this.resourcesViewer.refresh();
                BuildPropertiesPage.this.updateViewer();
                BuildPropertiesPage.this.setDirty(false);
            }
        });
    }

    public void dispose() {
        super.dispose();
        ClasspathChangeMonitor.getInstance().removeClasspathChangeListener(this.mtjProject, (IClasspathChangeListener)this);
    }

    class ExcludesVisitor
    implements IResourceVisitor {
        private ContainerCheckedTreeViewer resourcesViewer;
        private IResource resource;

        public ExcludesVisitor(ContainerCheckedTreeViewer containerCheckedTreeViewer, IResource iResource) {
            this.resourcesViewer = containerCheckedTreeViewer;
            this.resource = iResource;
        }

        public boolean visit(IResource iResource) throws CoreException {
            IPath iPath;
            boolean bl = true;
            IPath iPath2 = iResource.getFullPath();
            if (iPath2.equals((Object)(iPath = this.resource.getFullPath()))) {
                bl = false;
            } else if (iPath2.isPrefixOf(iPath)) {
                if (!this.resourcesViewer.getChecked((Object)iResource)) {
                    this.resource = iResource;
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }

        public IResource getExclude() {
            return this.resource;
        }
    }

    class IncludesVisitor
    implements IResourceVisitor {
        private ContainerCheckedTreeViewer resourcesViewer;
        private IResource resource;

        public IncludesVisitor(ContainerCheckedTreeViewer containerCheckedTreeViewer, IResource iResource) {
            this.resourcesViewer = containerCheckedTreeViewer;
            this.resource = iResource;
        }

        public boolean visit(IResource iResource) throws CoreException {
            IPath iPath;
            boolean bl = true;
            IPath iPath2 = iResource.getFullPath();
            if (iPath2.equals((Object)(iPath = this.resource.getFullPath()))) {
                bl = false;
            } else if (iPath2.isPrefixOf(iPath)) {
                if (this.resourcesViewer.getChecked((Object)iResource) && !this.resourcesViewer.getGrayed((Object)iResource)) {
                    this.resource = iResource;
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }

        public IResource getInclude() {
            return this.resource;
        }
    }

    private class SourceFolderFilter
    extends ViewerFilter {
        private IJavaProject javaProject;

        public SourceFolderFilter(IJavaProject iJavaProject) {
            this.javaProject = iJavaProject;
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            boolean bl = false;
            if (object2 instanceof IResource) {
                IResource[] iResourceArray;
                IResource iResource = (IResource)object2;
                IPath iPath = iResource.getFullPath();
                IResource[] iResourceArray2 = iResourceArray = Utils.getSourceFolders((IJavaProject)this.javaProject);
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource iResource2 = iResourceArray2[n2];
                    IPath iPath2 = iResource2.getFullPath();
                    if (iPath2.isPrefixOf(iPath) || iPath.isPrefixOf(iPath2)) {
                        bl = true;
                    }
                    ++n2;
                }
            }
            return bl;
        }
    }
}

