/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.export.states;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.internal.core.build.export.AntennaExportException;
import org.eclipse.mtj.internal.core.build.export.states.AbstractCreateAntTaskState;
import org.eclipse.mtj.internal.core.statemachine.StateMachine;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateAntPackageTaskState
extends AbstractCreateAntTaskState {
    public CreateAntPackageTaskState(StateMachine stateMachine, IMidletSuiteProject iMidletSuiteProject, Document document) {
        super(stateMachine, iMidletSuiteProject, document);
    }

    protected void onEnter(MTJRuntime mTJRuntime) throws AntennaExportException {
        Document document = this.getDocument();
        Element element = document.getDocumentElement();
        String string = this.getFormatedName(mTJRuntime.getName());
        Element element2 = XMLUtils.createTargetElement(document, element, NLS.bind((String)"package-{0}", (Object)string), this.getDependencies(mTJRuntime));
        this.writePackageTask(element2, mTJRuntime);
    }

    private void writePackageTask(Element element, MTJRuntime mTJRuntime) {
        String[] stringArray;
        IProject iProject = this.getMidletSuiteProject().getProject();
        Document document = this.getDocument();
        String string = mTJRuntime.getName().replace(" ", "_");
        Element element2 = document.createElement("wtkpackage");
        String string2 = this.getFormatedName(iProject.getName());
        Object[] objectArray = new String[]{string, this.getMidletSuiteProject().getJadFileName()};
        element2.setAttribute("jadfile", NLS.bind((String)"deployed/{0}/{1}", (Object[])objectArray));
        objectArray = new String[]{string, this.getMidletSuiteProject().getJarFilename()};
        element2.setAttribute("jarfile", NLS.bind((String)"deployed/{0}/{1}", (Object[])objectArray));
        element2.setAttribute("autoversion", NLS.bind((String)"${0}{1}{2}", (Object[])new String[]{"{", "do-autoversion", "}"}));
        element2.setAttribute("obfuscate", NLS.bind((String)"${0}{1}{2}", (Object[])new String[]{"{", "do-obfuscate", "}"}));
        element2.setAttribute("preverify", "false");
        StringBuffer stringBuffer = new StringBuffer();
        IDevice iDevice = mTJRuntime.getDevice();
        IDeviceClasspath iDeviceClasspath = iDevice.getClasspath();
        for (ILibrary stringArray2 : iDeviceClasspath.getEntries()) {
            File n2 = stringArray2.toFile();
            stringBuffer.append(n2.getAbsolutePath()).append(":");
        }
        element2.setAttribute("bootclasspath", stringBuffer.toString());
        element.appendChild(element2);
        String[] stringArray2 = stringArray = new String[]{"{0}/{1}/{2}/bin/", "{0}/{1}/{2}/resources/"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            Element element3 = document.createElement("fileset");
            element2.appendChild(element3);
            element3.setAttribute("dir", NLS.bind((String)string3, (Object[])new String[]{"mtj-build", string, this.getFormatedName(string2)}));
            ++n2;
        }
    }
}

