/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text;

import java.util.HashMap;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.internal.core.text.AbstractTextChangeListener;
import org.eclipse.mtj.internal.core.text.IDocumentKey;
import org.eclipse.mtj.internal.core.util.PropertiesUtil;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class AbstractKeyValueTextChangeListener
extends AbstractTextChangeListener {
    protected HashMap<TextEdit, String> fReadableNames = null;

    public AbstractKeyValueTextChangeListener(IDocument iDocument, boolean bl) {
        super(iDocument);
        if (bl) {
            this.fReadableNames = new HashMap();
        }
    }

    public String getReadableName(TextEdit textEdit) {
        if (this.fReadableNames != null && this.fReadableNames.containsKey(textEdit)) {
            return this.fReadableNames.get(textEdit);
        }
        return null;
    }

    public TextEdit[] getTextOperations() {
        if (this.operationTable.size() == 0) {
            return new TextEdit[0];
        }
        return this.operationTable.values().toArray(new TextEdit[this.operationTable.size()]);
    }

    protected void deleteKey(IDocumentKey iDocumentKey, String string) {
        if (iDocumentKey.getOffset() >= 0) {
            DeleteEdit deleteEdit = new DeleteEdit(iDocumentKey.getOffset(), iDocumentKey.getLength());
            this.operationTable.put(iDocumentKey, deleteEdit);
            if (this.fReadableNames != null) {
                this.fReadableNames.put((TextEdit)deleteEdit, string);
            }
        }
    }

    protected void insertKey(IDocumentKey iDocumentKey, String string) {
        int n = PropertiesUtil.getInsertOffset(this.textDocument);
        InsertEdit insertEdit = new InsertEdit(n, iDocumentKey.write());
        this.operationTable.put(iDocumentKey, insertEdit);
        if (this.fReadableNames != null) {
            this.fReadableNames.put((TextEdit)insertEdit, string);
        }
    }

    protected void modifyKey(IDocumentKey iDocumentKey, String string) {
        if (iDocumentKey.getOffset() == -1) {
            this.insertKey(iDocumentKey, string);
        } else {
            ReplaceEdit replaceEdit = new ReplaceEdit(iDocumentKey.getOffset(), iDocumentKey.getLength(), iDocumentKey.write());
            this.operationTable.put(iDocumentKey, replaceEdit);
            if (this.fReadableNames != null) {
                this.fReadableNames.put((TextEdit)replaceEdit, string);
            }
        }
    }
}

