/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.export.states;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.export.AntennaExportException;
import org.eclipse.mtj.internal.core.build.export.states.AbstractCreateAntTaskState;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.statemachine.StateMachine;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateAntPreprocessTaskState
extends AbstractCreateAntTaskState {
    public CreateAntPreprocessTaskState(StateMachine stateMachine, IMidletSuiteProject iMidletSuiteProject, Document document) {
        super(stateMachine, iMidletSuiteProject, document);
    }

    protected void onEnter(MTJRuntime mTJRuntime) throws AntennaExportException {
        Document document = this.getDocument();
        Element element = document.getDocumentElement();
        IProject iProject = this.getMidletSuiteProject().getProject();
        String string = this.getFormatedName(mTJRuntime.getName());
        Element element2 = XMLUtils.createTargetElement(document, element, NLS.bind((String)"preprocess-{0}", (Object)string), this.getDependencies(mTJRuntime));
        try {
            ISymbolSet iSymbolSet = mTJRuntime.getSymbolSetForPreprocessing();
            IFile iFile = this.createSymbolSetFile(string, iSymbolSet);
            this.writePreprocessTask(iProject, document, element2, mTJRuntime, iFile);
            Set<IProject> set = this.getRequiredProjects(iProject);
            if (set.size() > 0) {
                for (IProject element32 : set) {
                    this.writePreprocessTask(element32, document, element2, mTJRuntime, iFile);
                }
                Element element3 = document.createElement("copy");
                element2.appendChild(element3);
                element3.setAttribute("overwrite", "true");
                element3.setAttribute("todir", NLS.bind((String)"{0}/{1}/{2}/classes/", (Object[])new String[]{"mtj-build", string, this.getFormatedName(iProject.getName())}));
                for (IProject iProject2 : set) {
                    Element element4 = document.createElement("fileset");
                    element3.appendChild(element4);
                    element4.setAttribute("dir", NLS.bind((String)"{0}/{1}/{2}/classes/", (Object[])new String[]{"mtj-build", string, this.getFormatedName(iProject2.getName())}));
                }
            }
        }
        catch (IOException iOException) {
            throw new AntennaExportException(iOException, Messages.CreateAntPreprocessTaskState_UnableToCreateSymbolSet);
        }
    }

    private void writePreprocessTask(IProject iProject, Document document, Element element, MTJRuntime mTJRuntime, IFile iFile) throws AntennaExportException {
        IResource[] iResourceArray;
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        if (iJavaProject == null) {
            return;
        }
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
        if (iMidletSuiteProject == null) {
            return;
        }
        String string = this.getFormatedName(mTJRuntime.getName());
        IResource[] iResourceArray2 = iResourceArray = Utils.getSourceFolders(iMidletSuiteProject.getJavaProject());
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray2[n2];
            Element element2 = document.createElement("wtkpreprocess");
            element.appendChild(element2);
            element2.setAttribute("debuglevel", "info");
            element2.setAttribute("verbose", "true");
            element2.setAttribute("printsymbols", "true");
            element2.setAttribute("srcdir", NLS.bind((String)"..{0}", (Object)iResource.getFullPath()));
            element2.setAttribute("destdir", NLS.bind((String)"{0}/{1}/{2}/classes/", (Object[])new String[]{"mtj-build", string, this.getFormatedName(iProject.getName())}));
            Element element3 = document.createElement("symbols_file");
            element3.setAttribute("name", NLS.bind((String)"{0}/{1}/", (Object[])new String[]{"${basedir}", iFile.getProjectRelativePath().toString()}));
            element2.appendChild(element3);
            ++n2;
        }
    }

    private IFile createSymbolSetFile(String string, ISymbolSet iSymbolSet) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (ISymbol object2 : iSymbolSet.getSymbols()) {
            stringBuffer.append(NLS.bind((String)"{0}={1}\n", (Object[])new String[]{object2.getName(), object2.getSafeValue()}));
        }
        IProject iProject = this.getMidletSuiteProject().getProject();
        IFile iFile = iProject.getFile(NLS.bind((String)"mtj-build/{0}.symbols", (Object)string));
        File file = iFile.getLocation().toFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(stringBuffer.toString().getBytes());
        fileOutputStream.flush();
        fileOutputStream.close();
        return iFile;
    }
}

