/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.build.BuildSpecManipulator;
import org.eclipse.mtj.internal.core.build.BuildStateMachine;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class MTJCompilationParticipant
extends CompilationParticipant {
    public int aboutToBuild(IJavaProject iJavaProject) {
        try {
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
            BuildStateMachine buildStateMachine = BuildStateMachine.getInstance(iMidletSuiteProject);
            NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
            BuildSpecManipulator buildSpecManipulator = new BuildSpecManipulator(iMidletSuiteProject.getProject());
            if (buildSpecManipulator.isFirstBuilder("org.eclipse.jdt.core.javabuilder")) {
                buildStateMachine.start((IProgressMonitor)nullProgressMonitor);
            }
            if (buildStateMachine.getCurrentState() != null) {
                buildStateMachine.changeState(MTJBuildState.PRE_COMPILATION, (IProgressMonitor)nullProgressMonitor);
            }
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, coreException);
        }
        return super.aboutToBuild(iJavaProject);
    }

    public void buildFinished(IJavaProject iJavaProject) {
        try {
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
            BuildStateMachine buildStateMachine = BuildStateMachine.getInstance(iMidletSuiteProject);
            NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
            if (buildStateMachine.getCurrentState() != null) {
                buildStateMachine.changeState(MTJBuildState.POST_COMPILATION, (IProgressMonitor)nullProgressMonitor);
                BuildSpecManipulator buildSpecManipulator = new BuildSpecManipulator(iMidletSuiteProject.getProject());
                if (buildSpecManipulator.isLastBuilder("org.eclipse.jdt.core.javabuilder")) {
                    buildStateMachine.changeState(MTJBuildState.POST_BUILD, (IProgressMonitor)nullProgressMonitor);
                }
            }
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, coreException);
        }
        super.buildFinished(iJavaProject);
    }

    public boolean isActive(IJavaProject iJavaProject) {
        boolean bl = false;
        try {
            bl = iJavaProject.getProject().hasNature("org.eclipse.mtj.core.nature");
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, coreException);
        }
        return bl;
    }
}

