/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.device.pages;

import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.internal.ui.viewers.TableViewerConfiguration;
import org.eclipse.mtj.ui.editors.device.AbstractDeviceEditorPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class DeviceSymbolSetEditorPage
extends AbstractDeviceEditorPage {
    private static final String DEVICE_SYMBOLSET_VIEWER_SETTINGS = "deviceSymbolsetViewerSettings";
    private static final TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(MTJUIMessages.DeviceSymbolsetEditorPage_symbol_columnInfo, 40.0f, null), new TableColumnInfo(MTJUIMessages.DeviceSymbolsetEditorPage_value_columnInfo, 60.0f, null)};
    private static final int DEFAULT_TABLE_WIDTH = 650;
    private static final Object[] NO_ELEMENTS = new Object[0];
    private TableViewer viewer;

    public DeviceSymbolSetEditorPage(Composite composite, int n) {
        super(composite, n);
    }

    public void commitDeviceChanges() {
    }

    public String getDescription() {
        return MTJUIMessages.DeviceSymbolsetEditorPage_description;
    }

    public String getTitle() {
        return MTJUIMessages.DeviceSymbolsetEditorPage_title;
    }

    public void setDevice(IMIDPDevice iMIDPDevice) {
        super.setDevice(iMIDPDevice);
        this.viewer.setInput((Object)iMIDPDevice);
    }

    private TableViewer createTableViewer(Composite composite) {
        int n = 68100;
        Table table = new Table(composite, n);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new DevicePropertiesContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)MTJUIPlugin.getDefault().getLabelProvider());
        IDialogSettings iDialogSettings = MTJUIPlugin.getDialogSettings(DEVICE_SYMBOLSET_VIEWER_SETTINGS);
        TableViewerConfiguration tableViewerConfiguration = new TableViewerConfiguration(iDialogSettings, 650, COLUMN_INFO, 0);
        tableViewerConfiguration.configure(tableViewer);
        return tableViewer;
    }

    protected void addPageControls(Composite composite) {
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = 650;
        gridData.heightHint = 400;
        this.viewer = this.createTableViewer(composite);
        this.viewer.getTable().setLayoutData((Object)gridData);
    }

    private static class DevicePropertiesContentProvider
    implements IStructuredContentProvider {
        private DevicePropertiesContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            IDevice iDevice;
            ISymbolSet iSymbolSet;
            Object[] objectArray = NO_ELEMENTS;
            if (object instanceof IMIDPDevice && (iSymbolSet = (iDevice = (IDevice)object).getSymbolSet()) != null) {
                Collection collection = iSymbolSet.getSymbols();
                objectArray = collection.toArray();
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

