/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.pulsar.ui.view;

import java.net.URI;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.console.ProvisioningHelper;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.ui.PlanAnalyzer;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.InstallAction;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.PreselectedIUInstallWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.UninstallWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mtj.internal.provisional.pulsar.core.IInstallerUI;
import org.eclipse.mtj.internal.provisional.pulsar.core.ISDK;
import org.eclipse.mtj.internal.provisional.pulsar.core.ISDKRepository;
import org.eclipse.mtj.internal.pulsar.core.SDK;
import org.eclipse.mtj.internal.pulsar.ui.view.Messages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2InstallerUI
implements IInstallerUI {
    private static P2InstallerUI instance;

    private P2InstallerUI() {
    }

    public static IInstallerUI getInstance() {
        if (instance == null) {
            instance = new P2InstallerUI();
        }
        return instance;
    }

    public void runInstaller(final Shell shell, ISDK iSDK) throws CoreException {
        SDK sDK = (SDK)iSDK.getAdapter(SDK.class);
        final InstallableUnit[] installableUnitArray = this.getInstallableUnits(sDK);
        URI uRI = sDK.getRepository().getArtifactsURI();
        URI uRI2 = sDK.getRepository().getMetadataURI();
        ProvisioningUtil.addArtifactRepository((URI)uRI, (boolean)true);
        ProvisioningUtil.addMetadataRepository((URI)uRI2, (boolean)true);
        MultiStatus multiStatus = this.getStatus();
        final String string = this.getProfileID();
        ProfileChangeRequest profileChangeRequest = InstallAction.computeProfileChangeRequest((IInstallableUnit[])installableUnitArray, (String)string, (MultiStatus)multiStatus, (IProgressMonitor)new NullProgressMonitor());
        final PlannerResolutionOperation plannerResolutionOperation = new PlannerResolutionOperation(Messages.P2InstallerUI_ResoultionOperationLabel, string, profileChangeRequest, null, PlanAnalyzer.getProfileChangeAlteredStatus(), true);
        Job job = ProvisioningOperationRunner.schedule((ProvisioningOperation)plannerResolutionOperation, (int)2);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                ProvisioningPlan provisioningPlan = plannerResolutionOperation.getProvisioningPlan();
                if (provisioningPlan != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            Policy policy = P2InstallerUI.this.getPolicy();
                            PreselectedIUInstallWizard preselectedIUInstallWizard = new PreselectedIUInstallWizard(policy, string, (IInstallableUnit[])installableUnitArray, plannerResolutionOperation, new QueryableMetadataRepositoryManager(policy.getQueryContext(), false));
                            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)preselectedIUInstallWizard);
                            wizardDialog.create();
                            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)wizardDialog.getShell(), "org.eclipse.equinox.p2.ui.install_wizard_context");
                            wizardDialog.open();
                        }
                    });
                }
            }
        });
    }

    public void runUninstaller(final Shell shell, ISDK iSDK) throws CoreException {
        final String string = this.getProfileID();
        SDK sDK = (SDK)iSDK.getAdapter(SDK.class);
        final InstallableUnit[] installableUnitArray = this.getInstallableUnits(sDK);
        final MultiStatus multiStatus = this.getStatus();
        final ProfileChangeRequest[] profileChangeRequestArray = new ProfileChangeRequest[1];
        BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                profileChangeRequestArray[0] = P2InstallerUI.this.getProfileChangeRequest((IInstallableUnit[])installableUnitArray, string, multiStatus, (IProgressMonitor)new NullProgressMonitor());
            }
        });
        final PlannerResolutionOperation plannerResolutionOperation = new PlannerResolutionOperation(ProvUIMessages.ProfileModificationAction_ResolutionOperationLabel, string, profileChangeRequestArray[0], null, multiStatus, true);
        Job job = ProvisioningOperationRunner.schedule((ProvisioningOperation)plannerResolutionOperation, (int)2);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                ProvisioningPlan provisioningPlan = plannerResolutionOperation.getProvisioningPlan();
                if (provisioningPlan != null && PlatformUI.isWorkbenchRunning()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            UninstallWizard uninstallWizard = new UninstallWizard(P2InstallerUI.this.getPolicy(), string, (IInstallableUnit[])installableUnitArray, plannerResolutionOperation);
                            ProvisioningWizardDialog provisioningWizardDialog = new ProvisioningWizardDialog(shell, (ProvisioningOperationWizard)uninstallWizard);
                            provisioningWizardDialog.create();
                            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)provisioningWizardDialog.getShell(), "org.eclipse.equinox.p2.ui.uinstall_wizard_context");
                            provisioningWizardDialog.open();
                        }
                    });
                }
            }
        });
    }

    public void refreshSDKRepositories(Collection<ISDKRepository> collection) {
        URI[] uRIArray = new URI[collection.size()];
        URI[] uRIArray2 = new URI[collection.size()];
        int n = 0;
        for (ISDKRepository iSDKRepository : collection) {
            uRIArray2[n] = iSDKRepository.getMetadataURI();
            uRIArray[n] = iSDKRepository.getArtifactsURI();
            ++n;
        }
        try {
            ProvisioningUtil.refreshMetadataRepositories((URI[])uRIArray2, (IProgressMonitor)new NullProgressMonitor());
            ProvisioningUtil.refreshArtifactRepositories((URI[])uRIArray, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException provisionException) {}
    }

    private ProfileChangeRequest getProfileChangeRequest(IInstallableUnit[] iInstallableUnitArray, String string, MultiStatus multiStatus, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)ProvUIMessages.ProfileChangeRequestBuildingRequest, (int)1);
        ProfileChangeRequest profileChangeRequest = null;
        try {
            profileChangeRequest = ProfileChangeRequest.createByProfileId((String)string);
            profileChangeRequest.removeInstallableUnits(iInstallableUnitArray);
            String string2 = this.getPolicy().getQueryContext().getVisibleInstalledIUProperty();
            int n = 0;
            while (n < iInstallableUnitArray.length) {
                profileChangeRequest.removeInstallableUnitProfileProperty(iInstallableUnitArray[n], string2);
                ++n;
            }
        }
        finally {
            subMonitor.done();
        }
        return profileChangeRequest;
    }

    private URI getMetadataURI(SDK sDK) {
        return sDK.getRepository().getMetadataURI();
    }

    private InstallableUnit[] getInstallableUnits(SDK sDK) {
        IInstallableUnit iInstallableUnit = sDK.getInstallableUnit();
        InstallableUnitQuery installableUnitQuery = new InstallableUnitQuery(iInstallableUnit.getId(), iInstallableUnit.getVersion());
        Collector collector = ProvisioningHelper.getInstallableUnits((URI)this.getMetadataURI(sDK), (Query)installableUnitQuery, null);
        return (InstallableUnit[])collector.toArray(InstallableUnit.class);
    }

    private Policy getPolicy() {
        return Policy.getDefault();
    }

    private String getProfileID() throws ProvisionException {
        return ProvSDKUIActivator.getSelfProfileId();
    }

    private MultiStatus getStatus() {
        return PlanAnalyzer.getProfileChangeAlteredStatus();
    }
}

