/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.projects;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMetaData;
import org.eclipse.mtj.core.project.ProjectType;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.externallibrary.manager.ExternalLibraryManager;
import org.eclipse.mtj.internal.core.externallibrary.model.IExternalLibrary;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.util.ExceptionHandler;
import org.eclipse.mtj.internal.ui.wizards.projects.NewMidletProjectWizardPageLibrary;
import org.eclipse.mtj.internal.ui.wizards.projects.NewMidletProjectWizardPageOne;
import org.eclipse.mtj.internal.ui.wizards.projects.NewMidletProjectWizardPageProperties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewMidletProjectWizardPageJavaSettings
extends JavaCapabilityConfigurationPage {
    private static final String FILENAME_CLASSPATH = ".classpath";
    private static final String FILENAME_PROJECT = ".project";
    public Boolean isAutobuild;
    private IProject currProject = null;
    private URI currProjectLocation = null;
    private File fDotClasspathBackup;
    private File fDotProjectBackup;
    private NewMidletProjectWizardPageOne firstPage;
    private NewMidletProjectWizardPageProperties propertiesPage;
    private HashSet<IFileStore> fOrginalFolders;
    private boolean keepContent;
    private NewMidletProjectWizardPageLibrary pageLibrary;

    private static URI getRealLocation(String string, URI uRI) {
        if (uRI == null) {
            try {
                URI uRI2 = MTJCore.getWorkspace().getRoot().getLocationURI();
                uRI = new URI(uRI2.getScheme(), null, Path.fromPortableString((String)uRI2.getPath()).append(string).toString(), null);
            }
            catch (URISyntaxException uRISyntaxException) {
                Assert.isTrue((boolean)false, (String)"Can't happen");
            }
        }
        return uRI;
    }

    public NewMidletProjectWizardPageJavaSettings(NewMidletProjectWizardPageOne newMidletProjectWizardPageOne, NewMidletProjectWizardPageProperties newMidletProjectWizardPageProperties, NewMidletProjectWizardPageLibrary newMidletProjectWizardPageLibrary) {
        this.firstPage = newMidletProjectWizardPageOne;
        this.propertiesPage = newMidletProjectWizardPageProperties;
        this.pageLibrary = newMidletProjectWizardPageLibrary;
        this.isAutobuild = null;
    }

    public void performCancel() {
        if (this.currProject != null) {
            this.removeProvisonalProject();
        }
    }

    public void performFinish(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        try {
            iProgressMonitor.beginTask(MTJUIMessages.NewMidletProjectWizardPageThree_performFinish_monitor_taskname, 3);
            if (this.currProject == null) {
                this.updateProject((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
            if (!this.keepContent) {
                IJavaProject iJavaProject = JavaCore.create((IProject)this.currProject);
                Map map = iJavaProject.getOptions(false);
                iJavaProject.setOptions(map);
            }
        }
        finally {
            iProgressMonitor.done();
            this.currProject = null;
            if (this.isAutobuild != null) {
                IWorkspaceDescription iWorkspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
                iWorkspaceDescription.setAutoBuilding(this.isAutobuild.booleanValue());
                MTJCore.getWorkspace().setDescription(iWorkspaceDescription);
                this.isAutobuild = null;
            }
        }
    }

    public void setVisible(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = bl && this.currProject == null;
        if (bl) {
            if (bl2) {
                this.createProvisonalProject();
            }
        } else if (this.getContainer().getCurrentPage() == this.firstPage || this.getContainer().getCurrentPage() == this.pageLibrary) {
            this.removeProvisonalProject();
        }
        super.setVisible(bl);
        if (bl2) {
            this.setFocus();
        }
    }

    public void updateConfiguration() {
        String string = this.firstPage.getProjectName();
        this.currProject = MTJCore.getWorkspace().getRoot().getProject(string);
        IJavaProject iJavaProject = JavaCore.create((IProject)this.currProject);
        IPath iPath = this.currProject.getFullPath();
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        arrayList.add(this.getSrcPathEntry(iPath));
        this.addResourcesDirectoryIfRequested(arrayList, this.currProject);
        Path path = new Path("org.elipse.mtj.JavaMEContainer/" + this.firstPage.getSelectedDevice());
        arrayList.add(JavaCore.newContainerEntry((IPath)path));
        IClasspathEntry[] iClasspathEntryArray = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
        this.init(iJavaProject, null, iClasspathEntryArray, false);
    }

    private void addResourcesDirectoryIfRequested(List<IClasspathEntry> list, IProject iProject) {
        Preferences preferences = MTJCore.getMTJCore().getPluginPreferences();
        if (this.useSourceAndBinaryFolders() && preferences.getBoolean("use_resources_dir")) {
            String string = preferences.getString("resources_dir");
            IFolder iFolder = iProject.getFolder(string);
            if (!iFolder.exists()) {
                try {
                    iFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
            list.add(JavaCore.newSourceEntry((IPath)iFolder.getFullPath()));
        }
    }

    private IStatus changeToNewProject() {
        class UpdateRunnable
        implements IRunnableWithProgress {
            public IStatus infoStatus = Status.OK_STATUS;

            UpdateRunnable() {
            }

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (NewMidletProjectWizardPageJavaSettings.this.isAutobuild == null) {
                            IWorkspaceDescription iWorkspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
                            NewMidletProjectWizardPageJavaSettings.this.isAutobuild = iWorkspaceDescription.isAutoBuilding();
                            iWorkspaceDescription.setAutoBuilding(false);
                            MTJCore.getWorkspace().setDescription(iWorkspaceDescription);
                        }
                        this.infoStatus = NewMidletProjectWizardPageJavaSettings.this.updateProject(iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        }
        UpdateRunnable updateRunnable = new UpdateRunnable();
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)updateRunnable));
            return updateRunnable.infoStatus;
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = MTJUIMessages.NewMidletProjectWizardPageThree_changeToNewProject_errordialog_title;
            String string2 = MTJUIMessages.NewMidletProjectWizardPageThree_changeToNewProject_errordialog_message;
            ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    private void copyFile(File file, IFileStore iFileStore, IProgressMonitor iProgressMonitor) throws IOException, CoreException {
        FileInputStream fileInputStream = new FileInputStream(file);
        OutputStream outputStream = iFileStore.openOutputStream(0, iProgressMonitor);
        this.copyFile(fileInputStream, outputStream);
    }

    private void copyFile(IFileStore iFileStore, File file) throws IOException, CoreException {
        InputStream inputStream = iFileStore.openInputStream(0, null);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.copyFile(inputStream, fileOutputStream);
    }

    private void copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int n;
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            finally {
                outputStream.close();
            }
        }
    }

    private File createBackup(IFileStore iFileStore, String string) throws CoreException {
        try {
            File file = File.createTempFile("eclipse-" + string, ".bak");
            this.copyFile(iFileStore, file);
            return file;
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.mtj.ui", 4, String.valueOf(MTJUIMessages.NewMidletProjectWizardPageThree_createBackup_error_1) + string + MTJUIMessages.NewMidletProjectWizardPageThree_createBackup_error_2, (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
    }

    private void deleteProjectFile(URI uRI) throws CoreException {
        IFileStore iFileStore;
        IFileStore iFileStore2 = EFS.getStore((URI)uRI);
        if (iFileStore2.fetchInfo().exists() && (iFileStore = iFileStore2.getChild(FILENAME_PROJECT)).fetchInfo().exists()) {
            iFileStore.delete(0, null);
        }
    }

    private final void doRemoveProject(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
        boolean bl;
        boolean bl2 = bl = this.currProjectLocation == null;
        if (iProgressMonitor == null || bl) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(MTJUIMessages.NewMidletProjectWizardPageThree_doRemoveProject_taskname, 3);
        try {
            try {
                try {
                    boolean bl3;
                    URI uRI = this.currProject.getLocationURI();
                    boolean bl4 = bl3 = !this.keepContent && this.currProject.isSynchronized(2);
                    if (!bl3 && this.currProject.getProject().getFullPath().toFile().exists()) {
                        this.restoreExistingFolders(uRI);
                    }
                    this.currProject.delete(bl3, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                    MidletSuiteFactory.removeMidletSuiteProject((IJavaProject)this.getJavaProject());
                    this.restoreExistingFiles(uRI, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
                finally {
                    IWorkspaceDescription iWorkspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
                    iWorkspaceDescription.setAutoBuilding(this.isAutobuild.booleanValue());
                    MTJCore.getWorkspace().setDescription(iWorkspaceDescription);
                    this.isAutobuild = null;
                }
            }
            catch (CoreException coreException) {
                throw new InvocationTargetException(coreException);
            }
        }
        finally {
            iProgressMonitor.done();
            this.currProject = null;
            this.keepContent = false;
        }
    }

    private IPath getSrcPath(IPath iPath) {
        IPath iPath2 = iPath;
        if (this.useSourceAndBinaryFolders()) {
            IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
            String string = iPreferenceStore.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName");
            iPath2 = iPath.append(string);
        }
        return iPath2;
    }

    private IClasspathEntry getSrcPathEntry(IPath iPath) {
        IPath iPath2 = this.getSrcPath(iPath);
        IPath[] iPathArray = null;
        iPathArray = iPath2.equals((Object)iPath) ? new IPath[]{new Path(String.valueOf(MTJCore.getDeploymentDirectoryName()) + "/"), new Path(".mtj.tmp/"), new Path(".processed/")} : new IPath[]{};
        return JavaCore.newSourceEntry((IPath)iPath2, (IPath[])iPathArray);
    }

    private boolean hasExistingContent(URI uRI) throws CoreException {
        IFileStore iFileStore = EFS.getStore((URI)uRI);
        return iFileStore.fetchInfo().exists();
    }

    private void rememberExisitingFolders(URI uRI) {
        this.fOrginalFolders = new HashSet();
        try {
            IFileStore[] iFileStoreArray;
            IFileStore[] iFileStoreArray2 = iFileStoreArray = EFS.getStore((URI)uRI).childStores(0, null);
            int n = iFileStoreArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore iFileStore = iFileStoreArray2[n2];
                IFileInfo iFileInfo = iFileStore.fetchInfo();
                if (iFileInfo.isDirectory() && iFileInfo.exists() && !this.fOrginalFolders.contains(iFileStore.getName())) {
                    this.fOrginalFolders.add(iFileStore);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            String string = MTJUIMessages.NewMidletProjectWizardPageThree_rememberExisitingFolders_errordialog_title;
            String string2 = MTJUIMessages.NewMidletProjectWizardPageThree_rememberExisitingFolders_errordialog_message;
            ExceptionHandler.handle(coreException, this.getShell(), string, string2);
        }
    }

    private void rememberExistingFiles(URI uRI) throws CoreException {
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        IFileStore iFileStore = EFS.getStore((URI)uRI);
        if (iFileStore.fetchInfo().exists()) {
            IFileStore iFileStore2;
            IFileStore iFileStore3 = iFileStore.getChild(FILENAME_PROJECT);
            if (iFileStore3.fetchInfo().exists()) {
                this.fDotProjectBackup = this.createBackup(iFileStore3, "project-desc");
            }
            if ((iFileStore2 = iFileStore.getChild(FILENAME_CLASSPATH)).fetchInfo().exists()) {
                this.fDotClasspathBackup = this.createBackup(iFileStore2, "classpath-desc");
            }
        }
    }

    private void restoreExistingFiles(URI uRI, IProgressMonitor iProgressMonitor) throws CoreException {
        IFileStore iFileStore;
        int n = ((this.fDotProjectBackup != null ? 1 : 0) + (this.fDotClasspathBackup != null ? 1 : 0)) * 2;
        iProgressMonitor.beginTask("", n);
        try {
            iFileStore = EFS.getStore((URI)uRI).getChild(FILENAME_PROJECT);
            iFileStore.delete(0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            if (this.fDotProjectBackup != null) {
                this.copyFile(this.fDotProjectBackup, iFileStore, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.mtj.ui", 4, MTJUIMessages.NewMidletProjectWizardPageThree_restoreExistingFiles_problem_restoring_dotproject, (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
        try {
            iFileStore = EFS.getStore((URI)uRI).getChild(FILENAME_CLASSPATH);
            iFileStore.delete(0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            if (this.fDotClasspathBackup != null) {
                this.copyFile(this.fDotClasspathBackup, iFileStore, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.mtj.ui", 4, MTJUIMessages.NewMidletProjectWizardPageThree_restoreExistingFiles_problem_restoring_dotclasspath, (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
    }

    private void restoreExistingFolders(URI uRI) {
        try {
            IFileStore iFileStore;
            IFileStore[] iFileStoreArray;
            IFileStore[] iFileStoreArray2 = iFileStoreArray = EFS.getStore((URI)uRI).childStores(0, null);
            int n = iFileStoreArray.length;
            int n2 = 0;
            while (n2 < n) {
                iFileStore = iFileStoreArray2[n2];
                IFileInfo iFileInfo = iFileStore.fetchInfo();
                if (iFileInfo.isDirectory() && iFileInfo.exists() && !this.fOrginalFolders.contains(iFileStore)) {
                    iFileStore.delete(0, null);
                    this.fOrginalFolders.remove(iFileStore);
                }
                ++n2;
            }
            Iterator<IFileStore> iterator = this.fOrginalFolders.iterator();
            while (iterator.hasNext()) {
                IFileStore iFileStore2 = iFileStore = iterator.next();
                iFileStore2.mkdir(0, null);
            }
        }
        catch (CoreException coreException) {
            String string = MTJUIMessages.NewMidletProjectWizardPageThree_rememberExisitingFolders_errordialog_title;
            String string2 = MTJUIMessages.NewMidletProjectWizardPageThree_rememberExisitingFolders_errordialog_message;
            ExceptionHandler.handle(coreException, this.getShell(), string, string2);
        }
    }

    private final IStatus updateProject(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        IStatus iStatus = Status.OK_STATUS;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            try {
                iProgressMonitor.beginTask(MTJUIMessages.NewMidletProjectWizardPageThree_updateProject_taskname, 7);
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                String string = this.firstPage.getProjectName();
                this.currProject = MTJCore.getWorkspace().getRoot().getProject(string);
                this.currProjectLocation = this.firstPage.getProjectLocationURI();
                URI uRI = NewMidletProjectWizardPageJavaSettings.getRealLocation(string, this.currProjectLocation);
                this.keepContent = this.hasExistingContent(uRI);
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (this.keepContent) {
                    this.rememberExistingFiles(uRI);
                    this.rememberExisitingFolders(uRI);
                }
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    Object object;
                    JavaCapabilityConfigurationPage.createProject((IProject)this.currProject, (URI)this.firstPage.getProjectLocationURI(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    IDevice iDevice = this.firstPage.getSelectedDevice();
                    MTJRuntimeList mTJRuntimeList = this.firstPage.getConfigurations();
                    IMetaData iMetaData = MTJCore.createMetaData((IProject)this.currProject, (ProjectType)ProjectType.MIDLET_SUITE);
                    iMetaData.setMTJRuntimeList(mTJRuntimeList);
                    try {
                        iMetaData.saveMetaData();
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                    this.updateConfiguration();
                    try {
                        object = super.getRunnable();
                        object.run(iProgressMonitor);
                    }
                    catch (Throwable throwable) {
                        throw new CoreException((IStatus)new Status(567, "", throwable.getMessage()));
                    }
                    object = this.firstPage.getJadFileName();
                    IJavaProject iJavaProject = super.getJavaProject();
                    MidletSuiteFactory.MidletSuiteCreationRunnable midletSuiteCreationRunnable = MidletSuiteFactory.getMidletSuiteCreationRunnable((IProject)this.currProject, (IJavaProject)iJavaProject, (IMIDPDevice)((IMIDPDevice)iDevice), (String)object);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("MIDlet-Name", this.propertiesPage.getMIDletName());
                    hashMap.put("MIDlet-Vendor", this.propertiesPage.getMIDletVendor());
                    hashMap.put("MIDlet-Version", this.propertiesPage.getMIDletVersion());
                    hashMap.put("MicroEdition-Configuration", this.propertiesPage.getMeConfiguration());
                    hashMap.put("MicroEdition-Profile", this.propertiesPage.getMeProfile());
                    midletSuiteCreationRunnable.setProperties(hashMap);
                    midletSuiteCreationRunnable.setPreprocessingEnable(this.propertiesPage.isPreprocessingEnabled());
                    boolean bl = this.propertiesPage.isLocalizationEnabled();
                    midletSuiteCreationRunnable.setLocalizationEnabled(bl);
                    if (bl) {
                        midletSuiteCreationRunnable.setPropertiesFolderName(this.propertiesPage.getPropertiesFolderName());
                        midletSuiteCreationRunnable.setPackageName(this.propertiesPage.getPackageName());
                    }
                    midletSuiteCreationRunnable.setJMUnitSupport(this.propertiesPage.isJMUnitEnabled());
                    midletSuiteCreationRunnable.run(iProgressMonitor);
                    IAdaptable[] iAdaptableArray = new IAdaptable[]{this.currProject};
                    IWorkingSet iWorkingSet = this.firstPage.getWorkingSet();
                    if (iWorkingSet != null) {
                        IAdaptable iAdaptable;
                        Vector<IAdaptable> vector = new Vector<IAdaptable>();
                        IAdaptable[] iAdaptableArray2 = iWorkingSet.getElements();
                        int n = iAdaptableArray2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            iAdaptable = iAdaptableArray2[n2];
                            vector.add(iAdaptable);
                            ++n2;
                        }
                        iAdaptableArray2 = iWorkingSet.adaptElements(iAdaptableArray);
                        n = iAdaptableArray2.length;
                        n2 = 0;
                        while (n2 < n) {
                            iAdaptable = iAdaptableArray2[n2];
                            vector.add(iAdaptable);
                            ++n2;
                        }
                        iAdaptable = new IAdaptable[vector.size()];
                        iWorkingSet.setElements((IAdaptable[])vector.toArray((T[])iAdaptable));
                        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                        iWorkingSetManager.addRecentWorkingSet(iWorkingSet);
                    }
                }
                catch (CoreException coreException) {
                    if (coreException.getStatus().getCode() == 567) {
                        iStatus = new Status(1, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletProjectWizardPageThree_updateProject_fail_read_metadata);
                        this.deleteProjectFile(uRI);
                        if (this.currProject.exists()) {
                            this.currProject.delete(true, null);
                        }
                        NewMidletProjectWizardPageJavaSettings.createProject((IProject)this.currProject, (URI)this.currProjectLocation, null);
                    }
                    throw coreException;
                }
                catch (Throwable throwable) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.initializeBuildPath(JavaCore.create((IProject)this.currProject), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
            }
            catch (Exception exception) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
        finally {
            iProgressMonitor.done();
        }
        return iStatus;
    }

    private boolean useSourceAndBinaryFolders() {
        IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
        return iPreferenceStore.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects");
    }

    protected IProject createProvisonalProject() {
        IStatus iStatus = this.changeToNewProject();
        if (iStatus != null && !iStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"createProvisonalProject", null, (IStatus)iStatus);
        }
        return this.currProject;
    }

    protected void initializeBuildPath(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(MTJUIMessages.NewMidletProjectWizardPageThree_updateProject_monitor_buildpath_name, 2);
        try {
            IFolder iFolder;
            IClasspathEntry[] iClasspathEntryArray = null;
            IProject iProject = iJavaProject.getProject();
            ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
            IWorkspaceRoot iWorkspaceRoot = iProject.getWorkspace().getRoot();
            IClasspathEntry iClasspathEntry = this.getSrcPathEntry(iProject.getFullPath());
            if (iClasspathEntry.getPath() != iProject.getFullPath() && !(iFolder = iWorkspaceRoot.getFolder(iClasspathEntry.getPath())).exists()) {
                iFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
            arrayList.add(iClasspathEntry);
            this.addResourcesDirectoryIfRequested(arrayList, iProject);
            iFolder = new Path("org.elipse.mtj.JavaMEContainer/" + this.firstPage.getSelectedDevice());
            arrayList.add(JavaCore.newContainerEntry((IPath)iFolder));
            if (this.pageLibrary != null) {
                List<IPath> list = this.pageLibrary.getSelectedLibraries();
                if (this.propertiesPage.isJMUnitEnabled()) {
                    String string;
                    String string2 = "JMUnit for CLDC 1.1";
                    IExternalLibrary iExternalLibrary = ExternalLibraryManager.getInstance().getMidletLibrary(string2);
                    if (iExternalLibrary == null) {
                        string = NLS.bind((String)"ExternalLibraryManager does not contain a {0} library.", (Object)string2);
                        MTJStatusHandler.throwCoreException((int)4, (int)-999, (String)string);
                    }
                    string = new Path("org.eclipse.mtj.core.EXTERNAL_LIBRARY" + File.separator + string2);
                    list.add((IPath)string);
                }
                for (IPath iPath : list) {
                    arrayList.add(JavaCore.newContainerEntry((IPath)iPath, (boolean)true));
                }
            }
            iClasspathEntryArray = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.init(iJavaProject, this.getOutputLocation(), iClasspathEntryArray, true);
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void removeProvisonalProject() {
        if (!this.currProject.exists()) {
            this.currProject = null;
            return;
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                NewMidletProjectWizardPageJavaSettings.this.doRemoveProject(iProgressMonitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(iRunnableWithProgress));
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = MTJUIMessages.NewMidletProjectWizardPageThree_updateProject_errordialog_title;
            String string2 = MTJUIMessages.NewMidletProjectWizardPageThree_updateProject_errordialog_message;
            ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected final boolean useNewSourcePage() {
        return true;
    }
}

