/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.ISDKProvider;
import org.eclipse.mtj.core.sdk.ManagedSDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IManagedDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.ImportedSDKProvider;
import org.eclipse.mtj.internal.core.sdk.SDKProviderRegistry;
import org.eclipse.mtj.internal.core.sdk.device.AbstractMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.DeviceRegistry;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.devices.DeviceEditorConfigElement;
import org.eclipse.mtj.internal.ui.devices.DeviceEditorRegistry;
import org.eclipse.mtj.internal.ui.devices.DeviceImportWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceManagementPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.mtj.ui.preferences.deviceManagementPreferencePage";
    private static final int DEFAULT_COLUMN_IDX = 1;
    private static final String DEFAULT_MARKER = "\u25cf\u25cf";
    private Tree deviceTree;
    private Button deleteButton;
    private Button duplicateButton;
    private Button editButton;
    private Button setDefaultButton;
    private Button importButton;
    private IAction editAction;
    private IActionDelegate editDelegate;
    private IWorkbench workbench;
    private Font boldFont;
    private Image IMG_FOLDER;
    private Image IMG_CELLPHONE;

    public DeviceManagementPreferencePage() {
        super(MTJUIMessages.DeviceManagementPreferencePage_title);
        this.setDescription(String.valueOf(MTJUIMessages.DeviceManagementPreferencePage_description) + "\n\n" + MTJUIMessages.DeviceManagementPreferencePage_instaled_sdks_label);
        this.setPreferenceStore(MTJUIPlugin.getDefault().getCorePreferenceStore());
        this.noDefaultAndApplyButton();
        this.editAction = new Action(){};
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.IMG_FOLDER = iSharedImages.getImage("IMG_OBJ_FOLDER");
        this.IMG_CELLPHONE = MTJUIPluginImages.DESC_CELLPHONE_OBJ.createImage();
    }

    public void init(IWorkbench iWorkbench) {
        this.workbench = iWorkbench;
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = true;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        try {
            DeviceRegistry.getInstance().load();
        }
        catch (Exception exception) {
            MTJLogger.log((int)4, (Throwable)exception);
            this.createErrorContents(composite2, exception);
            return composite2;
        }
        try {
            this.createDeviceContents(composite2);
        }
        catch (Exception exception) {
            MTJLogger.log((int)4, (Throwable)exception);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.mtj.ui.help_DeviceManagementPage");
        return composite2;
    }

    private Control createDeviceContents(Composite composite) {
        Display display;
        FontData[] fontDataArray;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 475;
        gridData.heightHint = 400;
        this.deviceTree = new Tree(composite2, 2818);
        this.deviceTree.setHeaderVisible(true);
        this.deviceTree.setLayoutData((Object)gridData);
        this.deviceTree.setLinesVisible(true);
        this.deviceTree.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                DeviceManagementPreferencePage.this.handleTreeDoubleClick();
            }
        });
        this.deviceTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceManagementPreferencePage.this.handleTreeSelection();
            }
        });
        this.deviceTree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent treeEvent) {
                DeviceManagementPreferencePage.this.adjustDefaultMarker();
            }

            public void treeExpanded(TreeEvent treeEvent) {
                DeviceManagementPreferencePage.this.adjustDefaultMarker();
            }
        });
        TreeColumn treeColumn = new TreeColumn(this.deviceTree, 16384);
        treeColumn.setText(MTJUIMessages.DeviceManagementPreferencePage_name_columnInfo);
        treeColumn.setWidth(315);
        treeColumn.setAlignment(16384);
        TreeColumn treeColumn2 = new TreeColumn(this.deviceTree, 0x1000000, 1);
        treeColumn2.setText(MTJUIMessages.DeviceManagementPreferencePage_default_columnInfo);
        treeColumn2.setWidth(55);
        TreeColumn treeColumn3 = new TreeColumn(this.deviceTree, 16384);
        treeColumn3.setText(MTJUIMessages.DeviceManagementPreferencePage_configuration_columnInfo);
        treeColumn3.setWidth(80);
        TreeColumn treeColumn4 = new TreeColumn(this.deviceTree, 16384);
        treeColumn4.setText(MTJUIMessages.DeviceManagementPreferencePage_profile_columnInfo);
        treeColumn4.setWidth(60);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(1, true));
        composite3.setLayoutData((Object)new GridData(1040));
        this.editButton = new Button(composite3, 8);
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.setText(MTJUIMessages.DeviceManagementPreferencePage_editButton_lable_text);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceManagementPreferencePage.this.updateButtonEnablement();
                DeviceManagementPreferencePage.this.updateEditDelegate();
                DeviceManagementPreferencePage.this.handleEditDevice();
            }
        });
        this.duplicateButton = new Button(composite3, 8);
        this.duplicateButton.setLayoutData((Object)new GridData(768));
        this.duplicateButton.setText(MTJUIMessages.DeviceManagementPreferencePage_duplicateButton_label_text);
        this.duplicateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceManagementPreferencePage.this.handleDuplicate();
            }
        });
        this.deleteButton = new Button(composite3, 8);
        this.deleteButton.setLayoutData((Object)new GridData(768));
        this.deleteButton.setText(MTJUIMessages.DeviceManagementPreferencePage_deleteButton_label_text);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceManagementPreferencePage.this.handleDelete();
            }
        });
        this.setDefaultButton = new Button(composite3, 8);
        this.setDefaultButton.setLayoutData((Object)new GridData(768));
        this.setDefaultButton.setText(MTJUIMessages.DeviceManagementPreferencePage_setDefaultButton_label_text);
        this.setDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceManagementPreferencePage.this.handleSetDefault();
            }
        });
        new Label(composite3, 0);
        this.importButton = new Button(composite3, 8);
        this.importButton.setLayoutData((Object)new GridData(768));
        this.importButton.setText(MTJUIMessages.DeviceManagementPreferencePage_importButton_label_text);
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceManagementPreferencePage.this.handleImport();
            }
        });
        FontData[] fontDataArray2 = fontDataArray = this.deviceTree.getFont().getFontData();
        int n = fontDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            display = fontDataArray2[n2];
            display.setStyle(display.getStyle() | 1);
            ++n2;
        }
        display = Display.getDefault();
        this.boldFont = new Font((Device)display, fontDataArray);
        this.refreshDeviceTree();
        this.doDefaultTreeExpand();
        this.updateEditDelegate();
        this.updateButtonEnablement();
        this.selectStartingDefaultDevice();
        return composite2;
    }

    private Control createErrorContents(Composite composite, Exception exception) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        String string = NLS.bind((String)MTJUIMessages.DeviceManagementPreferencePage_error_reading_device_registry, (Object[])new String[]{exception.getClass().getName(), exception.getMessage()});
        Text text = new Text(composite2, 2122);
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        text.setText(string);
        return composite2;
    }

    private void refreshDeviceTree() {
        this.deviceTree.setRedraw(false);
        this.deviceTree.removeAll();
        IDevice iDevice = DeviceRegistry.getInstance().getDefaultDevice();
        List list = SDKProviderRegistry.getInstance().getSDKProviders();
        Collections.sort(list);
        list.add(0, ImportedSDKProvider.getInstance());
        for (ISDKProvider iSDKProvider : list) {
            ISDK iSDK3;
            ISDK iSDK2;
            List list2 = iSDKProvider.getSDKs();
            if (list2.size() < 1) continue;
            TreeItem treeItem = new TreeItem(this.deviceTree, 0);
            treeItem.setData((Object)new MTJObject(iSDKProvider));
            treeItem.setText(iSDKProvider.getName());
            Image image = iSDKProvider.getLogo();
            if (iSDKProvider.getLogo() != null) {
                treeItem.setImage(image);
            } else {
                treeItem.setImage(this.IMG_FOLDER);
            }
            treeItem.setFont(this.boldFont);
            if (list2.size() > 1) {
                iSDK2 = new TreeMap();
                for (ISDK iSDK3 : iSDKProvider.getSDKs()) {
                    iSDK2.put(iSDK3.getName(), iSDK3);
                }
                list2.clear();
                list2.addAll(iSDK2.values());
            }
            iSDK3 = list2.iterator();
            while (iSDK3.hasNext()) {
                IDevice iDevice2;
                TreeItem treeItem2;
                IDevice iDevice3;
                List list3;
                iSDK2 = (ISDK)iSDK3.next();
                try {
                    list3 = iSDK2.getDeviceList();
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                    continue;
                }
                if (list3.size() < 1) continue;
                TreeItem treeItem3 = new TreeItem(treeItem, 0);
                treeItem3.setData((Object)new MTJObject(iSDK2));
                treeItem3.setText(iSDK2.getName());
                if (iSDK2 instanceof ManagedSDK) {
                    treeItem3.setImage(MTJUIPluginImages.DESC_IU_OBJ.createImage());
                } else {
                    treeItem3.setImage(this.IMG_FOLDER);
                }
                if (list3.size() >= 1) {
                    iDevice3 = new TreeMap();
                    treeItem2 = list3.iterator();
                    while (treeItem2.hasNext()) {
                        iDevice2 = (IDevice)treeItem2.next();
                        iDevice3.put(iDevice2.getName(), iDevice2);
                    }
                    list3.clear();
                    list3.addAll(iDevice3.values());
                }
                iDevice2 = list3.iterator();
                while (iDevice2.hasNext()) {
                    iDevice3 = (IDevice)iDevice2.next();
                    treeItem2 = new TreeItem(treeItem3, 0);
                    treeItem2.setData((Object)new MTJObject(iDevice3));
                    String string = iDevice3.getName();
                    String string2 = "";
                    if (iDevice != null && iDevice3.getName().equals(iDevice.getName()) && iDevice3.getSDKName().equals(iDevice.getSDKName())) {
                        string2 = DEFAULT_MARKER;
                    }
                    String string3 = "";
                    String string4 = "";
                    if (iDevice3 instanceof IMIDPDevice) {
                        IMIDPAPI iMIDPAPI;
                        IMIDPAPI iMIDPAPI2 = ((IMIDPDevice)iDevice3).getCLDCAPI();
                        if (iMIDPAPI2 != null) {
                            string3 = iMIDPAPI2.toString();
                        }
                        if ((iMIDPAPI = ((IMIDPDevice)iDevice3).getMIDPAPI()) != null) {
                            string4 = iMIDPAPI.toString();
                        }
                    }
                    treeItem2.setText(new String[]{string, string2, string3, string4});
                    treeItem2.setImage(this.IMG_CELLPHONE);
                }
            }
        }
        this.deviceTree.setRedraw(true);
    }

    private void doDefaultTreeExpand() {
        TreeItem[] treeItemArray;
        TreeItem[] treeItemArray2 = treeItemArray = this.deviceTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem[] treeItemArray3;
            TreeItem treeItem = treeItemArray2[n2];
            treeItem.setExpanded(true);
            TreeItem[] treeItemArray4 = treeItemArray3 = treeItem.getItems();
            int n3 = treeItemArray3.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem treeItem2 = treeItemArray4[n4];
                treeItem2.setExpanded(true);
                ++n4;
            }
            ++n2;
        }
    }

    private void toggleExpansionOnSelectedItem() {
        TreeItem[] treeItemArray = this.deviceTree.getSelection();
        if (treeItemArray.length == 1) {
            treeItemArray[0].setExpanded(!treeItemArray[0].getExpanded());
            this.adjustDefaultMarker();
        }
    }

    private List<String> recordProviderAndSdkExpansionStates() {
        TreeItem[] treeItemArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        TreeItem[] treeItemArray2 = treeItemArray = this.deviceTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray2[n2];
            if (treeItem.getExpanded()) {
                TreeItem[] treeItemArray3;
                MTJObject mTJObject = (MTJObject)treeItem.getData();
                arrayList.add(mTJObject.getSdkProvider().getName());
                TreeItem[] treeItemArray4 = treeItemArray3 = treeItem.getItems();
                int n3 = treeItemArray3.length;
                int n4 = 0;
                while (n4 < n3) {
                    MTJObject mTJObject2;
                    TreeItem treeItem2 = treeItemArray4[n4];
                    if (treeItem2.getExpanded() && (mTJObject2 = (MTJObject)treeItem2.getData()) != null) {
                        arrayList.add(mTJObject2.getSdk().getName());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return arrayList;
    }

    private void replayItemExpansionStates(List<String> list) {
        TreeItem[] treeItemArray;
        TreeItem[] treeItemArray2 = treeItemArray = this.deviceTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray2[n2];
            if (list.contains(treeItem.getText())) {
                TreeItem[] treeItemArray3;
                treeItem.setExpanded(true);
                TreeItem[] treeItemArray4 = treeItemArray3 = treeItem.getItems();
                int n3 = treeItemArray3.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem treeItem2 = treeItemArray4[n4];
                    treeItem2.setExpanded(list.contains(treeItem2.getText()));
                    ++n4;
                }
            }
            ++n2;
        }
        this.adjustDefaultMarker();
    }

    private void adjustDefaultMarker() {
        TreeItem treeItem;
        TreeItem[] treeItemArray;
        TreeItem treeItem2 = null;
        TreeItem treeItem3 = null;
        TreeItem treeItem4 = null;
        TreeItem[] treeItemArray2 = treeItemArray = this.deviceTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem[] treeItemArray3;
            treeItem = treeItemArray2[n2];
            TreeItem[] treeItemArray4 = treeItemArray3 = treeItem.getItems();
            int n3 = treeItemArray3.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem[] treeItemArray5;
                TreeItem treeItem5 = treeItemArray4[n4];
                TreeItem[] treeItemArray6 = treeItemArray5 = treeItem5.getItems();
                int n5 = treeItemArray5.length;
                int n6 = 0;
                while (n6 < n5) {
                    TreeItem treeItem6 = treeItemArray6[n6];
                    MTJObject mTJObject = (MTJObject)treeItem6.getData();
                    IDevice iDevice = mTJObject.getDevice();
                    if (this.isDefaultDevice(iDevice)) {
                        treeItem4 = treeItem;
                        treeItem3 = treeItem5;
                        treeItem2 = treeItem6;
                        break;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        if (treeItem2 != null) {
            treeItem = treeItem3;
            final TreeItem treeItem7 = treeItem4;
            Runnable runnable = new Runnable(){

                public void run() {
                    treeItem.setText(1, "");
                    treeItem7.setText(1, "");
                    if (!treeItem7.getExpanded()) {
                        treeItem7.setText(1, DeviceManagementPreferencePage.DEFAULT_MARKER);
                    } else if (!treeItem.getExpanded()) {
                        treeItem.setText(1, DeviceManagementPreferencePage.DEFAULT_MARKER);
                    }
                }
            };
            this.deviceTree.getDisplay().asyncExec(runnable);
        }
    }

    private MTJObject getSelectedMTJObject() {
        TreeItem[] treeItemArray = this.deviceTree.getSelection();
        if (treeItemArray.length == 1) {
            return (MTJObject)treeItemArray[0].getData();
        }
        return null;
    }

    private List<MTJObject> getSelectedMTJObjects() {
        TreeItem[] treeItemArray;
        ArrayList<MTJObject> arrayList = new ArrayList<MTJObject>();
        TreeItem[] treeItemArray2 = treeItemArray = this.deviceTree.getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray2[n2];
            arrayList.add((MTJObject)treeItem.getData());
            ++n2;
        }
        return arrayList;
    }

    private IDevice getSelectedDevice() {
        MTJObject mTJObject = this.getSelectedMTJObject();
        if (mTJObject != null && mTJObject.isDevice) {
            return mTJObject.getDevice();
        }
        return null;
    }

    private void setSelectedDevice(IDevice iDevice) {
        TreeItem[] treeItemArray;
        this.deviceTree.redraw();
        TreeItem[] treeItemArray2 = treeItemArray = this.deviceTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem[] treeItemArray3;
            TreeItem treeItem = treeItemArray2[n2];
            TreeItem[] treeItemArray4 = treeItemArray3 = treeItem.getItems();
            int n3 = treeItemArray3.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem[] treeItemArray5;
                TreeItem treeItem2 = treeItemArray4[n4];
                TreeItem[] treeItemArray6 = treeItemArray5 = treeItem2.getItems();
                int n5 = treeItemArray5.length;
                int n6 = 0;
                while (n6 < n5) {
                    TreeItem treeItem3 = treeItemArray6[n6];
                    MTJObject mTJObject = (MTJObject)treeItem3.getData();
                    IDevice iDevice2 = mTJObject.getDevice();
                    if (iDevice == iDevice2) {
                        this.deviceTree.setSelection(treeItem3);
                        this.deviceTree.setFocus();
                        return;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void setSelectedDevices(List<IDevice> list) {
        TreeItem[] treeItemArray;
        TreeItem[] treeItemArray2 = new TreeItem[list.size()];
        int n = 0;
        this.deviceTree.redraw();
        TreeItem[] treeItemArray3 = treeItemArray = this.deviceTree.getItems();
        int n2 = treeItemArray.length;
        int n3 = 0;
        while (n3 < n2) {
            TreeItem[] treeItemArray4;
            TreeItem treeItem = treeItemArray3[n3];
            TreeItem[] treeItemArray5 = treeItemArray4 = treeItem.getItems();
            int n4 = treeItemArray4.length;
            int n5 = 0;
            while (n5 < n4) {
                TreeItem[] treeItemArray6;
                TreeItem treeItem2 = treeItemArray5[n5];
                TreeItem[] treeItemArray7 = treeItemArray6 = treeItem2.getItems();
                int n6 = treeItemArray6.length;
                int n7 = 0;
                while (n7 < n6) {
                    TreeItem treeItem3 = treeItemArray7[n7];
                    MTJObject mTJObject = (MTJObject)treeItem3.getData();
                    if (list.contains(mTJObject.getDevice())) {
                        treeItemArray2[n] = treeItem3;
                        ++n;
                    }
                    ++n7;
                }
                ++n5;
            }
            ++n3;
        }
        this.deviceTree.setSelection(treeItemArray2);
        this.deviceTree.setFocus();
    }

    private TreeItem getTreeItem(MTJObject mTJObject) {
        TreeItem[] treeItemArray;
        TreeItem[] treeItemArray2 = treeItemArray = this.deviceTree.getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray2[n2];
            MTJObject mTJObject2 = (MTJObject)treeItem.getData();
            if (mTJObject2 == mTJObject) {
                return treeItem;
            }
            ++n2;
        }
        return null;
    }

    private void handleSetDefault() {
        IDevice iDevice = this.getSelectedDevice();
        if (iDevice != null) {
            DeviceRegistry.getInstance().setDefaultDevice(iDevice);
            List<String> list = this.recordProviderAndSdkExpansionStates();
            this.deviceTree.setRedraw(false);
            this.refreshDeviceTree();
            this.replayItemExpansionStates(list);
            this.setSelectedDevice(iDevice);
            this.deviceTree.setRedraw(true);
            this.updateButtonEnablement();
        }
    }

    private void handleDelete() {
        ManagedSDK managedSDK;
        IDevice iDevice3;
        Object object;
        ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
        List<MTJObject> list = this.getSelectedMTJObjects();
        MTJObject mTJObject = list.get(0);
        TreeItem[] treeItemArray = this.deviceTree.getSelection();
        List<String> list2 = this.recordProviderAndSdkExpansionStates();
        if (mTJObject.isDevice) {
            for (MTJObject mTJObject2 : list) {
                arrayList.add(mTJObject2.getDevice());
            }
        } else if (mTJObject.isSdk) {
            for (MTJObject mTJObject2 : list) {
                object = this.getTreeItem(mTJObject2);
                if (object != null) {
                    object.setExpanded(true);
                }
                iDevice3 = mTJObject2.getSdk();
                try {
                    arrayList.addAll(iDevice3.getDeviceList());
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
        } else if (mTJObject.isSdkProvider) {
            for (MTJObject mTJObject2 : list) {
                Object object2;
                object = this.getTreeItem(mTJObject2);
                if (object != null) {
                    object.setExpanded(true);
                    IDevice iDevice2 = iDevice3 = object.getItems();
                    int n = ((TreeItem[])iDevice2).length;
                    int n2 = 0;
                    while (n2 < n) {
                        object2 = iDevice2[n2];
                        object2.setExpanded(true);
                        ++n2;
                    }
                }
                iDevice3 = mTJObject2.getSdkProvider();
                object2 = iDevice3.getSDKs();
                managedSDK = object2.iterator();
                while (managedSDK.hasNext()) {
                    ISDK iSDK = (ISDK)managedSDK.next();
                    try {
                        arrayList.addAll(iSDK.getDeviceList());
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                }
            }
        }
        if (arrayList.isEmpty()) {
            return;
        }
        this.setSelectedDevices(arrayList);
        int n = arrayList.size();
        String string = MTJUIMessages.DeviceManagementPreferencePage_confirm_delete_dialog_title;
        object = NLS.bind((String)MTJUIMessages.DeviceManagementPreferencePage_confirm_delet_dialog_message, (Object)n);
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)string, (String)object)) {
            for (IDevice iDevice3 : arrayList) {
                if (iDevice3 instanceof IManagedDevice) {
                    ISDK iSDK = iDevice3.getSDK();
                    managedSDK = (ManagedSDK)iSDK;
                    managedSDK.deleteDuplicateDevice((IManagedDevice)iDevice3);
                    continue;
                }
                try {
                    if (ImportedSDKProvider.getInstance().removeDevice(iDevice3)) continue;
                    throw new PersistenceException();
                }
                catch (PersistenceException persistenceException) {
                    this.handleException(MTJUIMessages.DeviceManagementPreferencePage_error_remove_device, persistenceException);
                }
            }
            this.refreshDeviceTree();
            this.updateButtonEnablement();
            this.selectStartingDefaultDevice();
        }
        this.replayItemExpansionStates(list2);
        this.deviceTree.setSelection(treeItemArray);
        this.updateButtonEnablement();
    }

    private void handleDuplicate() {
        IDevice iDevice = this.getSelectedDevice();
        if (iDevice == null) {
            return;
        }
        ISDK iSDK = iDevice.getSDK();
        IDevice iDevice2 = null;
        String string = this.findUniqueName(iDevice);
        iDevice2 = iSDK instanceof ManagedSDK ? ((ManagedSDK)iSDK).duplicateDevice((IManagedDevice)iDevice, string) : ImportedSDKProvider.getInstance().duplicateDevice(iDevice, string);
        try {
            if (iDevice2 == null) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handleException(MTJUIMessages.DeviceManagementPreferencePage_error_duplicated_device, exception);
        }
        List<String> list = this.recordProviderAndSdkExpansionStates();
        this.refreshDeviceTree();
        this.replayItemExpansionStates(list);
        this.setSelectedDevice(iDevice2);
        this.updateButtonEnablement();
    }

    private void handleEditDevice() {
        IDevice iDevice = this.getSelectedDevice();
        if (iDevice instanceof IMIDPDevice && this.editDelegate != null) {
            this.editDelegate.run(this.editAction);
        }
    }

    private void handleImport() {
        DeviceImportWizard deviceImportWizard = new DeviceImportWizard();
        WizardDialog wizardDialog = new WizardDialog(this.workbench.getActiveWorkbenchWindow().getShell(), (IWizard)deviceImportWizard);
        if (wizardDialog.open() == 0) {
            this.refreshDeviceTree();
            this.updateButtonEnablement();
            this.doDefaultTreeExpand();
            this.selectStartingDefaultDevice();
        }
    }

    private void handleTreeDoubleClick() {
        MTJObject mTJObject = this.getSelectedMTJObject();
        if (mTJObject != null) {
            if (mTJObject.canExpand) {
                this.toggleExpansionOnSelectedItem();
            } else if (mTJObject.canEdit) {
                this.updateButtonEnablement();
                this.updateEditDelegate();
                this.handleEditDevice();
            }
        }
    }

    private void handleTreeSelection() {
        this.updateEditDelegate();
        this.updateButtonEnablement();
    }

    public boolean performOk() {
        boolean bl = false;
        try {
            DeviceRegistry.getInstance().store();
            bl = true;
        }
        catch (Exception exception) {
            MTJUIPlugin.displayError(this.getShell(), 4, -999, MTJUIMessages.DeviceManagementPreferencePage_error_storing_devises_dialog_title, MTJUIMessages.DeviceManagementPreferencePage_error_storing_devises_dialog_message, exception);
            MTJLogger.log((int)4, (String)NLS.bind((String)MTJUIMessages.DeviceManagementPreferencePage_error_storing_devises_log_msg, (Object[])new String[]{exception.getClass().getName(), exception.getMessage()}), (Throwable)exception);
        }
        return bl;
    }

    private void updateEditDelegate() {
        this.editDelegate = null;
        IDevice iDevice = this.getSelectedDevice();
        if (iDevice instanceof AbstractMIDPDevice) {
            AbstractMIDPDevice abstractMIDPDevice = (AbstractMIDPDevice)iDevice;
            TreePath treePath = new TreePath((Object[])new AbstractMIDPDevice[]{abstractMIDPDevice});
            TreeSelection treeSelection = new TreeSelection(treePath);
            this.editDelegate = this.findActionDelegate(iDevice);
            if (this.editDelegate != null) {
                this.editDelegate.selectionChanged(this.editAction, (ISelection)treeSelection);
            }
        }
    }

    private void updateButtonEnablement() {
        List<MTJObject> list = this.getSelectedMTJObjects();
        if (list.size() == 1) {
            MTJObject mTJObject = list.get(0);
            this.duplicateButton.setEnabled(mTJObject.canDuplicate);
            this.editButton.setEnabled(mTJObject.canEdit && this.editDelegate != null && this.editAction.isEnabled());
            IDevice iDevice = mTJObject.getDevice();
            this.setDefaultButton.setEnabled(mTJObject.canSetDefault && !this.isDefaultDevice(iDevice));
        } else {
            this.duplicateButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.setDefaultButton.setEnabled(false);
        }
        this.deleteButton.setEnabled(this.canDoDelete(list));
    }

    private boolean canDoDelete(List<MTJObject> list) {
        if (list.isEmpty()) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (MTJObject mTJObject : list) {
            if (!mTJObject.canDelete) {
                return false;
            }
            if (mTJObject.isSdkProvider) {
                ++n;
                continue;
            }
            if (mTJObject.isSdk) {
                ++n2;
                continue;
            }
            if (!mTJObject.isDevice) continue;
            ++n3;
        }
        return (n <= 0 || n2 <= 0 && n3 <= 0) && (n2 <= 0 || n <= 0 && n3 <= 0) && (n3 <= 0 || n2 <= 0 && n <= 0);
    }

    private void selectStartingDefaultDevice() {
        if (DeviceRegistry.getInstance().getDefaultDevice() == null) {
            TreeItem[] treeItemArray;
            TreeItem[] treeItemArray2 = treeItemArray = this.deviceTree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem[] treeItemArray3;
                TreeItem treeItem = treeItemArray2[n2];
                TreeItem[] treeItemArray4 = treeItemArray3 = treeItem.getItems();
                int n3 = treeItemArray3.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem[] treeItemArray5;
                    TreeItem treeItem2 = treeItemArray4[n4];
                    TreeItem[] treeItemArray6 = treeItemArray5 = treeItem2.getItems();
                    int n5 = treeItemArray5.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        TreeItem treeItem3 = treeItemArray6[n6];
                        MTJObject mTJObject = (MTJObject)treeItem3.getData();
                        if (mTJObject.isDevice) {
                            IDevice iDevice = mTJObject.getDevice();
                            DeviceRegistry.getInstance().setDefaultDevice(iDevice);
                            List<String> list = this.recordProviderAndSdkExpansionStates();
                            this.refreshDeviceTree();
                            this.replayItemExpansionStates(list);
                            return;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private boolean isDefaultDevice(IDevice iDevice) {
        if (iDevice == null) {
            return false;
        }
        String string = iDevice.getName();
        if (string == null) {
            return false;
        }
        String string2 = iDevice.getSDKName();
        if (string2 == null) {
            return false;
        }
        IDevice iDevice2 = DeviceRegistry.getInstance().getDefaultDevice();
        if (iDevice2 == null) {
            return false;
        }
        String string3 = iDevice2.getName();
        if (string3 == null) {
            return false;
        }
        String string4 = iDevice2.getSDKName();
        if (string4 == null) {
            return false;
        }
        return string3.equals(string) && string4.equals(string2);
    }

    private IActionDelegate findActionDelegate(IDevice iDevice) {
        IActionDelegate iActionDelegate = null;
        DeviceEditorConfigElement deviceEditorConfigElement = DeviceEditorRegistry.findEditorElement(iDevice);
        if (deviceEditorConfigElement != null) {
            try {
                iActionDelegate = deviceEditorConfigElement.getActionDelegate();
            }
            catch (CoreException coreException) {
                MTJLogger.log((int)2, (String)MTJUIMessages.DeviceManagementPreferencePage_error_findActionDelegate, (Throwable)coreException);
            }
        }
        return iActionDelegate;
    }

    private void handleException(String string, Throwable throwable) {
        MTJLogger.log((int)2, (String)MTJUIMessages.DeviceManagementPreferencePage_error_device_registry_exception, (Throwable)throwable);
        MTJUIPlugin.displayError(this.getShell(), 2, -999, MTJUIMessages.DeviceManagementPreferencePage_error_device_registry_error, string, throwable);
    }

    private String findUniqueName(IDevice iDevice) {
        Pattern pattern = Pattern.compile("^.+\\((\\d+)\\)$");
        String string = null;
        String string2 = iDevice.getSDKName();
        String string3 = iDevice.getName();
        int n = 1;
        while (n <= 100) {
            StringBuffer stringBuffer = new StringBuffer(string3);
            Matcher matcher = pattern.matcher(stringBuffer);
            if (matcher.find()) {
                int n2 = matcher.start(1);
                int n3 = matcher.end(1);
                stringBuffer.replace(n2, n3, Integer.toString(n));
            } else {
                stringBuffer.append(" (").append(n).append(")");
            }
            string = stringBuffer.toString();
            try {
                IMIDPDevice iMIDPDevice = (IMIDPDevice)DeviceRegistry.getInstance().getDevice(string2, string);
                if (iMIDPDevice == null) {
                    break;
                }
            }
            catch (PersistenceException persistenceException) {
                MTJLogger.log((int)4, (String)MTJUIMessages.DeviceManagementPreferencePage_error_find_device, (Throwable)persistenceException);
            }
            ++n;
        }
        return string;
    }

    private static class MTJObject {
        private Object payload;
        boolean isDevice;
        boolean isSdk;
        boolean isSdkProvider;
        boolean canEdit;
        boolean canDuplicate;
        boolean canSetDefault;
        boolean canExpand;
        boolean canDelete;

        MTJObject(Object object) {
            this.payload = object;
            if (object instanceof IDevice) {
                this.isDevice = true;
                this.canEdit = true;
                this.canDuplicate = true;
                this.canDelete = object instanceof IManagedDevice ? ((IManagedDevice)object).isDuplicate() : true;
                this.canSetDefault = true;
            } else if (object instanceof ISDK) {
                this.isSdk = true;
                this.canExpand = true;
                this.canDelete = !(object instanceof ManagedSDK);
            } else if (object instanceof ISDKProvider) {
                this.isSdkProvider = true;
                this.canExpand = true;
                this.canDelete = object instanceof ImportedSDKProvider;
            } else {
                throw new IllegalArgumentException();
            }
        }

        IDevice getDevice() {
            return this.isDevice ? (IDevice)this.payload : null;
        }

        ISDK getSdk() {
            return this.isSdk ? (ISDK)this.payload : null;
        }

        ISDKProvider getSdkProvider() {
            return this.isSdkProvider ? (ISDKProvider)this.payload : null;
        }
    }
}

