/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.export.states;

import java.io.File;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.internal.core.build.export.AntennaExportException;
import org.eclipse.mtj.internal.core.build.export.states.AbstractCreateAntTaskState;
import org.eclipse.mtj.internal.core.statemachine.StateMachine;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateAntBuildTaskState
extends AbstractCreateAntTaskState {
    public CreateAntBuildTaskState(StateMachine stateMachine, IMidletSuiteProject iMidletSuiteProject, Document document) {
        super(stateMachine, iMidletSuiteProject, document);
    }

    protected void onEnter(MTJRuntime mTJRuntime) throws AntennaExportException {
        Document document = this.getDocument();
        Element element = document.getDocumentElement();
        String string = this.getFormatedName(mTJRuntime.getName());
        Element element2 = XMLUtils.createTargetElement(document, element, NLS.bind((String)"build-{0}", (Object)string), this.getDependencies(mTJRuntime));
        Element element3 = document.createElement("copy");
        element2.appendChild(element3);
        Object[] objectArray = new String[]{"mtj-build", string, this.getFormatedName(this.getMidletSuiteProject().getProject().getName())};
        element3.setAttribute("todir", NLS.bind((String)"{0}/{1}/{2}/resources/", (Object[])objectArray));
        Set<IProject> set = this.getRequiredProjects(this.getMidletSuiteProject().getProject());
        for (IProject iDevice2 : set) {
            Element element4 = document.createElement("fileset");
            element3.appendChild(element4);
            element4.setAttribute("dir", NLS.bind((String)"{0}/{1}/{2}/resources/", (Object[])new String[]{"mtj-build", string, this.getFormatedName(iDevice2.getName())}));
        }
        IDevice iDevice = mTJRuntime.getDevice();
        this.createWtkBuildTarget(element2, string, iDevice);
    }

    private void createWtkBuildTarget(Element element, String string, IDevice iDevice) {
        Document document = this.getDocument();
        StringBuffer stringBuffer = new StringBuffer();
        IDeviceClasspath iDeviceClasspath = iDevice.getClasspath();
        for (ILibrary objectArray2 : iDeviceClasspath.getEntries()) {
            File file = objectArray2.toFile();
            stringBuffer.append(file.getAbsolutePath()).append(":");
        }
        Object[] objectArray = new String[]{"mtj-build", string, this.getFormatedName(this.getMidletSuiteProject().getProject().getName())};
        Element element2 = document.createElement("wtkbuild");
        element2.setAttribute("bootclasspath", stringBuffer.toString());
        element2.setAttribute("destdir", NLS.bind((String)"{0}/{1}/{2}/bin/", (Object[])objectArray));
        element2.setAttribute("encoding", "UTF-8");
        element2.setAttribute("source", "1.3");
        element2.setAttribute("sourcepath", "");
        element2.setAttribute("srcdir", NLS.bind((String)"{0}/{1}/{2}/classes/", (Object[])objectArray));
        element.appendChild(element2);
    }
}

