/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.export.states;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.internal.core.build.export.AntennaExportException;
import org.eclipse.mtj.internal.core.build.export.states.AbstractCreateAntTaskState;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.statemachine.StateMachine;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateAntCollectSourcesState
extends AbstractCreateAntTaskState {
    public CreateAntCollectSourcesState(StateMachine stateMachine, IMidletSuiteProject iMidletSuiteProject, Document document) {
        super(stateMachine, iMidletSuiteProject, document);
    }

    protected void onEnter(MTJRuntime mTJRuntime) throws AntennaExportException {
        Document document = this.getDocument();
        Element element = document.getDocumentElement();
        IProject iProject = this.getMidletSuiteProject().getProject();
        String string = this.getFormatedName(mTJRuntime.getName());
        Element element2 = XMLUtils.createTargetElement(document, element, NLS.bind((String)"collect-sources-{0}", (Object)string), this.getDependencies(mTJRuntime));
        Set<IProject> set = this.getRequiredProjects(iProject);
        for (IProject object2 : set) {
            this.copyProjectClasses(object2, document, element2, mTJRuntime);
        }
        this.copyProjectClasses(iProject, document, element2, mTJRuntime);
        Element element3 = document.createElement("copy");
        element2.appendChild(element3);
        element3.setAttribute("overwrite", "true");
        element3.setAttribute("todir", NLS.bind((String)"{0}/{1}/{2}/classes/", (Object[])new String[]{"mtj-build", string, this.getFormatedName(iProject.getName())}));
        for (IProject iProject2 : set) {
            Element element4 = document.createElement("fileset");
            element3.appendChild(element4);
            element4.setAttribute("dir", NLS.bind((String)"build/{0}/{1}/classes/", (Object[])new String[]{string, this.getFormatedName(iProject2.getName())}));
        }
    }

    private void copyProjectClasses(IProject iProject, Document document, Element element, MTJRuntime mTJRuntime) throws AntennaExportException {
        IResource[] iResourceArray;
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        if (iJavaProject == null) {
            return;
        }
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
        if (iMidletSuiteProject == null) {
            return;
        }
        String string = this.getFormatedName(mTJRuntime.getName());
        Element element2 = document.createElement("copy");
        element.appendChild(element2);
        element2.setAttribute("overwrite", "true");
        element2.setAttribute("todir", NLS.bind((String)"{0}/{1}/{2}/classes/", (Object[])new String[]{"mtj-build", string, this.getFormatedName(iProject.getName())}));
        IResource[] iResourceArray2 = iResourceArray = Utils.getSourceFolders(iMidletSuiteProject.getJavaProject());
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray2[n2];
            Element element3 = document.createElement("fileset");
            element3.setAttribute("dir", NLS.bind((String)"..{0}", (Object)iResource.getFullPath()));
            element3.setAttribute("includes", "**/**.java");
            element2.appendChild(element3);
            ++n2;
        }
    }
}

