/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.midp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistryListener;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteProject;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class MidletSuiteFactory {
    private static final Map<IJavaProject, IMidletSuiteProject> midletSuiteMap = new HashMap<IJavaProject, IMidletSuiteProject>();

    static {
        MTJCore.getDeviceRegistry().addRegistryListener(new DeviceRegistryListener());
    }

    public static MidletSuiteCreationRunnable getMidletSuiteCreationRunnable(IProject iProject, IJavaProject iJavaProject, IMIDPDevice iMIDPDevice, String string) {
        return new MidletSuiteCreationRunnable(iProject, iJavaProject, iMIDPDevice, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMidletSuiteProject getMidletSuiteProject(IJavaProject iJavaProject) {
        IMidletSuiteProject iMidletSuiteProject = null;
        Map<IJavaProject, IMidletSuiteProject> map = midletSuiteMap;
        synchronized (map) {
            iMidletSuiteProject = midletSuiteMap.get(iJavaProject);
            if (iMidletSuiteProject == null) {
                iMidletSuiteProject = new MidletSuiteProject(iJavaProject);
                midletSuiteMap.put(iJavaProject, iMidletSuiteProject);
            }
        }
        return iMidletSuiteProject;
    }

    public static IMTJProject getMidletSuiteProject(String string) {
        IMidletSuiteProject iMidletSuiteProject = null;
        try {
            IProject iProject;
            if (string != null && (iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string)).exists() && iProject.hasNature("org.eclipse.mtj.core.nature")) {
                iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(JavaCore.create((IProject)iProject));
            }
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, coreException);
        }
        return iMidletSuiteProject;
    }

    public static boolean isMidletSuiteProject(IProject iProject) {
        if (iProject == null) {
            return false;
        }
        IMTJProject iMTJProject = MidletSuiteFactory.getMidletSuiteProject(iProject.getName());
        return iMTJProject != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMidletSuiteProject(IJavaProject iJavaProject) {
        Map<IJavaProject, IMidletSuiteProject> map = midletSuiteMap;
        synchronized (map) {
            midletSuiteMap.remove(iJavaProject);
        }
    }

    private MidletSuiteFactory() {
    }

    public static class DeviceRegistryListener
    implements IDeviceRegistryListener {
        public void deviceAdded(IDevice iDevice) {
            for (IMTJProject iMTJProject : midletSuiteMap.values()) {
                MTJRuntimeList mTJRuntimeList = iMTJProject.getRuntimeList();
                for (MTJRuntime mTJRuntime : mTJRuntimeList) {
                    IDevice iDevice2 = mTJRuntime.getDevice();
                    if (!iDevice2.getIdentifier().equals(iDevice.getIdentifier())) continue;
                    mTJRuntime.setDevice(iDevice);
                    if (!mTJRuntime.isActive()) continue;
                    try {
                        iMTJProject.refreshClasspath((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {
                        MTJLogger.log(4, coreException);
                    }
                }
            }
        }

        public void deviceRemoved(IDevice iDevice) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MidletSuiteCreationRunnable {
        private static final String BIN_FOLDER_NAME = "bin";
        private static final String CONFIGURATION_VERSION_1_0 = "CLDC-1.0";
        private static final String MIDLET_DEFAULT_NAME_END = " MIDlet Suite";
        private static final String MIDLET_DEFAULT_VENDOR = "MIDlet Suite Vendor";
        private static final String MIDLET_INITIAL_VERSION_1_0_0 = "1.0.0";
        private IMIDPDevice device;
        private String jadFileName;
        private IJavaProject javaProject;
        private boolean preprocessingEnable;
        private IProject project;

        private MidletSuiteCreationRunnable(IProject iProject, IJavaProject iJavaProject, IMIDPDevice iMIDPDevice, String string) {
            this.project = iProject;
            this.javaProject = iJavaProject;
            this.device = iMIDPDevice;
            this.jadFileName = string;
        }

        public boolean isPreprocessingEnable() {
            return this.preprocessingEnable;
        }

        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
            try {
                IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(this.javaProject);
                iMidletSuiteProject.setJadFileName(this.jadFileName);
                this.addNatures(iProgressMonitor);
                this.setJavaProjectOptions(iProgressMonitor);
                this.setProjectMetadata();
                this.createApplicationDescriptorInProject(iProgressMonitor);
                this.setDeviceIntoActiveConfig(iMidletSuiteProject, this.device);
                iMidletSuiteProject.saveMetaData();
                iMidletSuiteProject.refreshClasspath(iProgressMonitor);
            }
            catch (CoreException coreException) {
                throw new InvocationTargetException(coreException);
            }
            catch (IOException iOException) {
                throw new InvocationTargetException(iOException);
            }
        }

        public void setPreprocessingEnable(boolean bl) {
            this.preprocessingEnable = bl;
        }

        private boolean addNatureIfNecessary(ArrayList<String> arrayList, String string) {
            boolean bl = false;
            if (!arrayList.contains(string)) {
                arrayList.add(string);
                bl = true;
            }
            return bl;
        }

        private void addNatures(IProgressMonitor iProgressMonitor) throws CoreException {
            IProjectDescription iProjectDescription = this.project.getDescription();
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(iProjectDescription.getNatureIds()));
            boolean bl = this.addNatureIfNecessary(arrayList, "org.eclipse.mtj.core.nature");
            bl |= this.addNatureIfNecessary(arrayList, "org.eclipse.jdt.core.javanature");
            if (this.isPreprocessingEnable()) {
                bl |= this.addNatureIfNecessary(arrayList, "org.eclipse.mtj.core.preprocessingNature");
            }
            if (bl) {
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                iProjectDescription.setNatureIds(arrayList.toArray(new String[arrayList.size()]));
                this.project.setDescription(iProjectDescription, (IProgressMonitor)subProgressMonitor);
            }
        }

        private void setDeviceIntoActiveConfig(IMidletSuiteProject iMidletSuiteProject, IDevice iDevice) {
            MTJRuntimeList mTJRuntimeList = iMidletSuiteProject.getRuntimeList();
            MTJRuntime mTJRuntime = mTJRuntimeList.getActiveMTJRuntime();
            if (mTJRuntime != null) {
                mTJRuntime.setDevice(iDevice);
                return;
            }
            if (mTJRuntime == null && !mTJRuntimeList.isEmpty()) {
                mTJRuntime = (MTJRuntime)mTJRuntimeList.get(0);
            }
            if (mTJRuntime == null) {
                mTJRuntime = new MTJRuntime(iDevice.getName());
                mTJRuntime.setSymbolSet(iDevice.getSymbolSet());
            }
            mTJRuntime.setActive(true);
            mTJRuntime.setDevice(iDevice);
            mTJRuntimeList.add(mTJRuntime);
        }

        private void createApplicationDescriptorInProject(IProgressMonitor iProgressMonitor) throws CoreException, IOException {
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(this.javaProject);
            IFile iFile = iMidletSuiteProject.getApplicationDescriptorFile();
            if (!iFile.exists()) {
                InputStream inputStream = this.getJADFileSource(iMidletSuiteProject);
                iFile.create(inputStream, true, iProgressMonitor);
            }
        }

        private String getConfigurationVersion() {
            IMIDPAPI iMIDPAPI = this.device.getCLDCAPI();
            return iMIDPAPI == null ? CONFIGURATION_VERSION_1_0 : iMIDPAPI.toString();
        }

        private ColonDelimitedProperties getDefaultApplicationDescriptorProperties(IMidletSuiteProject iMidletSuiteProject) {
            String string;
            ColonDelimitedProperties colonDelimitedProperties = new ColonDelimitedProperties();
            colonDelimitedProperties.setProperty("MIDlet-Jar-URL", iMidletSuiteProject.getJarFilename());
            colonDelimitedProperties.setProperty("MIDlet-Name", String.valueOf(this.project.getName()) + MIDLET_DEFAULT_NAME_END);
            colonDelimitedProperties.setProperty("MIDlet-Vendor", MIDLET_DEFAULT_VENDOR);
            colonDelimitedProperties.setProperty("MIDlet-Version", MIDLET_INITIAL_VERSION_1_0_0);
            String string2 = this.getConfigurationVersion();
            if (string2 != null) {
                colonDelimitedProperties.setProperty("MicroEdition-Configuration", string2);
            }
            if ((string = this.getProfileVersion()) != null) {
                colonDelimitedProperties.setProperty("MicroEdition-Profile", string);
            }
            return colonDelimitedProperties;
        }

        private InputStream getJADFileSource(IMidletSuiteProject iMidletSuiteProject) throws IOException, CoreException {
            Object object;
            InputStream inputStream = null;
            String string = iMidletSuiteProject.getJadFileName();
            IFolder iFolder = this.project.getFolder(BIN_FOLDER_NAME);
            if (iFolder.exists() && (object = iFolder.getFile(string)).exists()) {
                inputStream = object.getContents();
            }
            if (inputStream == null) {
                object = new ByteArrayOutputStream();
                ColonDelimitedProperties colonDelimitedProperties = this.getDefaultApplicationDescriptorProperties(iMidletSuiteProject);
                colonDelimitedProperties.store((OutputStream)object, "");
                inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
            }
            return inputStream;
        }

        private String getProfileVersion() {
            IMIDPAPI iMIDPAPI = this.device.getMIDPAPI();
            return iMIDPAPI == null ? null : iMIDPAPI.toString();
        }

        private void setJavaProjectOptions(IProgressMonitor iProgressMonitor) {
            Preferences preferences = MTJCore.getMTJCore().getPluginPreferences();
            boolean bl = preferences.getBoolean("force_java11");
            if (bl) {
                Map map = this.javaProject.getOptions(true);
                JavaCore.setComplianceOptions((String)"1.3", (Map)map);
                this.javaProject.setOptions(map);
            }
        }

        private void setProjectMetadata() throws CoreException {
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(this.javaProject);
            iMidletSuiteProject.saveMetaData();
        }
    }
}

