/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.packaging;

import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.FileOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.build.preverifier.IPreverificationError;
import org.eclipse.mtj.core.build.preverifier.PreverifierNotFoundException;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletDefinition;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.PreferenceAccessor;
import org.eclipse.mtj.internal.core.build.BuildStateMachine;
import org.eclipse.mtj.internal.core.build.MTJIncrementalProjectBuilder;
import org.eclipse.mtj.internal.core.build.packaging.PackageBuilderVisitor;
import org.eclipse.mtj.internal.core.build.packaging.ResourcesCollector;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationUtils;
import org.eclipse.mtj.internal.core.build.preverifier.builder.BuilderMessages;
import org.eclipse.mtj.internal.core.packaging.midp.DeployedJADWriter;
import org.eclipse.mtj.internal.core.packaging.midp.ObfuscatorTool;
import org.eclipse.mtj.internal.core.project.midp.ApplicationDescriptor;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.RequiredProjectsCPEntryVisitor;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageBuilder
extends MTJIncrementalProjectBuilder {
    public static final String ARG_DO_OBFUSCATION = "_do_obfuscation";
    public static final String ARG_DO_PACKAGE = "_do_package";
    public static final String ARG_UPDATE_VERSION = "_update_version";

    @Override
    protected IProject[] doBuild(int n, Map<?, ?> map, IProgressMonitor iProgressMonitor) throws CoreException {
        IMTJProject iMTJProject = this.getMTJProject();
        if (iMTJProject instanceof IMidletSuiteProject) {
            IMidletSuiteProject iMidletSuiteProject = (IMidletSuiteProject)iMTJProject;
            this.updatePackage(iMidletSuiteProject, n, map, iProgressMonitor);
        }
        return null;
    }

    @Override
    protected void doClean(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.subTask(BuilderMessages.PackageBuilder_cleaningRuntimeFolder);
        IProject iProject = this.getProject();
        IFolder iFolder = this.getRuntimeFolder(iProject);
        if (iFolder.exists()) {
            IResource[] iResourceArray;
            IResource[] iResourceArray2 = iResourceArray = iFolder.members();
            int n2 = iResourceArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IResource iResource = iResourceArray2[n3];
                iResource.delete(true, iProgressMonitor);
                ++n3;
            }
            iFolder.refreshLocal(0, iProgressMonitor);
        }
    }

    private void removeJADsAndJARs(IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        IResource[] iResourceArray;
        IResource[] iResourceArray2 = iResourceArray = iFolder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            IResource iResource = iResourceArray2[n2];
            if (iResource.getType() == 2) {
                this.removeJADsAndJARs((IFolder)iResource, iProgressMonitor);
            } else if (iResource.getType() == 1 && (string = ((IFile)iResource).getFileExtension()) != null && (string.equalsIgnoreCase("jad") || string.equalsIgnoreCase("jar"))) {
                iResource.delete(true, iProgressMonitor);
            }
            ++n2;
        }
    }

    private void updatePackage(IMidletSuiteProject iMidletSuiteProject, int n, Map<?, ?> map, IProgressMonitor iProgressMonitor) throws CoreException {
        IFile iFile;
        IProject iProject = iMidletSuiteProject.getProject();
        IFolder iFolder = this.getRuntimeFolder(iProject);
        if (!iFolder.exists()) {
            iFolder.create(true, true, iProgressMonitor);
        }
        try {
            boolean bl;
            boolean bl2 = bl = PreferenceAccessor.instance.getAutoversionPackage(iMidletSuiteProject.getProject()) && this.isBuildArgumentTrue(map, ARG_UPDATE_VERSION);
            if (bl) {
                iProgressMonitor.subTask(BuilderMessages.PackageBuilder_updatingJadVersion);
                iFile = iMidletSuiteProject.getApplicationDescriptorFile();
                this.updateJADVersion(iFile, iProgressMonitor);
            }
        }
        catch (IOException iOException) {
            MTJStatusHandler.throwCoreException(4, 999, iOException);
        }
        IFile iFile2 = iFolder.getFile(iMidletSuiteProject.getJarFilename());
        iFile = new de.schlichtherle.io.File(iFile2.getLocation().toOSString());
        iProgressMonitor.subTask(BuilderMessages.PackageBuilder_collectingSources);
        PackageBuilderVisitor packageBuilderVisitor = new PackageBuilderVisitor(iMidletSuiteProject, (de.schlichtherle.io.File)iFile);
        IResourceDelta iResourceDelta = this.getDelta(this.getProject());
        if (iResourceDelta == null) {
            IFolder object2 = PackageBuilder.getOutputFolder(iMidletSuiteProject.getJavaProject());
            if (object2.exists()) {
                object2.accept((IResourceVisitor)packageBuilderVisitor);
            }
        } else {
            iResourceDelta.accept((IResourceDeltaVisitor)packageBuilderVisitor);
        }
        iProgressMonitor.subTask(BuilderMessages.PackageBuilder_packagingResources);
        for (IFile iOException : packageBuilderVisitor.getResourcesToPackage()) {
            this.addFileToJAR((de.schlichtherle.io.File)iFile, iOException, PackageBuilder.getResourceZipPath(iMidletSuiteProject, iOException));
        }
        iProgressMonitor.subTask(BuilderMessages.PackageBuilder_packagingClasses);
        for (IFile iFile3 : packageBuilderVisitor.getClassesToPackage()) {
            this.addFileToJAR((de.schlichtherle.io.File)iFile, iFile3, PackageBuilder.getClassZipPath(iMidletSuiteProject, iFile3));
        }
        iProgressMonitor.subTask(BuilderMessages.PackageBuilder_packagingLibraries);
        this.addPreverifiedLibraries(iMidletSuiteProject, (de.schlichtherle.io.File)iFile, iProgressMonitor);
        iProgressMonitor.subTask(BuilderMessages.PackageBuilder_packagingDependencies);
        this.addRequiredProjectsClasses(iMidletSuiteProject, (de.schlichtherle.io.File)iFile, iProgressMonitor);
        this.addRequiredProjectsLibs(iMidletSuiteProject, (de.schlichtherle.io.File)iFile, iProgressMonitor);
        this.addRequiredProjectsResources(iMidletSuiteProject, (de.schlichtherle.io.File)iFile, iProgressMonitor);
        this.createManifestFile(iMidletSuiteProject, (de.schlichtherle.io.File)iFile, iProgressMonitor);
        try {
            try {
                de.schlichtherle.io.File.umount();
                File file = new File(iFile.getAbsolutePath());
                if (this.isBuildArgumentTrue(map, ARG_DO_OBFUSCATION)) {
                    iProgressMonitor.subTask(BuilderMessages.PackageBuilder_obfuscating);
                    this.doObfuscation(iMidletSuiteProject, file, iProgressMonitor);
                }
                DeployedJADWriter deployedJADWriter = new DeployedJADWriter(iMidletSuiteProject, iFolder, file);
                deployedJADWriter.writeDeployedJAD(true, iProgressMonitor);
                if (this.isBuildArgumentTrue(map, ARG_DO_PACKAGE)) {
                    iProgressMonitor.subTask(BuilderMessages.PackageBuilder_generatingDeploymentPackage);
                    this.createDeployedPackage(iMidletSuiteProject, (de.schlichtherle.io.File)iFile, map, iProgressMonitor);
                }
            }
            catch (ArchiveException archiveException) {
                MTJStatusHandler.throwCoreException(4, 999, archiveException);
                iFolder.refreshLocal(1, iProgressMonitor);
            }
            catch (IOException iOException) {
                MTJStatusHandler.throwCoreException(4, 999, iOException);
                iFolder.refreshLocal(1, iProgressMonitor);
            }
        }
        finally {
            iFolder.refreshLocal(1, iProgressMonitor);
        }
    }

    private void addRequiredProjectsResources(IMidletSuiteProject iMidletSuiteProject, de.schlichtherle.io.File file, IProgressMonitor iProgressMonitor) throws CoreException {
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        RequiredProjectsCPEntryVisitor requiredProjectsCPEntryVisitor = new RequiredProjectsCPEntryVisitor();
        requiredProjectsCPEntryVisitor.getRunner().run(iMidletSuiteProject.getJavaProject(), requiredProjectsCPEntryVisitor, iProgressMonitor);
        ArrayList<IJavaProject> arrayList2 = requiredProjectsCPEntryVisitor.getRequiredProjects();
        for (IJavaProject iJavaProject : arrayList2) {
            IPath iPath;
            IProject iProject = iJavaProject.getProject();
            IFolder iFolder = iProject.getFolder(iPath = iJavaProject.getOutputLocation().removeFirstSegments(iProject.getFullPath().segmentCount()));
            if (!iFolder.exists()) continue;
            ResourcesCollector resourcesCollector = new ResourcesCollector(iJavaProject);
            iFolder.accept((IResourceVisitor)resourcesCollector);
            arrayList.addAll(resourcesCollector.getResources());
        }
        for (IFile iFile : arrayList) {
            this.addRequiredResource(iFile, file);
        }
    }

    private void addRequiredResource(IFile iFile, de.schlichtherle.io.File file) throws CoreException {
        IPath iPath;
        IJavaProject iJavaProject = JavaCore.create((IProject)iFile.getProject());
        IPath iPath2 = iJavaProject.getOutputLocation();
        if (iPath2.isPrefixOf(iFile.getFullPath()) && !(iPath = iFile.getFullPath().removeFirstSegments(iPath2.segmentCount())).isEmpty()) {
            this.addResourceToJAR(file, (IResource)iFile, iPath);
        }
    }

    private void addRequiredProjectsClasses(IMidletSuiteProject iMidletSuiteProject, de.schlichtherle.io.File file, IProgressMonitor iProgressMonitor) throws CoreException {
        IFolder iFolder = iMidletSuiteProject.getVerifiedOutputFolder(iProgressMonitor).getFolder("required-classes");
        if (iFolder.exists()) {
            IResource[] iResourceArray = iFolder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                this.addResourceToJAR(file, iResource, PackageBuilder.getRequiredClassesZipPath(iMidletSuiteProject, iResource));
                ++n2;
            }
        }
    }

    private void addRequiredProjectsLibs(IMidletSuiteProject iMidletSuiteProject, de.schlichtherle.io.File file, IProgressMonitor iProgressMonitor) throws CoreException {
        IFolder iFolder = iMidletSuiteProject.getVerifiedOutputFolder(iProgressMonitor).getFolder("required-libs");
        if (iFolder.exists()) {
            IResource[] iResourceArray = iFolder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                if (iResource.getName().endsWith(".jar")) {
                    file.archiveCopyAllFrom((File)new de.schlichtherle.io.File(iResource.getLocation().toOSString()));
                }
                ++n2;
            }
        }
    }

    private void createDeployedPackage(IMidletSuiteProject iMidletSuiteProject, de.schlichtherle.io.File file, Map<?, ?> map, IProgressMonitor iProgressMonitor) throws CoreException {
        IFolder iFolder;
        MTJRuntimeList mTJRuntimeList = iMidletSuiteProject.getRuntimeList();
        MTJRuntime mTJRuntime = mTJRuntimeList.getActiveMTJRuntime();
        if (mTJRuntime == null) {
            return;
        }
        IFolder iFolder2 = this.getProject().getFolder(MTJCore.getDeploymentDirectoryName());
        if (!iFolder2.exists()) {
            iFolder2.create(true, true, iProgressMonitor);
        }
        if (!(iFolder = iFolder2.getFolder(mTJRuntime.getName())).exists()) {
            iFolder.create(true, true, iProgressMonitor);
        }
        this.removeJADsAndJARs(iFolder, iProgressMonitor);
        try {
            try {
                de.schlichtherle.io.File file2 = new de.schlichtherle.io.File(iFolder.getLocation().toFile(), file.getName());
                file.archiveCopyAllTo((File)file2);
                de.schlichtherle.io.File.umount();
                DeployedJADWriter deployedJADWriter = new DeployedJADWriter(iMidletSuiteProject, iFolder, new File(file2.getAbsolutePath()));
                deployedJADWriter.writeDeployedJAD(false, iProgressMonitor);
            }
            catch (IOException iOException) {
                MTJStatusHandler.throwCoreException(4, 999, iOException);
                iFolder2.refreshLocal(2, iProgressMonitor);
            }
        }
        finally {
            iFolder2.refreshLocal(2, iProgressMonitor);
        }
    }

    private boolean isBuildArgumentTrue(Map<?, ?> map, String string) {
        String string2 = (String)map.get(string);
        return string2 != null && Boolean.valueOf(string2) != false;
    }

    private void updateJADVersion(IFile iFile, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(iFile.getLocation().toFile());
        ColonDelimitedProperties colonDelimitedProperties = (ColonDelimitedProperties)applicationDescriptor.getManifestProperties();
        String string = colonDelimitedProperties.getProperty("MIDlet-Version", "0.0.0");
        Version version = new Version(string);
        int n = version.getMajor();
        int n2 = version.getMinor();
        int n3 = version.getMicro();
        if (n3 >= 99) {
            n3 = 0;
            ++n2;
        } else {
            ++n3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n).append(".").append(n2).append(".").append(n3);
        colonDelimitedProperties.setProperty("MIDlet-Version", stringBuffer.toString());
        try {
            try {
                applicationDescriptor.store();
            }
            catch (IOException iOException) {
                MTJStatusHandler.throwCoreException(4, 999, iOException);
                iFile.refreshLocal(0, iProgressMonitor);
            }
        }
        finally {
            iFile.refreshLocal(0, iProgressMonitor);
        }
    }

    private void addPreverifiedLibraries(IMidletSuiteProject iMidletSuiteProject, de.schlichtherle.io.File file, IProgressMonitor iProgressMonitor) throws CoreException {
        IResource[] iResourceArray;
        IFolder iFolder = iMidletSuiteProject.getVerifiedLibrariesOutputFolder(iProgressMonitor);
        if (!iFolder.exists()) {
            return;
        }
        IResource[] iResourceArray2 = iResourceArray = iFolder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray2[n2];
            if (iResource.getName().endsWith(".jar")) {
                file.archiveCopyAllFrom((File)new de.schlichtherle.io.File(iResource.getLocation().toOSString()));
            }
            ++n2;
        }
    }

    private void createManifestFile(IMidletSuiteProject iMidletSuiteProject, de.schlichtherle.io.File file, IProgressMonitor iProgressMonitor) throws CoreException {
        block22: {
            Object object;
            IMidletDefinition iMidletDefinition2;
            Object object2;
            String[] stringArray;
            IProject iProject = iMidletSuiteProject.getProject();
            if (!iMidletSuiteProject.getApplicationDescriptorFile().exists()) {
                return;
            }
            IApplicationDescriptor iApplicationDescriptor = iMidletSuiteProject.getApplicationDescriptor();
            Properties properties = iApplicationDescriptor.getManifestProperties();
            String[] object32 = stringArray = PreferenceAccessor.instance.getExcludedManifestProperties(iProject);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = object32[n2];
                if (properties.containsKey(object2)) {
                    properties.remove(object2);
                }
                ++n2;
            }
            object2 = new Manifest();
            Attributes attributes = ((Manifest)object2).getMainAttributes();
            attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), BuilderMessages.PreverificationBuilder_13);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                try {
                    attributes.putValue((String)entry.getKey(), (String)entry.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    MTJStatusHandler.throwCoreException(4, -999, illegalArgumentException);
                }
            }
            for (IMidletDefinition iMidletDefinition2 : iApplicationDescriptor.getMidletDefinitions()) {
                object = "MIDlet-" + iMidletDefinition2.getNumber();
                String string = iMidletDefinition2.toString();
                attributes.putValue((String)object, string);
            }
            iMidletDefinition2 = null;
            object = new de.schlichtherle.io.File((File)file, "META-INF");
            if (!object.exists()) {
                object.mkdir();
            }
            try {
                try {
                    iMidletDefinition2 = new FileOutputStream((File)new de.schlichtherle.io.File((File)object, "MANIFEST.MF"));
                    ((Manifest)object2).write((OutputStream)((Object)iMidletDefinition2));
                }
                catch (IOException iOException) {
                    MTJStatusHandler.throwCoreException(4, -999, iOException);
                    if (iMidletDefinition2 != null) {
                        try {
                            iMidletDefinition2.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (iMidletDefinition2 != null) {
                    try {
                        iMidletDefinition2.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (iMidletDefinition2 != null) {
                try {
                    iMidletDefinition2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected MTJBuildState getEnterState() {
        return MTJBuildState.PRE_PACKAGING;
    }

    @Override
    protected MTJBuildState getExitState() {
        return MTJBuildState.POST_PACKAGING;
    }

    @Override
    protected String getBuilderId() {
        return "org.eclipse.mtj.core.packageBuilder";
    }

    private void doObfuscation(IMidletSuiteProject iMidletSuiteProject, File file, IProgressMonitor iProgressMonitor) throws CoreException {
        final StringBuffer stringBuffer = new StringBuffer();
        BuildStateMachine buildStateMachine = BuildStateMachine.getInstance(this.getMTJProject());
        buildStateMachine.changeState(MTJBuildState.PRE_OBFUSCATION, iProgressMonitor);
        Path path = new Path(file.getAbsolutePath());
        String string = path.lastSegment();
        string = string.substring(0, string.length() - 4);
        IFolder iFolder = this.getRuntimeFolder(iMidletSuiteProject.getProject());
        IFile iFile = iFolder.getFile(String.valueOf(string) + "_obf.jar");
        IFile iFile2 = iFolder.getFile(path.lastSegment());
        ObfuscatorTool obfuscatorTool = new ObfuscatorTool(iMidletSuiteProject, file, iFile.getLocation().toFile());
        ILaunch iLaunch = obfuscatorTool.launch(iProgressMonitor);
        StringBuffer stringBuffer2 = new StringBuffer();
        IProcess[] iProcessArray = iLaunch.getProcesses();
        if (iProcessArray != null && iProcessArray.length > 0) {
            IProcess iProcess = iProcessArray[0];
            IStreamsProxy iStreamsProxy = iProcess.getStreamsProxy();
            iStreamsProxy.getErrorStreamMonitor().addListener(new IStreamListener(){

                public void streamAppended(String string, IStreamMonitor iStreamMonitor) {
                    stringBuffer.append(string);
                }
            });
            while (!iProgressMonitor.isCanceled() && !iProcess.isTerminated()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (stringBuffer2.length() > 0) {
                MTJLogger.log(1, stringBuffer2.toString());
            }
            boolean bl = true;
            if (stringBuffer.length() > 0) {
                String string2 = stringBuffer.toString();
                Status status = new Status(4, "org.eclipse.mtj.core", 101, string2, null);
                Boolean bl2 = (Boolean)MTJStatusHandler.statusPrompt((IStatus)status, (Object)this);
                boolean bl3 = bl = bl2 != null ? bl2 : false;
            }
            if (bl) {
                try {
                    this.doPostObfuscationPreverification(iMidletSuiteProject, iFile, iFile2, iProgressMonitor);
                }
                catch (PreverifierNotFoundException preverifierNotFoundException) {
                    MTJStatusHandler.throwCoreException(4, 999, preverifierNotFoundException);
                }
            }
        }
        buildStateMachine.changeState(MTJBuildState.POST_OBFUSCATION, iProgressMonitor);
    }

    private IFolder getRuntimeFolder(IProject iProject) {
        return iProject.getFolder(".mtj.tmp/emulation");
    }

    private void doPostObfuscationPreverification(IMidletSuiteProject iMidletSuiteProject, IFile iFile, IFile iFile2, IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        try {
            IFolder iFolder = (IFolder)iFile.getParent();
            IFolder iFolder2 = iFolder.getFolder("temp");
            if (!iFolder2.exists()) {
                iFolder2.create(true, true, iProgressMonitor);
            }
            de.schlichtherle.io.File file = new de.schlichtherle.io.File(iFile.getLocation().toFile());
            IPreverificationError[] iPreverificationErrorArray = iMidletSuiteProject.preverifyJarFile((File)file, iFolder2, iProgressMonitor);
            iFolder2.refreshLocal(1, iProgressMonitor);
            if (iPreverificationErrorArray.length > 0) {
                this.handlePreverificationErrors(iPreverificationErrorArray);
            }
            IFile iFile3 = iFolder2.getFile(iFile.getName());
            FileInputStream fileInputStream = new FileInputStream(iFile3.getLocation().toFile());
            iFile2.create((InputStream)fileInputStream, true, iProgressMonitor);
            iFile3.delete(true, iProgressMonitor);
            iFolder2.delete(true, iProgressMonitor);
        }
        catch (IOException iOException) {
            MTJStatusHandler.throwCoreException(4, 999, iOException);
        }
    }

    private void handlePreverificationErrors(IPreverificationError[] iPreverificationErrorArray) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer(BuilderMessages.PreverificationBuilder_45);
        int n = 0;
        while (n < iPreverificationErrorArray.length) {
            if (n != 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(PreverificationUtils.getErrorText(iPreverificationErrorArray[n]));
            ++n;
        }
        MTJStatusHandler.throwCoreException(4, -999, stringBuffer.toString());
    }

    private void addResourceToJAR(de.schlichtherle.io.File file, IResource iResource, IPath iPath) {
        IPath iPath2 = iResource.getLocation();
        de.schlichtherle.io.File file2 = new de.schlichtherle.io.File((File)file, iPath.toString());
        file2.copyAllFrom(iPath2.toFile());
    }

    private void addFileToJAR(de.schlichtherle.io.File file, IFile iFile, IPath iPath) {
        IPath iPath2 = iFile.getLocation();
        de.schlichtherle.io.File file2 = new de.schlichtherle.io.File((File)file, iPath.toString());
        file2.copyFrom(iPath2.toFile());
    }

    public static de.schlichtherle.io.File getRuntimeJar(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        IFolder iFolder = iProject.getFolder(".mtj.tmp");
        IFolder iFolder2 = iFolder.getFolder("emulation");
        PackageBuilder.createFolders(iFolder2, iProgressMonitor);
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
        de.schlichtherle.io.File file = new de.schlichtherle.io.File(iFolder2.getLocation().toFile(), iMidletSuiteProject.getJarFilename());
        file.mkdir();
        iFolder2.refreshLocal(1, iProgressMonitor);
        return file;
    }

    public static void createFolders(IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        while (!iFolder.exists()) {
            if (iFolder.getParent().getType() == 2) {
                PackageBuilder.createFolders((IFolder)iFolder.getParent(), iProgressMonitor);
            }
            iFolder.create(true, true, iProgressMonitor);
            iFolder.setDerived(true);
        }
    }

    static IFolder getOutputFolder(IJavaProject iJavaProject) throws JavaModelException {
        IWorkspaceRoot iWorkspaceRoot = MTJCore.getWorkspace().getRoot();
        IPath iPath = iJavaProject.getOutputLocation();
        return iWorkspaceRoot.getFolder(iPath);
    }

    static IPath getResourceZipPath(IMidletSuiteProject iMidletSuiteProject, IFile iFile) throws CoreException {
        IFolder iFolder = PackageBuilder.getOutputFolder(iMidletSuiteProject.getJavaProject());
        return iFile.getFullPath().removeFirstSegments(iFolder.getFullPath().segmentCount());
    }

    static IPath getClassZipPath(IMidletSuiteProject iMidletSuiteProject, IFile iFile) throws CoreException {
        IFolder iFolder = iMidletSuiteProject.getVerifiedClassesOutputFolder((IProgressMonitor)new NullProgressMonitor());
        return iFile.getFullPath().removeFirstSegments(iFolder.getFullPath().segmentCount());
    }

    static IPath getRequiredClassesZipPath(IMidletSuiteProject iMidletSuiteProject, IResource iResource) throws CoreException {
        IFolder iFolder = iMidletSuiteProject.getVerifiedOutputFolder((IProgressMonitor)new NullProgressMonitor()).getFolder("required-classes");
        return iResource.getFullPath().removeFirstSegments(iFolder.getFullPath().segmentCount());
    }
}

