/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.externallibrary.manager;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.internal.core.externallibrary.model.IExternalLibrary;
import org.eclipse.mtj.internal.core.externallibrary.model.MidletExternalLibrary;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;

public class ExternalLibraryManager {
    private static final String EXT_MIDLETLIBRARY = "externallibrary";
    private static ExternalLibraryManager LibraryManagerInstance;
    private Map<String, MidletExternalLibrary> midletLibraries;

    public static synchronized ExternalLibraryManager getInstance() {
        if (LibraryManagerInstance == null) {
            LibraryManagerInstance = new ExternalLibraryManager();
        }
        return LibraryManagerInstance;
    }

    private ExternalLibraryManager() {
        this.initialize();
    }

    public void addLibraryToMidletProject(IProject iProject, String string) throws CoreException {
        Object object;
        Object object2;
        if (!iProject.hasNature("org.eclipse.mtj.core.nature")) {
            object2 = NLS.bind((String)"Project {0} must have a {1} nature.", (Object[])new String[]{iProject.getName(), "org.eclipse.mtj.core.nature"});
            MTJStatusHandler.throwCoreException(4, -999, (String)object2);
        }
        if ((object2 = this.getMidletLibrary(string)) == null) {
            object = NLS.bind((String)"ExternalLibraryManager does not contain a {0} library.", (Object)string);
            MTJStatusHandler.throwCoreException(4, -999, (String)object);
        }
        object = JavaCore.create((IProject)iProject);
        LinkedList<IClasspathEntry> linkedList = new LinkedList<IClasspathEntry>();
        linkedList.addAll(Arrays.asList(object.getRawClasspath()));
        try {
            Path path = new Path("org.eclipse.mtj.core.EXTERNAL_LIBRARY" + File.separator + object2.getName());
            linkedList.add(JavaCore.newContainerEntry((IPath)path, (boolean)true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object.setRawClasspath(null, (IProgressMonitor)new NullProgressMonitor());
        object.setRawClasspath(linkedList.toArray(new IClasspathEntry[linkedList.size()]), (IProgressMonitor)new NullProgressMonitor());
    }

    public synchronized IExternalLibrary getMidletLibrary(String string) {
        return this.midletLibraries.get(string);
    }

    public synchronized String[] getMidletLibraryNames() {
        Set<String> set = this.midletLibraries.keySet();
        return set.toArray(new String[set.size()]);
    }

    public void removeLibraryFromMidletProject(IProject iProject, String string) throws CoreException {
        Object object;
        Object object2;
        if (!iProject.hasNature("org.eclipse.mtj.core.nature")) {
            object2 = NLS.bind((String)"Project {0} must have a {1} nature.", (Object[])new String[]{iProject.getName(), "org.eclipse.mtj.core.nature"});
            MTJStatusHandler.throwCoreException(4, -999, (String)object2);
        }
        if ((object2 = this.getMidletLibrary(string)) == null) {
            object = NLS.bind((String)"ExternalLibraryManager does not contain a {0} library.", (Object)string);
            MTJStatusHandler.throwCoreException(4, -999, (String)object);
        }
        object = JavaCore.create((IProject)iProject);
        LinkedList<IClasspathEntry> linkedList = new LinkedList<IClasspathEntry>();
        linkedList.addAll(Arrays.asList(object.getRawClasspath()));
        Path path = new Path("org.eclipse.mtj.core.EXTERNAL_LIBRARY" + File.separator + object2.getName());
        for (IClasspathEntry iClasspathEntry : linkedList) {
            if (!iClasspathEntry.getPath().toString().equals(path.toString())) continue;
            linkedList.remove(iClasspathEntry);
            break;
        }
        object.setRawClasspath(null, (IProgressMonitor)new NullProgressMonitor());
        object.setRawClasspath(linkedList.toArray(new IClasspathEntry[linkedList.size()]), (IProgressMonitor)new NullProgressMonitor());
    }

    private void initialize() {
        IConfigurationElement[] iConfigurationElementArray;
        this.midletLibraries = new HashMap<String, MidletExternalLibrary>();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.mtj.core", EXT_MIDLETLIBRARY);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            MidletExternalLibrary midletExternalLibrary = null;
            try {
                midletExternalLibrary = new MidletExternalLibrary(iConfigurationElement);
            }
            catch (Throwable throwable) {
                MTJLogger.log(4, "Failed to load MidletExternalLibrary", throwable);
            }
            if (midletExternalLibrary != null) {
                this.midletLibraries.put(midletExternalLibrary.getName(), midletExternalLibrary);
            }
            ++n2;
        }
    }
}

