/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.export;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.export.AntennaExportException;
import org.eclipse.mtj.internal.core.build.export.states.AbstractCreateAntTaskState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntBuildTaskState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntCleanTaskState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntCollectResourcesState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntCollectSourcesState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntInitTaskState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntPackageTaskState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntPreprocessTaskState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntTaskStateTransition;
import org.eclipse.mtj.internal.core.statemachine.AbstractStateMachineEvent;
import org.eclipse.mtj.internal.core.statemachine.StateMachine;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AntennaBuildExport {
    public static final String PROGUARD_HOME = "wtk.proguard.home";
    public static final String ANTENNA_LIB = "antenna.lib";
    public static final String MTJ_BUILD_PROPERTIES = "mtj-build.properties";
    public static final String WTK_HOME = "wtk.home";
    public static final String DO_OBFUSCATE = "do-obfuscate";
    public static final String DO_AUTOVERSION = "do-autoversion";
    public static final String BUILD_XML = "mtj-build.xml";
    public static final String BUILD_FOLDER = "mtj-build";
    private IMidletSuiteProject suiteProject;
    private StateMachine stateMachine;

    public AntennaBuildExport(IMidletSuiteProject iMidletSuiteProject) {
        if (iMidletSuiteProject == null) {
            throw new IllegalArgumentException(Messages.NewAntennaBuildExport_InvalidSuiteProject);
        }
        this.suiteProject = iMidletSuiteProject;
    }

    public void doExport(IProgressMonitor iProgressMonitor) throws AntennaExportException {
        this.stateMachine = new StateMachine();
        Document document = this.createNewDocument();
        if (document == null) {
            throw new AntennaExportException(Messages.NewAntennaBuildExport_UnableToCreateXMLDoc);
        }
        this.createAntExportStates(this.stateMachine, document);
        try {
            IProject iProject = this.suiteProject.getProject();
            IFolder iFolder = iProject.getFolder(BUILD_FOLDER);
            if (!iFolder.exists()) {
                iFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            this.stateMachine.start();
            IFile iFile = iFolder.getFile(BUILD_XML);
            XMLUtils.writeDocument(iFile.getLocation().toFile(), document);
            this.writeBuildProperties(iFolder.getFile(MTJ_BUILD_PROPERTIES));
            iFolder.refreshLocal(1, iProgressMonitor);
        }
        catch (Exception exception) {
            MTJLogger.log(4, exception);
        }
    }

    private void writeBuildProperties(IFile iFile) throws IOException {
        Preferences preferences = MTJCore.getMTJCore().getPluginPreferences();
        Properties properties = new Properties();
        properties.put(DO_AUTOVERSION, "false");
        properties.put(DO_OBFUSCATE, "false");
        properties.put(ANTENNA_LIB, preferences.getString("antenna_jar"));
        properties.put(WTK_HOME, preferences.getString("wtk_root"));
        String string = preferences.getString("proguard_dir");
        if (string != null && string.length() > 0) {
            properties.put(PROGUARD_HOME, string);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(iFile.getLocation().toFile());
        properties.store(fileOutputStream, Messages.NewAntennaBuildExport_comment);
    }

    private void createAntExportStates(StateMachine stateMachine, Document document) {
        AbstractCreateAntTaskState abstractCreateAntTaskState = null;
        AbstractCreateAntTaskState abstractCreateAntTaskState2 = null;
        Element element = this.createProjectElement(document, "build-all");
        this.setupDefaultTarget(document, element);
        this.setupAntenna(document, element);
        abstractCreateAntTaskState = new CreateAntCleanTaskState(this.stateMachine, this.suiteProject, document);
        this.stateMachine.addState(abstractCreateAntTaskState);
        this.stateMachine.setInitialState(abstractCreateAntTaskState);
        abstractCreateAntTaskState2 = new CreateAntInitTaskState(this.stateMachine, this.suiteProject, document);
        abstractCreateAntTaskState2.setDependencies("clean");
        this.stateMachine.addState(abstractCreateAntTaskState2);
        abstractCreateAntTaskState.addTransition(new CreateAntTaskStateTransition(abstractCreateAntTaskState, abstractCreateAntTaskState2));
        abstractCreateAntTaskState = new CreateAntCollectResourcesState(this.stateMachine, this.suiteProject, document);
        abstractCreateAntTaskState.setDependencies("init");
        abstractCreateAntTaskState2.addTransition(new CreateAntTaskStateTransition(abstractCreateAntTaskState2, abstractCreateAntTaskState));
        boolean bl = false;
        try {
            bl = this.suiteProject.getProject().hasNature("org.eclipse.mtj.core.preprocessingNature");
        }
        catch (CoreException coreException) {}
        abstractCreateAntTaskState2 = bl ? new CreateAntPreprocessTaskState(this.stateMachine, this.suiteProject, document) : new CreateAntCollectSourcesState(this.stateMachine, this.suiteProject, document);
        abstractCreateAntTaskState2.setDependencies("collect-resources");
        abstractCreateAntTaskState.addTransition(new CreateAntTaskStateTransition(abstractCreateAntTaskState, abstractCreateAntTaskState2));
        abstractCreateAntTaskState = new CreateAntBuildTaskState(this.stateMachine, this.suiteProject, document);
        if (bl) {
            abstractCreateAntTaskState.setDependencies("preprocess");
        } else {
            abstractCreateAntTaskState.setDependencies("collect-sources");
        }
        abstractCreateAntTaskState2.addTransition(new CreateAntTaskStateTransition(abstractCreateAntTaskState2, abstractCreateAntTaskState));
        abstractCreateAntTaskState2 = new CreateAntPackageTaskState(this.stateMachine, this.suiteProject, document);
        abstractCreateAntTaskState2.setDependencies("build");
        abstractCreateAntTaskState.addTransition(new CreateAntTaskStateTransition(abstractCreateAntTaskState, abstractCreateAntTaskState2));
    }

    private void setupDefaultTarget(Document document, Element element) {
        Element element2 = XMLUtils.createTargetElement(document, element, "build-all", "clean-all");
        MTJRuntimeList mTJRuntimeList = this.suiteProject.getRuntimeList();
        for (MTJRuntime mTJRuntime : mTJRuntimeList) {
            String string = mTJRuntime.getName().replace(" ", "_");
            Element element3 = document.createElement("antcall");
            element3.setAttribute("target", NLS.bind((String)"package-{0}", (Object)string));
            element2.appendChild(element3);
        }
    }

    private void setupAntenna(Document document, Element element) {
        Element element2 = document.createElement("taskdef");
        element2.setAttribute("resource", "antenna.properties");
        element2.setAttribute("classpath", NLS.bind((String)"${0}{1}{2}", (Object[])new String[]{"{", ANTENNA_LIB, "}"}));
        element.appendChild(element2);
        Element element3 = document.createElement("property");
        element3.setAttribute("file", NLS.bind((String)"{0}/{1}", (Object[])new String[]{BUILD_FOLDER, MTJ_BUILD_PROPERTIES}));
        element.appendChild(element3);
    }

    private Element createProjectElement(Document document, String string) {
        Element element = document.createElement("project");
        document.appendChild(element);
        element.setAttribute("name", this.suiteProject.getProject().getName());
        element.setAttribute("default", string);
        element.setAttribute("basedir", "..");
        return element;
    }

    private Document createNewDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return document;
    }

    public static class CreateAntTaskDoneEvent
    extends AbstractStateMachineEvent {
    }
}

