/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text.l10n;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.mtj.internal.core.MTJPluginSchemas;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.core.text.l10n.L10nMarkerError;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L10nLocale
extends L10nObject {
    private static final long serialVersionUID = 1L;
    private Vector<L10nEntry> entryList = new Vector();
    private Schema schema;

    public L10nLocale(L10nModel l10nModel) {
        super(l10nModel, "locale");
    }

    @Override
    public boolean canBeParent() {
        return true;
    }

    public String getLanguageCode() {
        return this.getXMLAttributeValue("language");
    }

    public String getCountryCode() {
        return this.getXMLAttributeValue("country");
    }

    public void setLanguageCode(String string) {
        this.setXMLAttribute("language", string);
    }

    public void setCountryCode(String string) {
        this.setXMLAttribute("country", string);
    }

    public String getLocaleName() {
        this.migrateFromPrevVersion();
        return NLS.bind((String)"{0}-{1}", (Object[])new String[]{this.getLanguageCode(), this.getCountryCode()});
    }

    @Override
    public String getName() {
        return this.getLocaleName();
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void validate() {
        if (!this.validateLocaleSchema()) {
            IDocumentElementNode[] iDocumentElementNodeArray = this.getChildNodes();
            int n = 0;
            while (n < iDocumentElementNodeArray.length) {
                block13: {
                    L10nEntry l10nEntry;
                    try {
                        l10nEntry = (L10nEntry)iDocumentElementNodeArray[n];
                    }
                    catch (Exception exception) {
                        break block13;
                    }
                    l10nEntry.validate();
                }
                ++n;
            }
        } else {
            String string;
            String[] stringArray = Locale.getISOCountries();
            String[] stringArray2 = Locale.getISOLanguages();
            String string2 = this.getLanguageCode();
            String string3 = this.getCountryCode();
            boolean bl = false;
            boolean bl2 = false;
            String[] stringArray3 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                string = stringArray3[n2];
                if (string.equalsIgnoreCase(string3)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            stringArray3 = stringArray2;
            n = stringArray2.length;
            n2 = 0;
            while (n2 < n) {
                string = stringArray3[n2];
                if (string.equalsIgnoreCase(string2)) {
                    bl2 = true;
                    break;
                }
                ++n2;
            }
            string = "";
            if (!bl || !bl2) {
                if (!bl2) {
                    string = Messages.L10nLocale_0;
                }
                if (!bl) {
                    string = String.valueOf(string) + Messages.L10nLocale_2;
                }
                this.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", string));
            } else {
                this.setStatus((IStatus)new Status(0, "org.eclipse.mtj.core", "Valid Locale"));
            }
            this.syncronizeEntryStates();
        }
    }

    private void syncronizeEntryStates() {
        IDocumentElementNode[] iDocumentElementNodeArray = this.getChildNodes();
        LinkedList<L10nEntry> linkedList = new LinkedList<L10nEntry>();
        IDocumentElementNode[] iDocumentElementNodeArray2 = iDocumentElementNodeArray;
        int n = iDocumentElementNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                L10nEntry l10nEntry;
                IDocumentElementNode iDocumentElementNode = iDocumentElementNodeArray2[n2];
                try {
                    l10nEntry = (L10nEntry)iDocumentElementNode;
                }
                catch (Exception exception) {
                    break block9;
                }
                if (!linkedList.contains(l10nEntry)) {
                    List<L10nEntry> list = this.findDuplicatedEntries(l10nEntry);
                    if (list.size() > 0) {
                        int n3 = 0;
                        while (n3 < list.size()) {
                            block10: {
                                L10nEntry l10nEntry2;
                                try {
                                    l10nEntry2 = list.get(n3);
                                }
                                catch (Exception exception) {
                                    break block10;
                                }
                                l10nEntry2.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", Messages.L10nLocale_4));
                                linkedList.add(l10nEntry2);
                            }
                            ++n3;
                        }
                        l10nEntry.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", Messages.L10nLocale_5));
                    } else {
                        l10nEntry.setStatus((IStatus)new Status(0, "org.eclipse.mtj.core", null));
                    }
                }
            }
            ++n2;
        }
    }

    private List<L10nEntry> findDuplicatedEntries(L10nLocale l10nLocale, String string) {
        IDocumentElementNode[] iDocumentElementNodeArray;
        LinkedList<L10nEntry> linkedList = new LinkedList<L10nEntry>();
        IDocumentElementNode[] iDocumentElementNodeArray2 = iDocumentElementNodeArray = l10nLocale.getChildNodes();
        int n = iDocumentElementNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            L10nEntry l10nEntry;
            IDocumentElementNode iDocumentElementNode = iDocumentElementNodeArray2[n2];
            if (iDocumentElementNode instanceof L10nEntry && (l10nEntry = (L10nEntry)iDocumentElementNode) != null && l10nEntry.getKey() != null && string != null && l10nEntry.getKey().toUpperCase().equals(string.toUpperCase())) {
                linkedList.add(l10nEntry);
            }
            ++n2;
        }
        return linkedList;
    }

    public List<L10nEntry> findDuplicatedEntries(L10nEntry l10nEntry) {
        List<L10nEntry> list = this.findDuplicatedEntries((L10nLocale)l10nEntry.getParent(), l10nEntry.getKey());
        list.remove(l10nEntry);
        return list;
    }

    public L10nEntry getEntry(String string) {
        IDocumentElementNode[] iDocumentElementNodeArray;
        L10nEntry l10nEntry = null;
        IDocumentElementNode[] iDocumentElementNodeArray2 = iDocumentElementNodeArray = this.getChildNodes();
        int n = iDocumentElementNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode iDocumentElementNode = iDocumentElementNodeArray2[n2];
            L10nEntry l10nEntry2 = (L10nEntry)iDocumentElementNode;
            if (l10nEntry2.getKey().toUpperCase().equals(string.toUpperCase())) {
                l10nEntry = l10nEntry2;
                break;
            }
            ++n2;
        }
        return l10nEntry;
    }

    private void migrateFromPrevVersion() {
        boolean bl;
        block7: {
            bl = false;
            String string = this.getXMLAttributeValue("name");
            if (string != null) {
                if (this.getLanguageCode() == null && this.getCountryCode() == null) {
                    try {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
                        if (stringTokenizer.countTokens() == 2) {
                            this.setLanguageCode(stringTokenizer.nextToken());
                            this.setCountryCode(stringTokenizer.nextToken());
                            break block7;
                        }
                        bl = true;
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                } else {
                    this.setXMLAttribute("name", null);
                }
            }
        }
        if (bl) {
            this.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", Messages.L10nLocale_7));
        }
    }

    public Vector<L10nMarkerError> getMarkerErrors() {
        IDocumentElementNode[] iDocumentElementNodeArray = this.getChildNodes();
        Vector<L10nMarkerError> vector = new Vector<L10nMarkerError>();
        int n = -1;
        int n2 = 0;
        while (n2 < iDocumentElementNodeArray.length) {
            block5: {
                try {
                    L10nEntry l10nEntry = (L10nEntry)iDocumentElementNodeArray[n2];
                    if (l10nEntry.getStatus().isOK()) break block5;
                    try {
                        int n3 = this.getModel().getDocument().getLineOfOffset(l10nEntry.getOffset());
                        int n4 = l10nEntry.getLength();
                        n = n3 + this.getModel().getDocument().getNumberOfLines(l10nEntry.getOffset(), n4);
                    }
                    catch (BadLocationException badLocationException) {
                        break block5;
                    }
                    L10nMarkerError l10nMarkerError = new L10nMarkerError(l10nEntry.getStatus().getMessage(), n);
                    vector.add(l10nMarkerError);
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return vector;
    }

    public L10nEntry createEntry() {
        L10nEntry l10nEntry = null;
        l10nEntry = new L10nEntry(this.getModel());
        this.entryList.add(l10nEntry);
        return l10nEntry;
    }

    @Override
    public IDocumentElementNode removeChildNode(IDocumentElementNode iDocumentElementNode, boolean bl) {
        this.entryList.remove(iDocumentElementNode);
        return super.removeChildNode(iDocumentElementNode, bl);
    }

    private boolean validateLocaleSchema() {
        boolean bl = true;
        String string = this.toString();
        BufferedInputStream bufferedInputStream = null;
        bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(string.getBytes()));
        try {
            String string2 = "http://www.w3.org/2001/XMLSchema";
            SchemaFactory schemaFactory = SchemaFactory.newInstance(string2);
            if (this.schema == null) {
                this.schema = schemaFactory.newSchema(MTJPluginSchemas.getInstance().create("locale.xsd"));
            }
            Validator validator = this.schema.newValidator();
            validator.validate(new StreamSource(bufferedInputStream));
            Status status = new Status(0, "org.eclipse.mtj.core", null);
            this.setStatus((IStatus)status);
        }
        catch (Exception exception) {
            Status status = new Status(4, "org.eclipse.mtj.core", exception.getMessage(), (Throwable)exception);
            this.setStatus((IStatus)status);
            bl = false;
        }
        return bl;
    }
}

