/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.packaging.midp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.internal.core.PreferenceAccessor;
import org.eclipse.mtj.internal.core.util.TemporaryFileManager;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.core.util.tools.AbstractJavaTool;
import org.eclipse.osgi.util.NLS;

public class ObfuscatorTool
extends AbstractJavaTool {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String MAIN_CLASS = "proguard.ProGuard";
    private static final String MAPPING_FILE_NAME = "pro_map.txt";
    private static final String NAME = "Obfuscator";
    private static final String PROGUARD_CFG_NAME = "proguard.cfg";
    private static final String SEEDS_FILE_NAME = "pro_seeds.txt";
    private static final String TEMPLATE_NAME = "config.pro";
    private File deploymentDirectory;
    private IMTJProject midletSuite;
    private File sourceJarFile;
    private File targetJarFile;

    public ObfuscatorTool(IMTJProject iMTJProject, File file, File file2) {
        this.midletSuite = iMTJProject;
        this.sourceJarFile = file;
        this.targetJarFile = file2;
    }

    private File copyConfigFileIfNecessary(File file) throws IOException {
        File file2 = file;
        if (file.toString().indexOf(32) != -1) {
            file2 = TemporaryFileManager.instance.createTempFile("proguard_", ".cfg");
            Utils.copyFile(file, file2, null);
        }
        return file2;
    }

    private File getDeploymentDirectory() throws CoreException {
        if (this.deploymentDirectory == null) {
            String string = MTJCore.getDeploymentDirectoryName();
            this.deploymentDirectory = this.getMidletSuiteFile(string);
        }
        return this.deploymentDirectory;
    }

    private File getDeploymentDirectoryFile(String string) throws CoreException {
        return new File(this.getDeploymentDirectory(), string);
    }

    private String getLibraryJarsClasspath() throws CoreException {
        IDevice iDevice = this.midletSuite.getRuntimeList().getActiveMTJRuntime().getDevice();
        IDeviceClasspath iDeviceClasspath = iDevice.getClasspath();
        return iDeviceClasspath.toString();
    }

    private File getMidletSuiteFile(String string) throws CoreException {
        IProject iProject = this.midletSuite.getJavaProject().getProject();
        File file = iProject.getLocation().toFile();
        return new File(file, string);
    }

    private File getProguardConfigFile() throws CoreException, IOException {
        File file = this.getDeploymentDirectoryFile(PROGUARD_CFG_NAME);
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            file2.mkdir();
        }
        this.writeConfigFileContents(file);
        file = this.copyConfigFileIfNecessary(file);
        return file;
    }

    private String getProguardConfigFileTemplate() throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        InputStream inputStream = this.getClass().getResourceAsStream(TEMPLATE_NAME);
        if (inputStream != null) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    printWriter.println(string);
                    printWriter.flush();
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        return stringWriter.toString();
    }

    private String getProguardKeepParameters() {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        PreferenceAccessor preferenceAccessor = PreferenceAccessor.instance;
        String[] stringArray2 = stringArray = preferenceAccessor.getProguardKeepExpressions(this.midletSuite.getProject());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            stringBuffer.append("-keep ").append(string).append("\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    private Object getProguardOptions() {
        IProject iProject = this.midletSuite.getProject();
        PreferenceAccessor preferenceAccessor = PreferenceAccessor.instance;
        String string = preferenceAccessor.getSpecifiedProguardOptions(iProject);
        boolean bl = preferenceAccessor.isUseSpecifiedProguardOptions(iProject);
        return bl ? string : preferenceAccessor.getDefaultProguardOptions();
    }

    private String getQuotedOptions(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Pattern pattern = Pattern.compile("([-]([^@])+)|([@]([^-])+)");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group().trim();
            if (string2.startsWith("@")) {
                string2 = NLS.bind((String)"@\"{0}\"", (Object)string2.substring(1));
            }
            stringBuffer.append(string2).append(" ");
        }
        return stringBuffer.toString().trim();
    }

    private String getQuotedString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(32) != -1) {
                stringBuffer.append("\"").append(string2).append("\"");
            } else {
                stringBuffer.append(string2);
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(File.pathSeparatorChar);
        }
        return stringBuffer.toString();
    }

    private String getTemplateWithSubstitutions(String string) throws CoreException {
        File file = this.getDeploymentDirectoryFile(MAPPING_FILE_NAME);
        File file2 = this.getDeploymentDirectoryFile(SEEDS_FILE_NAME);
        Object[] objectArray = new Object[]{this.getQuotedString(this.getLibraryJarsClasspath()), this.getQuotedString(this.sourceJarFile.toString()), this.getQuotedString(this.targetJarFile.toString()), this.getQuotedString(file2.toString()), this.getQuotedString(file.toString()), this.getQuotedOptions(this.getProguardOptions().toString()), this.getProguardKeepParameters()};
        return NLS.bind((String)string, (Object[])objectArray);
    }

    private void writeConfigFileContents(File file) throws IOException, CoreException {
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        String string = this.getProguardConfigFileTemplate();
        String string2 = this.getTemplateWithSubstitutions(string);
        printWriter.println(string2);
        printWriter.close();
    }

    protected String[] getArguments() {
        String[] stringArray = null;
        try {
            File file = this.getProguardConfigFile();
            String string = NLS.bind((String)"\"@{0}\"", (Object)file);
            stringArray = new String[]{string};
        }
        catch (Exception exception) {
            MTJLogger.log(4, "getArguments", exception);
        }
        return stringArray;
    }

    protected String getClassName() {
        return MAIN_CLASS;
    }

    protected String[] getClasspath() {
        return new String[]{MTJCore.getProguardJarFile().toString()};
    }

    protected String getName() {
        return NAME;
    }

    protected String[] getVMArguments() {
        return EMPTY_STRING_ARRAY;
    }
}

