/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.libraries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.mtj.internal.core.externallibrary.manager.ExternalLibraryManager;
import org.eclipse.mtj.internal.core.externallibrary.model.IExternalLibrary;
import org.eclipse.mtj.internal.core.externallibrary.model.Visibility;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.mtj.internal.ui.util.PixelConverter;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.mtj.internal.ui.wizards.libraries.LibraryInfoBlock;
import org.eclipse.mtj.internal.ui.wizards.libraries.LibraryListLabelProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibrarySelectionBlock {
    private static final int IDX_SELECT_ALL = 0;
    private static final int IDX_UNSELECT_ALL = 1;
    private static final String PATH_SEPARATOR = "/";
    private final List<String> publicLibsNames;
    private boolean librariesAvailable = false;
    private LibraryInfoBlock libraryInfoBlock;
    private CheckedListDialogField libraryList;
    private Composite LibrarySelectionComposite;
    private Composite parentComposite;

    public LibrarySelectionBlock() {
        String[] stringArray;
        String[] stringArray2 = new String[]{MTJUIMessages.NewMidletProjectWizardPageLibrary_libraryList_checkall_button, MTJUIMessages.NewMidletProjectWizardPageLibrary_libraryList_uncheckall_button};
        this.libraryList = new CheckedListDialogField(null, stringArray2, (ILabelProvider)new LibraryListLabelProvider());
        this.libraryList.setLabelText(MTJUIMessages.NewMidletProjectWizardPageLibrary_libraryList_label);
        this.libraryList.setCheckAllButtonIndex(0);
        this.libraryList.setUncheckAllButtonIndex(1);
        this.libraryInfoBlock = new LibraryInfoBlock();
        this.publicLibsNames = new ArrayList<String>();
        String[] stringArray3 = stringArray = ExternalLibraryManager.getInstance().getMidletLibraryNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray3[n2];
            IExternalLibrary iExternalLibrary = ExternalLibraryManager.getInstance().getMidletLibrary(string);
            if (iExternalLibrary != null && iExternalLibrary.getVisibility() != Visibility.INTERNAL && iExternalLibrary.getVisibility() != Visibility.INVALID) {
                this.publicLibsNames.add(string);
            }
            ++n2;
        }
        if (!this.publicLibsNames.isEmpty()) {
            this.librariesAvailable = true;
        }
    }

    public void checkAll(boolean bl) {
        this.libraryList.checkAll(bl);
    }

    public Control createControl(Composite composite) {
        this.parentComposite = composite;
        PixelConverter pixelConverter = new PixelConverter((Control)this.parentComposite);
        int[] nArray = new int[]{60};
        this.LibrarySelectionComposite = this.createMainComposite(this.parentComposite);
        Composite composite2 = this.createScrolledPageContent(this.LibrarySelectionComposite);
        SashForm sashForm = this.createSashForm(composite2);
        this.createLibraryListComposite((Composite)sashForm, pixelConverter.convertWidthInCharsToPixels(24));
        this.createExpandableComposite(sashForm, nArray);
        sashForm.setWeights(new int[]{50, 50});
        this.adjustSashForm(nArray, sashForm, false);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(20);
        sashForm.setLayoutData((Object)gridData);
        composite.layout(true);
        this.libraryList.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this.libraryInfoBlock);
        return this.LibrarySelectionComposite;
    }

    public Control getControl() {
        return this.LibrarySelectionComposite;
    }

    public List<IPath> getLibrariesPathEntries() {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        List<Object> list = this.libraryList.getElements();
        for (Object object : list) {
            IExternalLibrary iExternalLibrary = (IExternalLibrary)object;
            arrayList.add((IPath)new Path("org.eclipse.mtj.core.EXTERNAL_LIBRARY/" + iExternalLibrary.getName()));
        }
        return arrayList;
    }

    public List<Object> getSelectedLibraries() {
        return this.libraryList.getCheckedElements();
    }

    public List<IPath> getSelectedLibrariesPathEntries() {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        List<Object> list = this.getSelectedLibraries();
        for (Object object : list) {
            IExternalLibrary iExternalLibrary = (IExternalLibrary)object;
            arrayList.add((IPath)new Path("org.eclipse.mtj.core.EXTERNAL_LIBRARY/" + iExternalLibrary.getName()));
        }
        return arrayList;
    }

    public boolean isLibrariesAvailable() {
        return this.librariesAvailable;
    }

    public void setChecked(Object object, boolean bl) {
        this.libraryList.setCheckedWithoutUpdate(object, bl);
    }

    public void setLibrarySelectionDialogFieldListener(IDialogFieldListener iDialogFieldListener) {
        this.libraryList.setDialogFieldListener(iDialogFieldListener);
    }

    private void adjustSashForm(int[] nArray, SashForm sashForm, boolean bl) {
        if (bl) {
            int n = nArray[0];
            sashForm.setWeights(new int[]{n, 100 - n});
        } else {
            nArray[0] = sashForm.getWeights()[0] / 10;
            sashForm.setWeights(new int[]{95, 5});
        }
        sashForm.layout(true);
    }

    private Composite createExpandableComposite(final SashForm sashForm, final int[] nArray) {
        final ExpandableComposite expandableComposite = new ExpandableComposite((Composite)sashForm, 0, 18);
        expandableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        expandableComposite.setFont(sashForm.getFont());
        expandableComposite.setText(MTJUIMessages.NewMidletProjectWizardPageLibrary_HintTextGroup_title);
        expandableComposite.setExpanded(false);
        expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                ScrolledPageContent scrolledPageContent = LibrarySelectionBlock.this.getParentScrolledComposite((Control)expandableComposite);
                if (scrolledPageContent != null) {
                    boolean bl = expandableComposite.isExpanded();
                    scrolledPageContent.reflow(true);
                    LibrarySelectionBlock.this.adjustSashForm(nArray, sashForm, bl);
                }
            }
        });
        expandableComposite.setClient(this.libraryInfoBlock.createControl((Composite)expandableComposite));
        return expandableComposite;
    }

    private Composite createLibraryListComposite(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.libraryList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.libraryList.getListControl(null));
        this.libraryList.setButtonsMinWidth(n);
        this.initialize();
        return composite2;
    }

    private Composite createMainComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite2;
    }

    private SashForm createSashForm(Composite composite) {
        SashForm sashForm = new SashForm(composite, 512);
        sashForm.setFont(sashForm.getFont());
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        return sashForm;
    }

    private Composite createScrolledPageContent(Composite composite) {
        ScrolledPageContent scrolledPageContent = new ScrolledPageContent(composite);
        scrolledPageContent.setLayout((Layout)new GridLayout());
        scrolledPageContent.setLayoutData(new GridData(4, 4, true, true));
        Composite composite2 = scrolledPageContent.getBody();
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite2;
    }

    private ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite composite = control.getParent();
        while (!(composite instanceof ScrolledPageContent)) {
            composite = composite.getParent();
        }
        if (composite instanceof ScrolledPageContent) {
            return (ScrolledPageContent)composite;
        }
        return null;
    }

    private void initialize() {
        if (this.librariesAvailable) {
            for (String string : this.publicLibsNames) {
                try {
                    this.libraryList.addElement(ExternalLibraryManager.getInstance().getMidletLibrary(string));
                }
                catch (Exception exception) {
                    MTJLogger.log((int)4, (String)("Failed to load \"" + string + "\" Library"), (Throwable)exception);
                }
            }
        }
    }

    protected void doUpdateUI() {
        this.libraryList.refresh();
    }

    protected void updateUI() {
        if (this.parentComposite == null || this.parentComposite.isDisposed()) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.doUpdateUI();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (LibrarySelectionBlock.this.parentComposite == null || LibrarySelectionBlock.this.parentComposite.isDisposed()) {
                        return;
                    }
                    LibrarySelectionBlock.this.doUpdateUI();
                }
            });
        }
    }
}

