/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.core.symbol.ISymbolSetRegistryChangeListener;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.preferences.SymbolDefinitionsImportWizard;
import org.eclipse.mtj.internal.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.internal.ui.viewers.TableViewerConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SymbolDefinitionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.mtj.ui.preferences.symbolDefinitionsPreferencePage";
    private static final TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(MTJUIMessages.SymbolDefinitionsPreferencePage_symbolColumnInfo, 50.0f, null), new TableColumnInfo(MTJUIMessages.SymbolDefinitionsPreferencePage_valueColumnInfo, 50.0f, null)};
    private static final int DEFAULT_TABLE_WIDTH = 650;
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final String PROP_SYMBOL = "symbol";
    private static final String PROP_VALUE = "value";
    private static final String[] PROPERTIES = new String[]{"symbol", "value"};
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile(".*\\s+.*");
    private Button addSetButton;
    private Button addSymbolButton;
    private ArrayList<ISymbol> currentDefinitions;
    private ComboViewer definitionsComboViewer;
    private ISymbolSet[] definitionSetsinput = null;
    private Button importSetButton;
    private Button removeSetButton;
    private Button removeSymbolButton;
    private Group symbolsGroup;
    private TableViewer tableViewer;
    private IWorkbench workbench;

    public void commitSymbolDefinitions() {
        this.commitSymbolDefinitions(this.getSelectedSymbolDefinitionSet());
    }

    public void init(IWorkbench iWorkbench) {
        this.workbench = iWorkbench;
        this.noDefaultAndApplyButton();
    }

    public boolean performCancel() {
        return this.reloadSymbolDefinitionsRegistry() && super.performCancel();
    }

    public boolean performOk() {
        boolean bl = false;
        this.commitSymbolDefinitions();
        try {
            MTJCore.getSymbolSetRegistry().store();
            bl = true;
        }
        catch (PersistenceException persistenceException) {
            this.handleException(MTJUIMessages.SymbolDefinitionsPreferencePage_error_store_symbol, persistenceException);
        }
        catch (TransformerException transformerException) {
            this.handleException(MTJUIMessages.SymbolDefinitionsPreferencePage_error_store_symbol, transformerException);
        }
        catch (IOException iOException) {
            this.handleException(MTJUIMessages.SymbolDefinitionsPreferencePage_error_store_symbol, iOException);
        }
        return bl && super.performOk();
    }

    private void commitSymbolDefinitions(ISymbolSet iSymbolSet) {
        if (iSymbolSet != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.currentDefinitions.size());
            for (ISymbol iSymbol : this.currentDefinitions) {
                hashMap.put(iSymbol.getName(), iSymbol.getValue());
            }
            iSymbolSet.setSymbols(hashMap);
        }
    }

    private TableViewer createTableViewer(Composite composite) {
        int n = 68100;
        Table table = new Table(composite, n);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new SymbolDefinitionLabelProvider());
        tableViewer.setSorter(new ViewerSorter());
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                SymbolDefinitionsPreferencePage.this.updateButtonEnablement();
            }
        });
        IDialogSettings iDialogSettings = MTJUIPlugin.getDialogSettings("symbolDefsViewerSettings");
        TableViewerConfiguration tableViewerConfiguration = new TableViewerConfiguration(iDialogSettings, 650, COLUMN_INFO, 0);
        tableViewerConfiguration.configure(tableViewer);
        tableViewer.setCellModifier((ICellModifier)new CellModifier());
        tableViewer.setColumnProperties(PROPERTIES);
        tableViewer.setCellEditors(new CellEditor[]{new SymbolNameCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        return tableViewer;
    }

    private ISymbol getSelectedSymbolDefinition() {
        ISymbol iSymbol = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tableViewer.getSelection();
        if (iStructuredSelection != null) {
            iSymbol = (ISymbol)iStructuredSelection.getFirstElement();
        }
        return iSymbol;
    }

    private ISymbolSet getSelectedSymbolDefinitionSet() {
        ISymbolSet iSymbolSet = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.definitionsComboViewer.getSelection();
        iSymbolSet = iStructuredSelection.size() == 0 ? null : (ISymbolSet)iStructuredSelection.getFirstElement();
        return iSymbolSet;
    }

    private void handleAddSetButton() {
        try {
            String string = this.definitionsComboViewer.getCombo().getText();
            ISymbolSet iSymbolSet = null;
            try {
                iSymbolSet = MTJCore.getSymbolSetRegistry().getSymbolSet(string);
            }
            catch (PersistenceException persistenceException) {}
            ISymbolSet iSymbolSet2 = this.getSelectedSymbolDefinitionSet();
            if (!this.isValidSetName(string) || iSymbolSet2 != null || iSymbolSet != null) {
                this.setErrorMessage(MTJUIMessages.SymbolDefinitionsPreferencePage_invalidSymbolSetName);
                return;
            }
            this.setErrorMessage(null);
            ISymbolSet iSymbolSet3 = MTJCore.getSymbolSetFactory().createSymbolSet(string);
            MTJCore.getSymbolSetRegistry().addSymbolSet(iSymbolSet3);
            this.definitionsComboViewer.refresh();
            this.definitionsComboViewer.setSelection((ISelection)new StructuredSelection((Object)iSymbolSet3));
            this.tableViewer.setInput((Object)iSymbolSet3);
        }
        catch (PersistenceException persistenceException) {
            this.handleException(MTJUIMessages.SymbolDefinitionsPreferencePage_error_add_symbol, persistenceException);
        }
    }

    private void handleAddSymbolButton() {
        String string = "NewSymbol";
        ISymbol iSymbol = null;
        int n = 1;
        while (n < 100) {
            string = "NewSymbol" + n;
            iSymbol = MTJCore.getSymbolSetFactory().createSymbol(string, "true");
            if (!this.currentDefinitions.contains(iSymbol)) {
                this.currentDefinitions.add(iSymbol);
                break;
            }
            ++n;
        }
        this.tableViewer.refresh();
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n2 = 0;
        while (n2 < tableItemArray.length) {
            if (iSymbol.equals(tableItemArray[n2].getData())) break;
            ++n2;
        }
        this.tableViewer.getTable().select(n2);
        this.tableViewer.getTable().forceFocus();
    }

    private void handleException(String string, Throwable throwable) {
        MTJLogger.log((int)2, (String)string, (Throwable)throwable);
        MessageDialog.openError((Shell)this.workbench.getActiveWorkbenchWindow().getShell(), (String)MTJUIMessages.SymbolDefinitionsPreferencePage_handleException_dialog_title, (String)string);
    }

    private void handleImportSetButton() {
        SymbolDefinitionsImportWizard symbolDefinitionsImportWizard = new SymbolDefinitionsImportWizard();
        WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)symbolDefinitionsImportWizard);
        if (wizardDialog.open() == 0) {
            this.definitionsComboViewer.refresh();
        }
    }

    private void handleRemoveSetButton() {
        ISymbolSet iSymbolSet = this.getSelectedSymbolDefinitionSet();
        if (iSymbolSet != null) {
            MTJCore.getSymbolSetRegistry().removeSymbolSet(iSymbolSet.getName());
            this.definitionsComboViewer.refresh();
            this.tableViewer.refresh();
        }
    }

    private void handleRemoveSymbolButton() {
        TableItem[] tableItemArray;
        Table table = this.tableViewer.getTable();
        TableItem[] tableItemArray2 = tableItemArray = table.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray2[n2];
            this.currentDefinitions.remove(tableItem.getData());
            ++n2;
        }
        this.tableViewer.refresh();
    }

    private void initializeDefinitionsCombo() {
        Object object = new Object();
        this.definitionsComboViewer.setInput(object);
        IStructuredContentProvider iStructuredContentProvider = (IStructuredContentProvider)this.definitionsComboViewer.getContentProvider();
        Object[] objectArray = iStructuredContentProvider.getElements(object);
        if (objectArray != null && objectArray.length > 0) {
            this.definitionsComboViewer.setSelection((ISelection)new StructuredSelection(objectArray[0]), true);
        }
    }

    private boolean isValidSetName(String string) {
        boolean bl = string != null && string.trim().length() > 0;
        int n = 0;
        while (bl && n < string.length()) {
            char c = string.charAt(n);
            bl = c == ' ' || Character.isLetterOrDigit(c);
            ++n;
        }
        return bl;
    }

    private boolean isValidSymbol(String string) {
        boolean bl = false;
        if (string != null) {
            Matcher matcher = WHITESPACE_PATTERN.matcher(string);
            bl = !matcher.matches();
        }
        return bl;
    }

    private boolean reloadSymbolDefinitionsRegistry() {
        boolean bl = true;
        try {
            MTJCore.getSymbolSetRegistry().load();
        }
        catch (PersistenceException persistenceException) {
            bl = false;
            this.handleException(MTJUIMessages.SymbolDefinitionsPreferencePage_error_reloading_symbol_definitions, persistenceException);
        }
        return bl;
    }

    private void updateButtonEnablement() {
        ISymbolSet iSymbolSet = this.getSelectedSymbolDefinitionSet();
        this.removeSetButton.setEnabled(iSymbolSet != null);
        ISymbol iSymbol = this.getSelectedSymbolDefinition();
        this.addSymbolButton.setEnabled(iSymbolSet != null);
        this.removeSymbolButton.setEnabled(iSymbol != null);
    }

    protected Control createContents(Composite composite) {
        try {
            this.definitionSetsinput = MTJCore.getSymbolSetRegistry().getAllSymbolSets();
        }
        catch (PersistenceException persistenceException) {
            this.handleException(MTJUIMessages.SymbolDefinitionsPreferencePage_error_retrieving_symbol_definitions, persistenceException);
        }
        MTJCore.getSymbolSetRegistry().addSymbolSetRegistryChangeListener(new ISymbolSetRegistryChangeListener(){

            public void symbolSetRegistryChanged() {
                try {
                    SymbolDefinitionsPreferencePage.this.definitionSetsinput = MTJCore.getSymbolSetRegistry().getAllSymbolSets();
                    if (SymbolDefinitionsPreferencePage.this.definitionsComboViewer != null && !SymbolDefinitionsPreferencePage.this.definitionsComboViewer.getControl().isDisposed() && SymbolDefinitionsPreferencePage.this.workbench.getActiveWorkbenchWindow() != null) {
                        SymbolDefinitionsPreferencePage.this.definitionsComboViewer.refresh();
                    }
                }
                catch (PersistenceException persistenceException) {
                    SymbolDefinitionsPreferencePage.this.handleException(MTJUIMessages.SymbolDefinitionsPreferencePage_error_retrieving_symbol_definitions, persistenceException);
                }
            }
        });
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(3, false));
        composite3.setLayoutData((Object)new GridData(768));
        new Label(composite3, 0).setText(MTJUIMessages.SymbolDefinitionsPreferencePage_def_set_label_text);
        this.definitionsComboViewer = new ComboViewer(composite3, 4);
        this.definitionsComboViewer.setContentProvider((IContentProvider)new DefinitionSetsContentProvider());
        this.definitionsComboViewer.setLabelProvider((IBaseLabelProvider)new DefinitionSetLabelProvider());
        this.definitionsComboViewer.setInput((Object)this.definitionSetsinput);
        this.definitionsComboViewer.setSorter(new ViewerSorter());
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 0x1000000;
        this.definitionsComboViewer.getCombo().setLayoutData((Object)gridData);
        this.definitionsComboViewer.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SymbolDefinitionsPreferencePage.this.updateButtonEnablement();
                SymbolDefinitionsPreferencePage.this.setErrorMessage(null);
            }
        });
        Composite composite4 = new Composite(composite3, 0);
        composite4.setLayout((Layout)new GridLayout(1, true));
        this.addSetButton = new Button(composite4, 8);
        this.addSetButton.setText(MTJUIMessages.SymbolDefinitionsPreferencePage_addSetButton);
        this.addSetButton.setLayoutData((Object)new GridData(768));
        this.addSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SymbolDefinitionsPreferencePage.this.handleAddSetButton();
            }
        });
        this.addSetButton.setEnabled(true);
        this.removeSetButton = new Button(composite4, 8);
        this.removeSetButton.setText(MTJUIMessages.SymbolDefinitionsPreferencePage_removeSetButton);
        this.removeSetButton.setLayoutData((Object)new GridData(768));
        this.removeSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SymbolDefinitionsPreferencePage.this.handleRemoveSetButton();
            }
        });
        this.removeSetButton.setEnabled(false);
        this.importSetButton = new Button(composite4, 8);
        this.importSetButton.setText(MTJUIMessages.SymbolDefinitionsPreferencePage_ImportButton);
        this.importSetButton.setLayoutData((Object)new GridData(768));
        this.importSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SymbolDefinitionsPreferencePage.this.handleImportSetButton();
            }
        });
        this.symbolsGroup = new Group(composite2, 4);
        this.symbolsGroup.setLayout((Layout)new GridLayout(2, false));
        this.symbolsGroup.setLayoutData((Object)new GridData(1808));
        GridData gridData2 = new GridData(1808);
        gridData2.minimumWidth = 400;
        gridData2.heightHint = 300;
        this.tableViewer = this.createTableViewer((Composite)this.symbolsGroup);
        this.tableViewer.getTable().setLayoutData((Object)gridData2);
        Composite composite5 = new Composite((Composite)this.symbolsGroup, 0);
        composite5.setLayout((Layout)new GridLayout(1, true));
        this.addSymbolButton = new Button(composite5, 8);
        this.addSymbolButton.setText(MTJUIMessages.SymbolDefinitionsPreferencePage_addSymbolButton);
        this.addSymbolButton.setLayoutData((Object)new GridData(768));
        this.addSymbolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SymbolDefinitionsPreferencePage.this.handleAddSymbolButton();
            }
        });
        this.addSymbolButton.setEnabled(false);
        this.removeSymbolButton = new Button(composite5, 8);
        this.removeSymbolButton.setText(MTJUIMessages.SymbolDefinitionsPreferencePage_removeSymbolButton);
        this.removeSymbolButton.setLayoutData((Object)new GridData(768));
        this.removeSymbolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SymbolDefinitionsPreferencePage.this.handleRemoveSymbolButton();
            }
        });
        this.removeSymbolButton.setEnabled(false);
        this.definitionsComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                SymbolDefinitionsPreferencePage.this.updateButtonEnablement();
                ISymbolSet iSymbolSet = SymbolDefinitionsPreferencePage.this.getSelectedSymbolDefinitionSet();
                SymbolDefinitionsPreferencePage.this.tableViewer.setInput((Object)iSymbolSet);
            }
        });
        this.initializeDefinitionsCombo();
        return composite2;
    }

    protected void performDefaults() {
        this.reloadSymbolDefinitionsRegistry();
        this.initializeDefinitionsCombo();
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return true;
        }

        public Object getValue(Object object, String string) {
            String string2 = null;
            ISymbol iSymbol = (ISymbol)object;
            string2 = string.equals(SymbolDefinitionsPreferencePage.PROP_SYMBOL) ? iSymbol.getName() : iSymbol.getValue();
            return string2;
        }

        public void modify(Object object, String string, Object object2) {
            TableItem tableItem = (TableItem)object;
            String string2 = tableItem.getText(0);
            String string3 = tableItem.getText(1);
            int n = this.findSymbolDefinition(string2);
            if (n != -1) {
                if (string.equals(SymbolDefinitionsPreferencePage.PROP_SYMBOL)) {
                    String string4 = (String)object2;
                    if (SymbolDefinitionsPreferencePage.this.isValidSymbol(string4)) {
                        ISymbol iSymbol = MTJCore.getSymbolSetFactory().createSymbol(string4, string3);
                        SymbolDefinitionsPreferencePage.this.currentDefinitions.set(n, iSymbol);
                    }
                } else {
                    ISymbol iSymbol = (ISymbol)SymbolDefinitionsPreferencePage.this.currentDefinitions.get(n);
                    iSymbol.setValue((String)object2);
                }
                SymbolDefinitionsPreferencePage.this.tableViewer.refresh();
            }
            SymbolDefinitionsPreferencePage.this.setErrorMessage(null);
        }

        private int findSymbolDefinition(String string) {
            int n = -1;
            int n2 = 0;
            while (n2 < SymbolDefinitionsPreferencePage.this.currentDefinitions.size()) {
                ISymbol iSymbol = (ISymbol)SymbolDefinitionsPreferencePage.this.currentDefinitions.get(n2);
                if (iSymbol.getName().equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            return n;
        }
    }

    private static class DefinitionSetLabelProvider
    extends LabelProvider {
        private DefinitionSetLabelProvider() {
        }

        public String getText(Object object) {
            return ((ISymbolSet)object).getName();
        }
    }

    private class DefinitionSetsContentProvider
    implements IStructuredContentProvider {
        private DefinitionSetsContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = NO_ELEMENTS;
            if (SymbolDefinitionsPreferencePage.this.definitionSetsinput != null) {
                objectArray = SymbolDefinitionsPreferencePage.this.definitionSetsinput;
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class SymbolDefinitionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private SymbolDefinitionLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            String string = "";
            ISymbol iSymbol = (ISymbol)object;
            switch (n) {
                case 0: {
                    string = iSymbol.getName();
                    break;
                }
                case 1: {
                    string = iSymbol.getValue();
                }
            }
            return string;
        }
    }

    private class SymbolNameCellEditor
    extends TextCellEditor {
        public SymbolNameCellEditor(Composite composite) {
            super(composite);
            this.setValidator(new SymbolNameCellEditorValidator());
            this.addListener(new ICellEditorListener(){

                public void applyEditorValue() {
                }

                public void cancelEditor() {
                }

                public void editorValueChanged(boolean bl, boolean bl2) {
                    if (!bl2) {
                        SymbolNameCellEditor.this.setErrorMessage(SymbolNameCellEditor.this.getErrorMessage());
                    } else {
                        SymbolNameCellEditor.this.setErrorMessage(null);
                    }
                }
            });
        }
    }

    private class SymbolNameCellEditorValidator
    implements ICellEditorValidator {
        private SymbolNameCellEditorValidator() {
        }

        public String isValid(Object object) {
            String string = (String)object;
            return SymbolDefinitionsPreferencePage.this.isValidSymbol(string) ? null : MTJUIMessages.SymbolDefinitionsPreferencePage_invalid_symbol;
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return SymbolDefinitionsPreferencePage.this.currentDefinitions.toArray(new Object[SymbolDefinitionsPreferencePage.this.currentDefinitions.size()]);
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            ISymbolSet iSymbolSet;
            Collection collection;
            if (object != null) {
                SymbolDefinitionsPreferencePage.this.commitSymbolDefinitions((ISymbolSet)object);
            }
            if (SymbolDefinitionsPreferencePage.this.currentDefinitions == null) {
                SymbolDefinitionsPreferencePage.this.currentDefinitions = new ArrayList();
            } else {
                SymbolDefinitionsPreferencePage.this.currentDefinitions.clear();
            }
            if (object2 instanceof ISymbolSet && (collection = (iSymbolSet = (ISymbolSet)object2).getSymbols()) != null) {
                SymbolDefinitionsPreferencePage.this.symbolsGroup.setText(NLS.bind((String)MTJUIMessages.SymbolDefinitionsPreferencePage_symbolsGroup_label_text, (Object)iSymbolSet.getName()));
                for (ISymbol iSymbol : collection) {
                    SymbolDefinitionsPreferencePage.this.currentDefinitions.add(iSymbol);
                }
            }
        }
    }
}

