/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.l10n;

import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.wizards.l10n.ClassFileStringsContentProvider;
import org.eclipse.mtj.internal.ui.wizards.l10n.ClassFileStringsLabelProvider;
import org.eclipse.mtj.internal.ui.wizards.l10n.RegExpStringExternalizer;
import org.eclipse.mtj.internal.ui.wizards.l10n.StringLocalizationData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class StringLocalizationWizardPage1
extends WizardPage {
    private static final String[] COLUMNS = new String[]{MTJUIMessages.StringLocalizationWizardPage1_valueColumn, MTJUIMessages.StringLocalizationWizardPage1_keyColumn};
    private IBuffer buffer;
    private TableViewer viewer;
    private Table table;
    private Text text;
    private RegExpStringExternalizer externalizer;

    protected StringLocalizationWizardPage1(String string, IBuffer iBuffer) {
        super("StringLocalizationWizardPage1");
        if (iBuffer == null) {
            throw new IllegalArgumentException(MTJUIMessages.StringLocalizationWizardPage1_nullBuffer);
        }
        this.setTitle(NLS.bind((String)MTJUIMessages.StringLocalizationWizardPage1_pageTitle, (Object)string));
        this.setImageDescriptor(MTJUIPluginImages.DESC_ADD_L10N);
        this.externalizer = new RegExpStringExternalizer();
        this.buffer = iBuffer;
        String string2 = this.buffer.getContents();
        if (Platform.getOS().equals("win32")) {
            string2 = string2.replaceAll("\n", "\r\n");
            this.buffer.setContents(string2);
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        this.createTableSection(composite2);
        this.createSourceSection(composite2);
        this.setControl((Control)composite2);
    }

    public StringLocalizationData[] getExternalizedStrings() {
        TableItem[] tableItemArray;
        ArrayList<StringLocalizationData> arrayList = new ArrayList<StringLocalizationData>();
        TableItem[] tableItemArray2 = tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray2[n2];
            Object object = tableItem.getData();
            if (tableItem.getChecked() && !tableItem.getGrayed() && object instanceof StringLocalizationData) {
                arrayList.add((StringLocalizationData)object);
            }
            ++n2;
        }
        return arrayList.toArray(new StringLocalizationData[0]);
    }

    public StringLocalizationData[] getIgnoredStrings() {
        TableItem[] tableItemArray;
        ArrayList<StringLocalizationData> arrayList = new ArrayList<StringLocalizationData>();
        TableItem[] tableItemArray2 = tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray2[n2];
            Object object = tableItem.getData();
            if (tableItem.getChecked() && tableItem.getGrayed() && object instanceof StringLocalizationData) {
                arrayList.add((StringLocalizationData)object);
            }
            ++n2;
        }
        return arrayList.toArray(new StringLocalizationData[0]);
    }

    public boolean isPageComplete() {
        return this.getExternalizedStrings().length > 0 || this.getIgnoredStrings().length > 0;
    }

    private void createTableSection(Composite composite) {
        GridData gridData = null;
        Label label = new Label(composite, 0);
        label.setText(MTJUIMessages.StringLocalizationWizardPage1_tableLabel);
        gridData = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)gridData);
        final Button button = new Button(composite, 32);
        button.setText(MTJUIMessages.StringLocalizationWizardPage1_filterLabel);
        button.setSelection(true);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                StringLocalizationWizardPage1.this.updateStringsTable(button.getSelection());
            }
        });
        gridData = new GridData(131072, 0x1000000, true, false);
        button.setLayoutData((Object)gridData);
        this.createTableView(composite);
    }

    private void createTableView(Composite composite) {
        Button button;
        CellEditor[] cellEditorArray;
        GridData gridData = null;
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.table = new Table(composite2, 67618);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                StringLocalizationWizardPage1.this.showSourceString();
                StringLocalizationWizardPage1.this.getWizard().getContainer().updateButtons();
            }
        });
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        this.table.setLayout((Layout)tableLayout);
        int n = 0;
        while (n < COLUMNS.length) {
            cellEditorArray = new TableColumn(this.table, 16384);
            cellEditorArray.setText(COLUMNS[n]);
            ++n;
        }
        this.viewer = new TableViewer(this.table);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ClassFileStringsLabelProvider(this.buffer));
        this.viewer.setContentProvider((IContentProvider)new ClassFileStringsContentProvider());
        this.viewer.setColumnProperties(COLUMNS);
        this.updateStringsTable(true);
        Button button2 = button = this.table.getItems();
        int n2 = ((TableItem[])button2).length;
        int n3 = 0;
        while (n3 < n2) {
            cellEditorArray = button2[n3];
            cellEditorArray.setChecked(true);
            ++n3;
        }
        cellEditorArray = new CellEditor[]{new TextCellEditor((Composite)this.table), new TextCellEditor((Composite)this.table)};
        this.viewer.setCellEditors(cellEditorArray);
        this.viewer.setCellModifier((ICellModifier)new StringLocalizationCellModifier());
        gridData = new GridData(4, 4, true, false);
        gridData.verticalSpan = 3;
        gridData.heightHint = 200;
        this.table.setLayoutData((Object)gridData);
        Button button3 = new Button(composite2, 0);
        button3.setText(MTJUIMessages.StringLocalizationWizardPage1_externalizeButtonText);
        gridData = new GridData(4, 128, false, false);
        button3.setLayoutData((Object)gridData);
        button3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray;
                TableItem[] tableItemArray2 = tableItemArray = StringLocalizationWizardPage1.this.table.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray2[n2];
                    tableItem.setChecked(true);
                    tableItem.setGrayed(false);
                    ++n2;
                }
                StringLocalizationWizardPage1.this.getWizard().getContainer().updateButtons();
            }
        });
        Button button4 = new Button(composite2, 0);
        button4.setText(MTJUIMessages.StringLocalizationWizardPage1_internalizeButtonText);
        gridData = new GridData(4, 128, false, false);
        button4.setLayoutData((Object)gridData);
        button4.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray;
                TableItem[] tableItemArray2 = tableItemArray = StringLocalizationWizardPage1.this.table.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray2[n2];
                    tableItem.setChecked(false);
                    ++n2;
                }
                StringLocalizationWizardPage1.this.getWizard().getContainer().updateButtons();
            }
        });
        button2 = new Button(composite2, 0);
        button2.setText(MTJUIMessages.StringLocalizationWizardPage1_ignoreButtonText);
        gridData = new GridData(4, 128, false, false);
        button2.setLayoutData((Object)gridData);
        button2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray;
                TableItem[] tableItemArray2 = tableItemArray = StringLocalizationWizardPage1.this.table.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray2[n2];
                    tableItem.setChecked(true);
                    tableItem.setGrayed(true);
                    ++n2;
                }
                StringLocalizationWizardPage1.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    private void updateStringsTable(boolean bl) {
        ArrayList<StringLocalizationData> arrayList = new ArrayList<StringLocalizationData>();
        IRegion[] iRegionArray = this.externalizer.externalize(this.buffer, !bl);
        int n = 0;
        while (n < iRegionArray.length) {
            String string = this.buffer.getText(iRegionArray[n].getOffset(), iRegionArray[n].getLength());
            arrayList.add(new StringLocalizationData(iRegionArray[n], NLS.bind((String)"key_{0}", (Object)String.valueOf(n)), string.replaceAll("\"", "")));
            ++n;
        }
        if (arrayList.size() == 0) {
            this.setMessage(MTJUIMessages.StringLocalizationWizardPage1_noStringsToLocalize, 2);
        } else {
            this.setMessage(MTJUIMessages.StringLocalizationWizardPage1_pageText);
        }
        this.viewer.setInput((Object)arrayList.toArray(new StringLocalizationData[0]));
    }

    private void showSourceString() {
        if (this.buffer == null) {
            return;
        }
        StringLocalizationData[] stringLocalizationDataArray = this.getSelectedData();
        if (stringLocalizationDataArray != null && stringLocalizationDataArray.length > 0) {
            IRegion iRegion = stringLocalizationDataArray[0].getRegion();
            this.text.setSelection(iRegion.getOffset(), iRegion.getOffset() + iRegion.getLength());
            this.text.showSelection();
        }
    }

    private StringLocalizationData[] getSelectedData() {
        TableItem[] tableItemArray;
        ArrayList<StringLocalizationData> arrayList = new ArrayList<StringLocalizationData>();
        TableItem[] tableItemArray2 = tableItemArray = this.table.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray2[n2];
            Object object = tableItem.getData();
            if (object instanceof StringLocalizationData) {
                arrayList.add((StringLocalizationData)object);
            }
            ++n2;
        }
        return arrayList.toArray(new StringLocalizationData[0]);
    }

    private void createSourceSection(Composite composite) {
        GridData gridData = null;
        Label label = new Label(composite, 0);
        label.setText(MTJUIMessages.StringLocalizationWizardPage1_context);
        gridData = new GridData(16384, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.text = new Text(composite, 2818);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.text.setLayoutData((Object)gridData);
        if (this.buffer != null) {
            this.text.setText(this.buffer.getContents());
        }
    }

    private class StringLocalizationCellModifier
    implements ICellModifier {
        private StringLocalizationCellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return string.equals(COLUMNS[1]);
        }

        public Object getValue(Object object, String string) {
            String string2 = null;
            if (object instanceof StringLocalizationData) {
                StringLocalizationData stringLocalizationData = (StringLocalizationData)object;
                if (string.equals(COLUMNS[1])) {
                    string2 = stringLocalizationData.getKey();
                }
            }
            return string2;
        }

        public void modify(Object object, String string, Object object2) {
            StringLocalizationData stringLocalizationData = null;
            if (object instanceof StringLocalizationData) {
                stringLocalizationData = (StringLocalizationData)object;
            } else if (object instanceof Item) {
                stringLocalizationData = (StringLocalizationData)((Item)object).getData();
            }
            if (stringLocalizationData != null && string.equals(COLUMNS[1])) {
                stringLocalizationData.setKey((String)object2);
                StringLocalizationWizardPage1.this.viewer.refresh();
            }
        }
    }
}

