/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.pages;

import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.core.IModelChangedEvent;
import org.eclipse.mtj.internal.core.IModelChangedListener;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.MTJFormPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class L10nEntriesTablePage
extends MTJFormPage {
    private static final String KEY_COLUMN_LABEL = "Key";
    private L10nModel model;
    private TableViewer viewer;

    public L10nEntriesTablePage(FormEditor formEditor) {
        super(formEditor, "l10nEntriesTablePage", MTJUIMessages.L10nEntriesTablePage_pageTitle);
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        this.model = (L10nModel)this.getModel();
        if (this.model == null || !this.model.isLoaded()) {
            this.createErrorContent(iManagedForm, this.model);
            return;
        }
        FormToolkit formToolkit = iManagedForm.getToolkit();
        ScrolledForm scrolledForm = iManagedForm.getForm();
        formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledForm.setExpandHorizontal(true);
        scrolledForm.setExpandVertical(true);
        scrolledForm.setText(this.getTitle());
        Composite composite = scrolledForm.getBody();
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createL10nEntriesTableSection(iManagedForm, composite);
        scrolledForm.reflow(true);
    }

    private void createL10nEntriesTableSection(IManagedForm iManagedForm, Composite composite) {
        GridData gridData = null;
        gridData = new GridData(4, 4, true, true);
        Composite composite2 = this.createSection(iManagedForm, composite, MTJUIMessages.L10nEntriesTablePage_sectionTitle, MTJUIMessages.L10nEntriesTablePage_sectionText, gridData);
        composite2.setLayout((Layout)new GridLayout(1, true));
        this.viewer = new TableViewer(composite2);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gridData);
        this.viewer.setContentProvider((IContentProvider)new L10nEntriesContentProvider());
        this.viewer.setCellModifier((ICellModifier)new L10nEntriesTableCellModifier());
        this.viewer.setLabelProvider((IBaseLabelProvider)new L10nEntriesLabelProvider());
        this.viewer.setInput((Object)this.model);
    }

    private Composite createSection(IManagedForm iManagedForm, Composite composite, String string, String string2, GridData gridData) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Section section = formToolkit.createSection(composite, 384);
        if (string != null) {
            section.setText(string);
        }
        if (string2 != null) {
            section.setDescription(string2);
        }
        section.setLayoutData((Object)gridData);
        section.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = formToolkit.createComposite((Composite)section, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        section.setClient((Control)composite2);
        return composite2;
    }

    public void setActive(boolean bl) {
        if (bl) {
            this.updateColumns(this.model);
        }
    }

    private void updateColumns(L10nModel l10nModel) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TableColumn tableColumn;
                TableColumn[] tableColumnArray;
                Table table = L10nEntriesTablePage.this.viewer.getTable();
                TableColumn[] tableColumnArray2 = tableColumnArray = table.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    tableColumn = tableColumnArray2[n2];
                    tableColumn.dispose();
                    ++n2;
                }
                tableColumn = new ArrayList();
                tableColumn.add(L10nEntriesTablePage.KEY_COLUMN_LABEL);
                TableColumn tableColumn2 = L10nEntriesTablePage.this.model.getLocales().getChildNodes();
                int n3 = ((IDocumentElementNode[])tableColumn2).length;
                n = 0;
                while (n < n3) {
                    IDocumentElementNode iDocumentElementNode = tableColumn2[n];
                    if (iDocumentElementNode instanceof L10nLocale) {
                        tableColumn.add(((L10nLocale)iDocumentElementNode).getLocaleName());
                    }
                    ++n;
                }
                L10nEntriesTablePage.this.viewer.setColumnProperties(tableColumn.toArray(new String[0]));
                ArrayList<TextCellEditor> arrayList = new ArrayList<TextCellEditor>();
                for (String string : tableColumn) {
                    tableColumn2 = new TableColumn(table, 16384);
                    tableColumn2.setText(string);
                    arrayList.add(new TextCellEditor((Composite)table));
                }
                L10nEntriesTablePage.this.viewer.setCellEditors(arrayList.toArray(new CellEditor[0]));
                TableLayout tableLayout = new TableLayout();
                int n4 = tableColumn.size();
                int n5 = 0;
                while (n5 < n4) {
                    tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100 / n4, true));
                    ++n5;
                }
                table.setLayout((Layout)tableLayout);
                table.layout(true, true);
                L10nEntriesTablePage.this.viewer.refresh();
            }
        });
    }

    private void createErrorContent(IManagedForm iManagedForm, L10nModel l10nModel) {
        this.createFormErrorContent(iManagedForm, MTJUIMessages.LocalizationPage_formErrorContent_title, MTJUIMessages.LocalizationPage_formErrorContent_message);
    }

    private class L10nEntriesContentProvider
    implements IStructuredContentProvider,
    IModelChangedListener {
        private Viewer viewer;
        private L10nModel model;

        private L10nEntriesContentProvider() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = null;
            if (object instanceof L10nModel) {
                L10nModel l10nModel = (L10nModel)object;
                objectArray = this.getAllL10nEntries(l10nModel);
            }
            return objectArray;
        }

        private L10nEntry[] getAllL10nEntries(L10nModel l10nModel) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<L10nEntry> arrayList2 = new ArrayList<L10nEntry>();
            L10nLocales l10nLocales = l10nModel.getLocales();
            IDocumentElementNode[] iDocumentElementNodeArray = l10nLocales.getChildNodes();
            int n = iDocumentElementNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDocumentElementNode iDocumentElementNode = iDocumentElementNodeArray[n2];
                if (iDocumentElementNode instanceof L10nLocale) {
                    L10nLocale l10nLocale = (L10nLocale)iDocumentElementNode;
                    IDocumentElementNode[] iDocumentElementNodeArray2 = l10nLocale.getChildNodes();
                    int n3 = iDocumentElementNodeArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        L10nEntry l10nEntry;
                        String string;
                        IDocumentElementNode iDocumentElementNode2 = iDocumentElementNodeArray2[n4];
                        if (iDocumentElementNode2 instanceof L10nEntry && !arrayList.contains(string = (l10nEntry = (L10nEntry)iDocumentElementNode2).getKey())) {
                            arrayList2.add(l10nEntry);
                            arrayList.add(string);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return arrayList2.toArray(new L10nEntry[0]);
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            if (object2 instanceof L10nModel) {
                this.model = (L10nModel)object2;
                this.model.addModelChangedListener((IModelChangedListener)this);
                L10nEntriesTablePage.this.updateColumns(this.model);
            }
            this.viewer = viewer;
        }

        public void dispose() {
            this.viewer = null;
        }

        public void modelChanged(IModelChangedEvent iModelChangedEvent) {
            if (this.viewer != null) {
                L10nEntriesTablePage.this.updateColumns(this.model);
            }
        }
    }

    private class L10nEntriesLabelProvider
    implements ITableLabelProvider {
        private L10nEntriesLabelProvider() {
        }

        public String getColumnText(Object object, int n) {
            String string = null;
            if (object instanceof L10nEntry) {
                L10nEntry l10nEntry = (L10nEntry)object;
                string = n > 0 ? this.resolveKeyValue(l10nEntry.getModel(), l10nEntry.getKey(), n - 1) : l10nEntry.getKey();
            }
            return string;
        }

        private String resolveKeyValue(L10nModel l10nModel, String string, int n) {
            L10nEntry l10nEntry;
            String string2 = null;
            L10nLocales l10nLocales = l10nModel.getLocales();
            IDocumentElementNode iDocumentElementNode = l10nLocales.getChildAt(n);
            if (iDocumentElementNode instanceof L10nLocale && (l10nEntry = ((L10nLocale)iDocumentElementNode).getEntry(string)) != null) {
                string2 = l10nEntry.getValue();
            }
            return string2;
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }
    }

    private class L10nEntriesTableCellModifier
    implements ICellModifier {
        private L10nEntriesTableCellModifier() {
        }

        public Object getValue(Object object, String string) {
            L10nEntry l10nEntry;
            L10nEntry l10nEntry2;
            String string2 = "";
            if (object instanceof L10nEntry && (l10nEntry2 = this.resolveKeyEntry((l10nEntry = (L10nEntry)object).getModel(), l10nEntry.getKey(), string)) != null) {
                string2 = l10nEntry2.getValue();
            }
            return string2;
        }

        private L10nEntry resolveKeyEntry(L10nModel l10nModel, String string, String string2) {
            IDocumentElementNode[] iDocumentElementNodeArray;
            L10nEntry l10nEntry = null;
            L10nLocales l10nLocales = l10nModel.getLocales();
            IDocumentElementNode[] iDocumentElementNodeArray2 = iDocumentElementNodeArray = l10nLocales.getChildNodes();
            int n = iDocumentElementNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                L10nEntry l10nEntry2;
                L10nLocale l10nLocale;
                IDocumentElementNode iDocumentElementNode = iDocumentElementNodeArray2[n2];
                if (iDocumentElementNode instanceof L10nLocale && (l10nLocale = (L10nLocale)iDocumentElementNode).getLocaleName().equals(string2) && (l10nEntry2 = l10nLocale.getEntry(string)) != null) {
                    l10nEntry = l10nEntry2;
                }
                ++n2;
            }
            return l10nEntry;
        }

        public void modify(Object object, String string, Object object2) {
            if (object instanceof Item) {
                object = ((Item)object).getData();
            }
            if (object instanceof L10nEntry) {
                L10nEntry l10nEntry = (L10nEntry)object;
                L10nModel l10nModel = l10nEntry.getModel();
                L10nEntry l10nEntry2 = this.resolveKeyEntry(l10nModel, l10nEntry.getKey(), string);
                if (l10nEntry2 == null) {
                    L10nLocale l10nLocale = l10nModel.getLocales().getLocale(string);
                    if (l10nLocale != null) {
                        l10nEntry2 = new L10nEntry(l10nModel);
                        l10nEntry2.setKey(l10nEntry.getKey());
                        l10nEntry2.setValue((String)object2);
                        l10nLocale.addChild((L10nObject)l10nEntry2);
                    }
                } else {
                    l10nEntry2.setValue((String)object2);
                }
            }
        }

        public boolean canModify(Object object, String string) {
            return !string.equals(L10nEntriesTablePage.KEY_COLUMN_LABEL);
        }
    }
}

