/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.midp.J2MENature;
import org.eclipse.mtj.core.project.midp.ProjectConvertionException;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.project.midp.MTJProjectConverter;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.actions.AbstractJavaProjectAction;
import org.eclipse.mtj.internal.ui.dialog.DeviceSelectDialog;
import org.eclipse.swt.widgets.Shell;

public class ConvertToMidletProjectAction
extends AbstractJavaProjectAction {
    public void run(IAction iAction) {
        if (this.selection != null && !this.selection.isEmpty()) {
            try {
                IMIDPDevice iMIDPDevice = this.getDevice();
                if (iMIDPDevice == null) {
                    MessageDialog.openError((Shell)this.getShell(), (String)MTJUIMessages.ConvertToMidletProjectAction_error_no_device_title, (String)MTJUIMessages.ConvertToMidletProjectAction_error_no_device_message);
                } else {
                    this.convertSelectedProjects(iMIDPDevice);
                }
            }
            catch (PersistenceException persistenceException) {
                this.handleException(persistenceException);
            }
        }
    }

    private void convertSelectedProjects(IMIDPDevice iMIDPDevice) {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
        try {
            progressMonitorDialog.open();
            IProgressMonitor iProgressMonitor = progressMonitorDialog.getProgressMonitor();
            MTJCore.getWorkspace().run(this.getRunnable(iMIDPDevice), iProgressMonitor);
            progressMonitorDialog.close();
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
    }

    private IMIDPDevice getDevice() throws PersistenceException {
        DeviceSelectDialog deviceSelectDialog;
        IMIDPDevice iMIDPDevice = null;
        if (MTJCore.getDeviceRegistry().getDeviceCount() > 0 && (deviceSelectDialog = new DeviceSelectDialog(this.getShell())).open() == 0) {
            iMIDPDevice = (IMIDPDevice)deviceSelectDialog.getSelectedDevice();
        }
        return iMIDPDevice;
    }

    private IWorkspaceRunnable getRunnable(final IMIDPDevice iMIDPDevice) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                iProgressMonitor.beginTask(MTJUIMessages.ConvertToMidletProjectAction_convert_taskname, ConvertToMidletProjectAction.this.selection.size());
                Iterator iterator = ConvertToMidletProjectAction.this.selection.iterator();
                while (iterator.hasNext()) {
                    IJavaProject iJavaProject = ConvertToMidletProjectAction.this.getJavaProject(iterator.next());
                    if (iJavaProject != null) {
                        iProgressMonitor.setTaskName(MTJUIMessages.bind((String)MTJUIMessages.ConvertToMidletProjectAction_convert_taskname2, (Object)iJavaProject.getElementName()));
                        boolean bl = false;
                        boolean bl2 = false;
                        IProject iProject = iJavaProject.getProject();
                        try {
                            bl = J2MENature.hasMtjCoreNature((IProject)iProject);
                        }
                        catch (CoreException coreException) {}
                        try {
                            bl2 = iProject.hasNature("eclipseme.core.nature");
                        }
                        catch (CoreException coreException) {}
                        if (!bl) {
                            if (bl2) {
                                try {
                                    MTJProjectConverter.getInstance().convertEclipseMeProject(iProject, iMIDPDevice, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                                }
                                catch (ProjectConvertionException projectConvertionException) {
                                    MTJStatusHandler.throwCoreException((int)4, (int)-999, (String)projectConvertionException.getMessage());
                                }
                            } else {
                                try {
                                    MTJProjectConverter.getInstance().convertJavaProject(iJavaProject, iMIDPDevice, iProgressMonitor);
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    MTJStatusHandler.throwCoreException((int)4, (int)-999, (Throwable)invocationTargetException.getTargetException());
                                }
                                catch (InterruptedException interruptedException) {
                                    MTJStatusHandler.throwCoreException((int)4, (int)-999, (Throwable)interruptedException);
                                }
                            }
                        }
                    }
                    iProgressMonitor.worked(1);
                }
                iProgressMonitor.done();
            }
        };
    }

    private void handleException(Throwable throwable) {
        MTJLogger.log((int)4, (Throwable)throwable);
        MessageDialog.openError((Shell)this.getShell(), (String)MTJUIMessages.ConvertToMidletProjectAction_handleException_title, (String)throwable.toString());
    }
}

