/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.internal.core.IBaseModel;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editor.FoldingStructureProviderFactory;
import org.eclipse.mtj.internal.ui.editor.IFoldingStructureProvider;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJProjectionViewer;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.SourceViewerConfigurationFactory;
import org.eclipse.mtj.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.mtj.internal.ui.editor.text.ColorManager;
import org.eclipse.mtj.internal.ui.editor.text.IColorManager;
import org.eclipse.mtj.internal.ui.editor.text.ReconcilingStrategy;
import org.eclipse.swt.widgets.Composite;

public abstract class MTJProjectionSourcePage
extends MTJSourcePage
implements IProjectionListener {
    private IColorManager fColorManager = ColorManager.getDefault();
    private ChangeAwareSourceViewerConfiguration fConfiguration = SourceViewerConfigurationFactory.createSourceViewerConfiguration(this, this.fColorManager);
    private IFoldingStructureProvider fFoldingStructureProvider;
    private ProjectionSupport fProjectionSupport;

    public MTJProjectionSourcePage(MTJFormEditor mTJFormEditor, String string, String string2) {
        super(mTJFormEditor, string, string2);
        if (this.fConfiguration != null) {
            this.setSourceViewerConfiguration((SourceViewerConfiguration)this.fConfiguration);
        }
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.createFoldingSupport(projectionViewer);
        if (this.isFoldingEnabled()) {
            projectionViewer.doOperation(19);
        }
    }

    public void dispose() {
        ((ProjectionViewer)this.getSourceViewer()).removeProjectionListener((IProjectionListener)this);
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        this.fColorManager.dispose();
        if (this.fConfiguration != null) {
            this.fConfiguration.dispose();
        }
        super.dispose();
    }

    public Object getAdapter(Class clazz) {
        Object object;
        if (this.fProjectionSupport != null && (object = this.fProjectionSupport.getAdapter(this.getSourceViewer(), clazz)) != null) {
            return object;
        }
        return super.getAdapter(clazz);
    }

    public abstract boolean isQuickOutlineEnabled();

    public void projectionDisabled() {
        this.fFoldingStructureProvider = null;
    }

    public void projectionEnabled() {
        IBaseModel iBaseModel = this.getInputContext().getModel();
        if (iBaseModel instanceof IEditingModel) {
            this.fFoldingStructureProvider = FoldingStructureProviderFactory.createProvider(this, (IEditingModel)iBaseModel);
            if (this.fFoldingStructureProvider != null) {
                this.fFoldingStructureProvider.initialize();
                IReconciler iReconciler = this.getSourceViewerConfiguration().getReconciler(this.getSourceViewer());
                IReconcilingStrategy iReconcilingStrategy = iReconciler.getReconcilingStrategy(new String());
                if (iReconcilingStrategy instanceof ReconcilingStrategy) {
                    ((ReconcilingStrategy)iReconcilingStrategy).addParticipant(this.fFoldingStructureProvider);
                }
            }
        }
    }

    private void addQuickOutlineMenuEntry(IMenuManager iMenuManager) {
        if (!this.isQuickOutlineEnabled()) {
            return;
        }
        IAction iAction = this.getAction("org.eclipse.mtj.ui.quickOutline");
        if (iAction == null) {
            return;
        }
        iMenuManager.add(iAction);
    }

    private void createFoldingSupport(ProjectionViewer projectionViewer) {
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.install();
        ((ProjectionViewer)this.getSourceViewer()).addProjectionListener((IProjectionListener)this);
    }

    private boolean isFoldingEnabled() {
        IPreferenceStore iPreferenceStore = MTJUIPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean("editor.folding");
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent propertyChangeEvent) {
        if (this.fConfiguration == null) {
            return false;
        }
        return this.fConfiguration.affectsTextPresentation(propertyChangeEvent) || super.affectsTextPresentation(propertyChangeEvent);
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        MTJProjectionViewer mTJProjectionViewer = new MTJProjectionViewer(composite, iVerticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), n, this.isQuickOutlineEnabled());
        this.getSourceViewerDecorationSupport((ISourceViewer)mTJProjectionViewer);
        return mTJProjectionViewer;
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        this.addQuickOutlineMenuEntry(iMenuManager);
        super.editorContextMenuAboutToShow(iMenuManager);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        try {
            ISourceViewer iSourceViewer;
            if (this.fConfiguration != null && (iSourceViewer = this.getSourceViewer()) != null) {
                this.fConfiguration.adaptToPreferenceChange(propertyChangeEvent);
            }
        }
        finally {
            super.handlePreferenceStoreChanged(propertyChangeEvent);
        }
    }
}

