/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.launching.LinedStackTraceParser;
import org.eclipse.mtj.internal.core.launching.OffsetedStackTraceParser;
import org.eclipse.mtj.internal.core.launching.StackTraceEntry;
import org.eclipse.mtj.internal.core.launching.StackTraceParser;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.launching.BCIStackTraceMatcher;
import org.eclipse.mtj.internal.ui.launching.LinedStackTraceMatcher;
import org.eclipse.mtj.internal.ui.launching.OffsetedStackTraceMatcher;
import org.eclipse.mtj.internal.ui.launching.StackTraceMatcher;
import org.eclipse.ui.console.IPatternMatchListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJConsoleLineTracker
implements IConsoleLineTracker {
    private Map<String, StackTraceEntry> cachedTrace;
    private IJavaProject project;
    private IConsole console;

    public void init(IConsole iConsole) {
        this.cachedTrace = new Hashtable<String, StackTraceEntry>();
        this.console = iConsole;
        try {
            IProject iProject;
            ILaunchConfiguration iLaunchConfiguration = iConsole.getProcess().getLaunch().getLaunchConfiguration();
            String string = iLaunchConfiguration.getAttribute("org.eclipse.jdt.launching.PROJECT_ATTR", "");
            if (string.length() > 0 && (iProject = MTJCore.getWorkspace().getRoot().getProject(string)).isOpen() && iProject.hasNature("org.eclipse.mtj.core.nature")) {
                this.project = JavaCore.create((IProject)iProject);
                StackTraceMatcher stackTraceMatcher = null;
                OffsetedStackTraceParser offsetedStackTraceParser = null;
                offsetedStackTraceParser = new OffsetedStackTraceParser(this.project);
                stackTraceMatcher = new OffsetedStackTraceMatcher(this, (StackTraceParser)offsetedStackTraceParser);
                this.console.addPatternMatchListener((IPatternMatchListener)stackTraceMatcher);
                stackTraceMatcher = new BCIStackTraceMatcher(this, (StackTraceParser)offsetedStackTraceParser);
                this.console.addPatternMatchListener((IPatternMatchListener)stackTraceMatcher);
                offsetedStackTraceParser = new LinedStackTraceParser(this.project);
                stackTraceMatcher = new LinedStackTraceMatcher(this, (StackTraceParser)offsetedStackTraceParser);
                this.console.addPatternMatchListener((IPatternMatchListener)stackTraceMatcher);
            }
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)4, (String)coreException.getMessage(), (Throwable)coreException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineAppended(IRegion iRegion) {
        block6: {
            try {
                String string = this.console.getDocument().get(iRegion.getOffset(), iRegion.getLength());
                if (!Pattern.matches("(\tat .+[(].*[.java][:]\\d+[)])", string) && !Pattern.matches("(\tat .+[(][+]\\d+[)])", string) && !Pattern.matches("(\\s[-]\\s.+[,]\\s(bci=)\\d+)", string)) break block6;
                StackTraceEntry stackTraceEntry = null;
                Map<String, StackTraceEntry> map = this.cachedTrace;
                synchronized (map) {
                    stackTraceEntry = this.cachedTrace.get(string);
                    if (stackTraceEntry == null) {
                        stackTraceEntry = new StackTraceEntry(string);
                        this.cachedTrace.put(string, stackTraceEntry);
                    }
                }
                stackTraceEntry.addRegion(iRegion);
            }
            catch (BadLocationException badLocationException) {
                MTJLogger.log((int)4, (String)badLocationException.getMessage(), (Throwable)badLocationException);
            }
        }
    }

    public Map<String, StackTraceEntry> getCachedTrace() {
        return this.cachedTrace;
    }

    public IConsole getConsole() {
        return this.console;
    }

    public void dispose() {
        this.console = null;
    }
}

