/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.dialogfields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mtj.internal.ui.util.PixelConverter;
import org.eclipse.mtj.internal.ui.util.TableLayoutComposite;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListDialogField
extends DialogField {
    private Button[] fButtonControls;
    private Composite fButtonsControl;
    private boolean[] fButtonsEnabled;
    private int fDownButtonIndex;
    private Label fLastSeparator;
    private IListAdapter fListAdapter;
    private Object fParentElement;
    private int fRemoveButtonIndex;
    private ISelection fSelectionWhenEnabled;
    private ColumnsDescription fTableColumns;
    private int fUpButtonIndex;
    protected String[] fButtonLabels;
    protected List<Object> fElements;
    protected ILabelProvider fLabelProvider;
    protected ListViewerAdapter fListViewerAdapter;
    protected TableViewer fTable;
    protected Control fTableControl;
    protected ViewerComparator fViewerComparator;

    public ListDialogField(IListAdapter iListAdapter, String[] stringArray, ILabelProvider iLabelProvider) {
        this.fListAdapter = iListAdapter;
        this.fLabelProvider = iLabelProvider;
        this.fListViewerAdapter = new ListViewerAdapter();
        this.fParentElement = this;
        this.fElements = new ArrayList<Object>(10);
        this.fButtonLabels = stringArray;
        if (this.fButtonLabels != null) {
            int n = this.fButtonLabels.length;
            this.fButtonsEnabled = new boolean[n];
            int n2 = 0;
            while (n2 < n) {
                this.fButtonsEnabled[n2] = true;
                ++n2;
            }
        }
        this.fTable = null;
        this.fTableControl = null;
        this.fButtonsControl = null;
        this.fTableColumns = null;
        this.fRemoveButtonIndex = -1;
        this.fUpButtonIndex = -1;
        this.fDownButtonIndex = -1;
    }

    public boolean addElement(Object object) {
        return this.addElement(object, this.fElements.size());
    }

    public boolean addElement(Object object, int n) {
        if (this.fElements.contains(object)) {
            return false;
        }
        this.fElements.add(n, object);
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.refresh();
            this.fTable.setSelection((ISelection)new StructuredSelection(object));
        }
        this.dialogFieldChanged();
        return true;
    }

    public boolean addElements(List<Object> list) {
        return this.addElements(list, this.fElements.size());
    }

    public boolean addElements(List<Object> list, int n) {
        int n2 = list.size();
        if (n2 > 0 && n >= 0 && n <= this.fElements.size()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(n2);
            int n3 = 0;
            while (n3 < n2) {
                Object object = list.get(n3);
                if (!this.fElements.contains(object)) {
                    arrayList.add(object);
                }
                ++n3;
            }
            if (!arrayList.isEmpty()) {
                this.fElements.addAll(n, arrayList);
                if (this.isOkToUse(this.fTableControl)) {
                    if (n == this.fElements.size()) {
                        this.fTable.add(arrayList.toArray());
                    } else {
                        n3 = arrayList.size() - 1;
                        while (n3 >= 0) {
                            this.fTable.insert(arrayList.get(n3), n);
                            --n3;
                        }
                    }
                    this.fTable.setSelection((ISelection)new StructuredSelection(arrayList));
                }
                this.dialogFieldChanged();
                return true;
            }
        }
        return false;
    }

    public boolean canMoveDown() {
        if (this.isOkToUse(this.fTableControl)) {
            int[] nArray = this.fTable.getTable().getSelectionIndices();
            int n = this.fElements.size() - 1;
            int n2 = nArray.length - 1;
            while (n2 >= 0) {
                if (nArray[n2] != n) {
                    return true;
                }
                --n2;
                --n;
            }
        }
        return false;
    }

    public boolean canMoveUp() {
        if (this.isOkToUse(this.fTableControl)) {
            int[] nArray = this.fTable.getTable().getSelectionIndices();
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] != n) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    @Override
    public void dialogFieldChanged() {
        super.dialogFieldChanged();
        this.updateButtonState();
    }

    @Override
    public Control[] doFillIntoGrid(Composite composite, int n) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        GridData gridData = ListDialogField.gridDataForLabel(1);
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
        Control control = this.getListControl(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = n - 2;
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(6);
        control.setLayoutData((Object)gridData);
        Composite composite2 = this.getButtonBox(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite2.setLayoutData((Object)gridData);
        return new Control[]{label, control, composite2};
    }

    public void editElement(Object object) {
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.refresh(object);
            this.fTable.editElement(object, 0);
        }
    }

    public void elementChanged(Object object) throws IllegalArgumentException {
        if (this.fElements.contains(object)) {
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.update(object, null);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void enableButton(int n, boolean bl) {
        if (this.fButtonsEnabled != null && n < this.fButtonsEnabled.length) {
            this.fButtonsEnabled[n] = bl;
            this.updateButtonState();
        }
    }

    public Composite getButtonBox(Composite composite) {
        if (this.fButtonsControl == null) {
            this.assertCompositeNotNull(composite);
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    ListDialogField.this.doButtonSelected(selectionEvent);
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ListDialogField.this.doButtonSelected(selectionEvent);
                }
            };
            Composite composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite2.setLayout((Layout)gridLayout);
            if (this.fButtonLabels != null) {
                this.fButtonControls = new Button[this.fButtonLabels.length];
                int n = 0;
                while (n < this.fButtonLabels.length) {
                    String string = this.fButtonLabels[n];
                    if (string != null) {
                        this.fButtonControls[n] = this.createButton(composite2, string, selectionListener);
                        this.fButtonControls[n].setEnabled(this.isEnabled() && this.fButtonsEnabled[n]);
                    } else {
                        this.fButtonControls[n] = null;
                        this.createSeparator(composite2);
                    }
                    ++n;
                }
            }
            this.fLastSeparator = this.createSeparator(composite2);
            this.updateButtonState();
            this.fButtonsControl = composite2;
        }
        return this.fButtonsControl;
    }

    public Object getElement(int n) {
        return this.fElements.get(n);
    }

    public List<Object> getElements() {
        return new ArrayList<Object>(this.fElements);
    }

    public int getIndexOfElement(Object object) {
        return this.fElements.indexOf(object);
    }

    public Control getListControl(Composite composite) {
        if (this.fTableControl == null) {
            this.assertCompositeNotNull(composite);
            if (this.fTableColumns == null) {
                this.fTable = this.createTableViewer(composite);
                Table table = this.fTable.getTable();
                this.fTableControl = table;
                table.setLayout((Layout)new TableLayout());
            } else {
                TableLayoutComposite tableLayoutComposite = new TableLayoutComposite(composite, 0);
                tableLayoutComposite.setFont(composite.getFont());
                this.fTableControl = tableLayoutComposite;
                this.fTable = this.createTableViewer(tableLayoutComposite);
                Table table = this.fTable.getTable();
                table.setHeaderVisible(this.fTableColumns.getHeaders() != null);
                table.setLinesVisible(this.fTableColumns.isDrawLines());
                ColumnLayoutData[] columnLayoutDataArray = this.fTableColumns.getColumns();
                int n = 0;
                while (n < columnLayoutDataArray.length) {
                    int n2;
                    tableLayoutComposite.addColumnData(columnLayoutDataArray[n]);
                    TableColumn tableColumn = new TableColumn(table, 0);
                    if (this.fTableColumns.getHeaders() != null) {
                        tableColumn.setText(this.fTableColumns.getHeaders()[n]);
                    }
                    if (this.fTableColumns.getWidth() != null && (n2 = this.fTableColumns.getWidth()[n]) > 0) {
                        tableColumn.setWidth(this.fTableColumns.getWidth()[n]);
                    }
                    ++n;
                }
            }
            this.fTable.getTable().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    ListDialogField.this.handleKeyPressed(keyEvent);
                }
            });
            this.fTable.setContentProvider((IContentProvider)this.fListViewerAdapter);
            this.fTable.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            this.fTable.addSelectionChangedListener((ISelectionChangedListener)this.fListViewerAdapter);
            this.fTable.addDoubleClickListener((IDoubleClickListener)this.fListViewerAdapter);
            this.fTable.setInput(this.fParentElement);
            if (this.fViewerComparator != null) {
                this.fTable.setComparator(this.fViewerComparator);
            }
            this.fTableControl.setEnabled(this.isEnabled());
            if (this.fSelectionWhenEnabled != null) {
                this.selectElements(this.fSelectionWhenEnabled);
            }
        }
        return this.fTableControl;
    }

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    public List<Object> getSelectedElements() {
        ISelection iSelection;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.isOkToUse(this.fTableControl) && (iSelection = this.fTable.getSelection()) instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    public int getSize() {
        return this.fElements.size();
    }

    public TableViewer getTableViewer() {
        return this.fTable;
    }

    public void postSetSelection(final ISelection iSelection) {
        if (this.isOkToUse(this.fTableControl)) {
            Display display = this.fTableControl.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (ListDialogField.this.isOkToUse(ListDialogField.this.fTableControl)) {
                        ListDialogField.this.selectElements(iSelection);
                    }
                }
            });
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.refresh();
        }
    }

    public void removeAllElements() {
        if (this.fElements.size() > 0) {
            this.fElements.clear();
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.refresh();
            }
            this.dialogFieldChanged();
        }
    }

    public void removeElement(Object object) throws IllegalArgumentException {
        if (this.fElements.remove(object)) {
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.remove(object);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void removeElements(List<Object> list) {
        if (list.size() > 0) {
            this.fElements.removeAll(list);
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.remove(list.toArray());
            }
            this.dialogFieldChanged();
        }
    }

    public void replaceElement(Object object, Object object2) throws IllegalArgumentException {
        int n = this.fElements.indexOf(object);
        if (n != -1) {
            this.fElements.set(n, object2);
            if (this.isOkToUse(this.fTableControl)) {
                List<Object> list = this.getSelectedElements();
                if (list.remove(object)) {
                    list.add(object2);
                }
                this.fTable.refresh();
                this.selectElements((ISelection)new StructuredSelection(list));
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void selectElements(ISelection iSelection) {
        this.fSelectionWhenEnabled = iSelection;
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.setSelection(iSelection, true);
        }
    }

    public void selectFirstElement() {
        Object object = null;
        if (this.fViewerComparator != null) {
            Object[] objectArray = this.fElements.toArray();
            this.fViewerComparator.sort((Viewer)this.fTable, objectArray);
            if (objectArray.length > 0) {
                object = objectArray[0];
            }
        } else if (this.fElements.size() > 0) {
            object = this.fElements.get(0);
        }
        if (object != null) {
            this.selectElements((ISelection)new StructuredSelection(object));
        }
    }

    public void setButtonsMinWidth(int n) {
        if (this.fLastSeparator != null) {
            ((GridData)this.fLastSeparator.getLayoutData()).widthHint = n;
        }
    }

    public void setDownButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fDownButtonIndex = n;
    }

    public void setElements(Collection<Object> collection) {
        this.fElements = new ArrayList<Object>(collection);
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.refresh();
        }
        this.dialogFieldChanged();
    }

    public void setRemoveButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fRemoveButtonIndex = n;
    }

    public void setTableColumns(ColumnsDescription columnsDescription) {
        this.fTableColumns = columnsDescription;
    }

    public void setUpButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fUpButtonIndex = n;
    }

    public void setViewerComparator(ViewerComparator viewerComparator) {
        this.fViewerComparator = viewerComparator;
    }

    private void buttonPressed(int n) {
        if (!this.managedButtonPressed(n) && this.fListAdapter != null) {
            this.fListAdapter.customButtonPressed(this, n);
        }
    }

    private Label createSeparator(Composite composite) {
        Label label = new Label(composite, 258);
        label.setFont(composite.getFont());
        label.setVisible(false);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.verticalIndent = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private void doButtonSelected(SelectionEvent selectionEvent) {
        if (this.fButtonControls != null) {
            int n = 0;
            while (n < this.fButtonControls.length) {
                if (selectionEvent.widget == this.fButtonControls[n]) {
                    this.buttonPressed(n);
                    return;
                }
                ++n;
            }
        }
    }

    private void down() {
        this.moveDown(this.getSelectedElements());
    }

    private boolean isButtonEnabled(ISelection iSelection, int n) {
        boolean bl = this.getManagedButtonState(iSelection, n);
        return this.isEnabled() && bl && this.fButtonsEnabled[n];
    }

    private void moveDown(List<Object> list) {
        if (list.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.fElements), list)));
            this.fTable.reveal(list.get(list.size() - 1));
        }
    }

    private void moveUp(List<Object> list) {
        if (list.size() > 0) {
            this.setElements(this.moveUp(this.fElements, list));
            this.fTable.reveal(list.get(0));
        }
    }

    private List<Object> moveUp(List<Object> list, List<Object> list2) {
        int n = list.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        Object object = null;
        int n2 = 0;
        while (n2 < n) {
            Object object2 = list.get(n2);
            if (list2.contains(object2)) {
                arrayList.add(object2);
            } else {
                if (object != null) {
                    arrayList.add(object);
                }
                object = object2;
            }
            ++n2;
        }
        if (object != null) {
            arrayList.add(object);
        }
        return arrayList;
    }

    private void remove() {
        this.removeElements(this.getSelectedElements());
    }

    private List<Object> reverse(List<Object> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        int n = list.size() - 1;
        while (n >= 0) {
            arrayList.add(list.get(n));
            --n;
        }
        return arrayList;
    }

    private void up() {
        this.moveUp(this.getSelectedElements());
    }

    protected Button createButton(Composite composite, String string, SelectionListener selectionListener) {
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        button.setText(string);
        button.addSelectionListener(selectionListener);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 1;
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected TableViewer createTableViewer(Composite composite) {
        Table table = new Table(composite, this.getListStyle());
        table.setFont(composite.getFont());
        return new TableViewer(table);
    }

    protected void doDoubleClick(DoubleClickEvent doubleClickEvent) {
        if (this.fListAdapter != null) {
            this.fListAdapter.doubleClicked(this);
        }
    }

    protected void doListSelected(SelectionChangedEvent selectionChangedEvent) {
        this.updateButtonState();
        if (this.fListAdapter != null) {
            this.fListAdapter.selectionChanged(this);
        }
    }

    protected int getListStyle() {
        int n = 2818;
        if (this.fTableColumns != null) {
            n |= 0x10000;
        }
        return n;
    }

    protected boolean getManagedButtonState(ISelection iSelection, int n) {
        if (n == this.fRemoveButtonIndex) {
            return !iSelection.isEmpty();
        }
        if (n == this.fUpButtonIndex) {
            return !iSelection.isEmpty() && this.canMoveUp();
        }
        if (n == this.fDownButtonIndex) {
            return !iSelection.isEmpty() && this.canMoveDown();
        }
        return true;
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.fRemoveButtonIndex != -1 && this.isButtonEnabled(this.fTable.getSelection(), this.fRemoveButtonIndex)) {
            this.managedButtonPressed(this.fRemoveButtonIndex);
        }
    }

    protected boolean managedButtonPressed(int n) {
        if (n == this.fRemoveButtonIndex) {
            this.remove();
        } else if (n == this.fUpButtonIndex) {
            this.up();
            if (!this.fButtonControls[n].isEnabled() && this.fDownButtonIndex != -1) {
                this.fButtonControls[this.fDownButtonIndex].setFocus();
            }
        } else if (n == this.fDownButtonIndex) {
            this.down();
            if (!this.fButtonControls[n].isEnabled() && this.fUpButtonIndex != -1) {
                this.fButtonControls[this.fUpButtonIndex].setFocus();
            }
        } else {
            return false;
        }
        return true;
    }

    protected void updateButtonState() {
        if (this.fButtonControls != null && this.isOkToUse(this.fTableControl) && this.fTableControl.isEnabled()) {
            ISelection iSelection = this.fTable.getSelection();
            int n = 0;
            while (n < this.fButtonControls.length) {
                Button button = this.fButtonControls[n];
                if (this.isOkToUse((Control)button)) {
                    button.setEnabled(this.isButtonEnabled(iSelection, n));
                }
                ++n;
            }
        }
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        boolean bl = this.isEnabled();
        if (this.isOkToUse(this.fTableControl)) {
            if (!bl) {
                if (this.fSelectionWhenEnabled == null) {
                    this.fSelectionWhenEnabled = this.fTable.getSelection();
                    this.selectElements(null);
                }
            } else if (this.fSelectionWhenEnabled != null) {
                this.selectElements(this.fSelectionWhenEnabled);
                this.fSelectionWhenEnabled = null;
            }
            this.fTableControl.setEnabled(bl);
        }
        this.updateButtonState();
    }

    public static class ColumnsDescription {
        private ColumnLayoutData[] columns;
        private boolean drawLines;
        private String[] headers;
        private int[] width;

        private static ColumnLayoutData[] createColumnWeightData(int n) {
            ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[n];
            int n2 = 0;
            while (n2 < n) {
                columnLayoutDataArray[n2] = new ColumnWeightData(1);
                ++n2;
            }
            return columnLayoutDataArray;
        }

        public ColumnsDescription(ColumnLayoutData[] columnLayoutDataArray, String[] stringArray, int[] nArray, boolean bl) {
            this.columns = columnLayoutDataArray;
            this.headers = stringArray;
            this.drawLines = bl;
            this.width = nArray;
        }

        public ColumnsDescription(int n, boolean bl) {
            this(ColumnsDescription.createColumnWeightData(n), null, null, bl);
        }

        public ColumnsDescription(String[] stringArray, int[] nArray, boolean bl) {
            this(ColumnsDescription.createColumnWeightData(stringArray.length), stringArray, nArray, bl);
        }

        public ColumnLayoutData[] getColumns() {
            return this.columns;
        }

        public String[] getHeaders() {
            return this.headers;
        }

        public int[] getWidth() {
            return this.width;
        }

        public boolean isDrawLines() {
            return this.drawLines;
        }

        public void setColumns(ColumnLayoutData[] columnLayoutDataArray) {
            this.columns = columnLayoutDataArray;
        }

        public void setDrawLines(boolean bl) {
            this.drawLines = bl;
        }

        public void setHeaders(String[] stringArray) {
            this.headers = stringArray;
        }

        public void setWidth(int[] nArray) {
            this.width = nArray;
        }
    }

    private class ListViewerAdapter
    implements IStructuredContentProvider,
    ISelectionChangedListener,
    IDoubleClickListener {
        private ListViewerAdapter() {
        }

        public void dispose() {
        }

        public void doubleClick(DoubleClickEvent doubleClickEvent) {
            ListDialogField.this.doDoubleClick(doubleClickEvent);
        }

        public Object[] getElements(Object object) {
            return ListDialogField.this.fElements.toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public boolean isDeleted(Object object) {
            return false;
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            ListDialogField.this.doListSelected(selectionChangedEvent);
        }
    }
}

