/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.l10n;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.internal.core.l10n.L10nApi;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.wizards.l10n.LocalizationPage;

public class LocalizationWizard
extends Wizard {
    private LocalizationPage page;
    private IJavaProject jProject;

    public LocalizationWizard(IJavaProject iJavaProject) {
        this.jProject = iJavaProject;
        this.setWindowTitle(MTJUIMessages.LocalizationWizard_window_title);
    }

    public void addPages() {
        this.page = new LocalizationPage(this.jProject, this.getContainer());
        this.addPage((IWizardPage)this.page);
    }

    public boolean canFinish() {
        IResource iResource = this.page.getDestination();
        IJavaElement iJavaElement = this.page.getPackage();
        return iResource != null && iJavaElement != null;
    }

    public boolean performFinish() {
        IResource iResource = this.page.getDestination();
        IJavaElement iJavaElement = this.page.getPackage();
        boolean bl = false;
        if (iJavaElement instanceof IPackageFragment) {
            try {
                bl = L10nApi.createLocalizationFile((IProject)this.jProject.getProject(), (IPath)iResource.getProjectRelativePath(), (IJavaElement)iJavaElement);
                this.jProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                bl &= L10nApi.createLocalizationApi((IProject)this.jProject.getProject(), (IPackageFragment)((IPackageFragment)iJavaElement), (IPath)iResource.getProjectRelativePath());
                this.jProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }
}

