/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.jmunit.JMUnitMessages;
import org.eclipse.mtj.internal.jmunit.JMUnitPlugin;
import org.eclipse.mtj.internal.ui.util.ExceptionHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class JMUnitWizard
extends Wizard
implements INewWizard {
    protected static final String DIALOG_SETTINGS_KEY = "JMUnitWizards";
    private IWorkbench fWorkbench;
    private IStructuredSelection fSelection;

    public JMUnitWizard() {
        this.setNeedsProgressMonitor(true);
        this.initializeDefaultPageImageDescriptor();
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.fWorkbench = iWorkbench;
        this.fSelection = iStructuredSelection;
    }

    public abstract boolean performFinish();

    protected boolean finishPage(IRunnableWithProgress iRunnableWithProgress) {
        WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation(iRunnableWithProgress);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)this.getContainer(), (IRunnableWithProgress)workspaceModifyDelegatingOperation, (ISchedulingRule)MTJCore.getWorkspace().getRoot());
        }
        catch (InvocationTargetException invocationTargetException) {
            Shell shell = this.getShell();
            String string = JMUnitMessages.NewJUnitWizard_op_error_title;
            String string2 = JMUnitMessages.NewJUnitWizard_op_error_message;
            ExceptionHandler.handle((InvocationTargetException)invocationTargetException, (Shell)shell, (String)string, (String)string2);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected void initDialogSettings() {
        IDialogSettings iDialogSettings = JMUnitPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_SETTINGS_KEY);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = new DialogSettings(DIALOG_SETTINGS_KEY);
            iDialogSettings.addSection(iDialogSettings2);
        }
        this.setDialogSettings(iDialogSettings2);
    }

    protected abstract void initializeDefaultPageImageDescriptor();

    protected void openResource(final IResource iResource) {
        Display display;
        IWorkbenchPage iWorkbenchPage;
        if (iResource.getType() == 1 && (iWorkbenchPage = JMUnitPlugin.getActivePage()) != null && (display = Display.getDefault()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)((IFile)iResource), (boolean)true);
                    }
                    catch (PartInitException partInitException) {
                        JMUnitPlugin.log((Exception)((Object)partInitException));
                    }
                }
            });
        }
    }

    protected void selectAndReveal(IResource iResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)iResource, (IWorkbenchWindow)this.fWorkbench.getActiveWorkbenchWindow());
    }
}

