/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.ISDKProvider;
import org.eclipse.mtj.internal.core.sdk.ISDKProviderRegistryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDKProviderRegistry
implements IRegistryChangeListener {
    private static SDKProviderRegistry instance;
    protected Set<ISDKProvider> sdkProviders;
    protected ArrayList<ISDKProviderRegistryListener> listenerList = new ArrayList();

    public static synchronized SDKProviderRegistry getInstance() {
        if (instance == null) {
            instance = new SDKProviderRegistry();
        }
        return instance;
    }

    private SDKProviderRegistry() {
        RegistryFactory.getRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public synchronized void addListener(ISDKProviderRegistryListener iSDKProviderRegistryListener) {
        this.listenerList.add(iSDKProviderRegistryListener);
    }

    public synchronized void removeListener(ISDKProviderRegistryListener iSDKProviderRegistryListener) {
        this.listenerList.remove(iSDKProviderRegistryListener);
    }

    public synchronized List<ISDKProvider> getSDKProviders() {
        this.initialize();
        return new ArrayList<ISDKProvider>(this.sdkProviders);
    }

    public synchronized int getSDKProviderCount() {
        this.initialize();
        return this.sdkProviders.size();
    }

    protected void initialize() {
        if (this.sdkProviders == null) {
            this.sdkProviders = new TreeSet<ISDKProvider>();
            this.readSdkProviders(false);
        }
    }

    protected synchronized void refresh() {
        if (this.sdkProviders == null) {
            this.sdkProviders = new TreeSet<ISDKProvider>();
            this.readSdkProviders(true);
        }
    }

    protected void readSdkProviders(boolean bl) {
        Object object;
        IConfigurationElement[] iConfigurationElementArray;
        String string = MTJCore.getMTJCore().getBundle().getSymbolicName();
        if (string == null) {
            return;
        }
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        TreeSet<ISDKProvider> treeSet = new TreeSet<ISDKProvider>();
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string, "sdkprovider");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iConfigurationElementArray2[n2];
            try {
                ISDKProvider iSDKProvider = (ISDKProvider)object.createExecutableExtension("class");
                treeSet.add(iSDKProvider);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            ++n2;
        }
        object = new TreeSet(treeSet);
        object.removeAll(this.sdkProviders);
        TreeSet<ISDKProvider> treeSet2 = new TreeSet<ISDKProvider>((Collection<ISDKProvider>)treeSet);
        treeSet2.removeAll((Collection<?>)object);
        this.addSDKProviders((Set<ISDKProvider>)object, bl);
        this.removeSDKProviders(treeSet2, bl);
    }

    protected synchronized void addSDKProviders(Set<ISDKProvider> set, boolean bl) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException();
        }
        if (!set.isEmpty()) {
            this.sdkProviders.addAll(set);
            if (bl) {
                this.fireSDKProvidersAddedEvent(set);
            }
        }
    }

    protected synchronized void removeSDKProviders(Set<ISDKProvider> set, boolean bl) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException();
        }
        if (!set.isEmpty()) {
            this.sdkProviders.removeAll(set);
            if (bl) {
                this.fireSDKProvidersRemovedEvent(set);
            }
        }
    }

    protected synchronized void fireSDKProvidersAddedEvent(final Set<ISDKProvider> set) {
        for (final ISDKProviderRegistryListener iSDKProviderRegistryListener : this.listenerList) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    iSDKProviderRegistryListener.sdkProvidersAdded(set);
                }
            });
            thread.start();
        }
    }

    protected synchronized void fireSDKProvidersRemovedEvent(final Set<ISDKProvider> set) {
        for (final ISDKProviderRegistryListener iSDKProviderRegistryListener : this.listenerList) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    iSDKProviderRegistryListener.sdkProvidersRemoved(set);
                }
            });
            thread.start();
        }
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        this.refresh();
    }
}

