/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.internal.core.Trace;

public class JavadocDetector {
    private static final String PACKAGE_LIST = "package-list";

    public URL detectJavadoc(ILibrary iLibrary) {
        boolean bl = Trace.isOptionEnabled(Trace.JAVADOC_DETECT_PERF);
        long l = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        URL uRL = this.searchForJavaDoc(iLibrary);
        if (bl) {
            long l2 = System.currentTimeMillis() - l;
            Trace.trace(Trace.JAVADOC_DETECT_PERF, "Detected javadoc for ", iLibrary.toString(), " in ", l2, "ms");
        }
        return uRL;
    }

    private URL searchForJavaDoc(ILibrary iLibrary) {
        URL uRL = null;
        File[] fileArray = this.getDefaultDocRootDirectories(iLibrary);
        if (fileArray != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray2[n2];
                uRL = this.searchForLibraryDoc(file, iLibrary);
                if (uRL != null) break;
                ++n2;
            }
        }
        return uRL;
    }

    private File[] getDefaultDocRootDirectories(ILibrary iLibrary) {
        if (iLibrary == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = iLibrary.toFile().getParentFile();
        int n = 0;
        while (n < 5 && file != null) {
            File[] fileArray;
            File[] fileArray2 = fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() && file.getName().indexOf("doc") != -1;
                }
            });
            int n2 = fileArray.length;
            int n3 = 0;
            while (n3 < n2) {
                File file2 = fileArray2[n3];
                arrayList.add(file2);
                ++n3;
            }
            file = file.getParentFile();
            ++n;
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new File[0]);
        }
        return null;
    }

    private URL searchForLibraryDoc(File file, ILibrary iLibrary) {
        if (iLibrary instanceof IMIDPLibrary) {
            File[] fileArray;
            File[] fileArray2 = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    File file2;
                    File file3;
                    return file.isDirectory() && (file3 = new File(file, "index.html")).isFile() && (file2 = new File(file, JavadocDetector.PACKAGE_LIST)).isFile();
                }
            });
            if (fileArray2.length > 0) {
                try {
                    fileArray = new JarFile(iLibrary.toFile());
                    boolean bl = false;
                    IMIDPLibrary iMIDPLibrary = (IMIDPLibrary)iLibrary;
                    boolean bl2 = iMIDPLibrary.hasProfile() || iMIDPLibrary.hasConfiguration();
                    Trace.trace(Trace.JAVADOC_DETECT_DEBUG, "Searching javadocs for ", iMIDPLibrary);
                    int n = 0;
                    while (n < fileArray2.length) {
                        String string;
                        File file2 = new File(fileArray2[n], PACKAGE_LIST);
                        boolean bl3 = false;
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                        String string2 = bufferedReader.readLine();
                        while (string2 != null) {
                            if (string2.startsWith("#")) {
                                string2 = bufferedReader.readLine();
                                continue;
                            }
                            if (bl2 && !bl3 && "java.lang".equals(string2.trim())) {
                                Trace.trace(Trace.JAVADOC_DETECT_DEBUG, "java.lang entry found in line ", string2, " package-list is ", file2);
                                bl3 = true;
                            }
                            if (fileArray.getEntry(string2.replace('.', '/')) == null) {
                                bl = false;
                                break;
                            }
                            string2 = bufferedReader.readLine();
                            bl = true;
                            if (!bl2 || bl3) continue;
                            bl = false;
                        }
                        if (bl) {
                            Trace.trace(Trace.JAVADOC_DETECT_DEBUG, "Found javadocs for ", iMIDPLibrary, " in ", fileArray2[n]);
                            return fileArray2[n].toURI().toURL();
                        }
                        String string3 = iLibrary.toFile().getName();
                        int n2 = string3.lastIndexOf(46);
                        String string4 = n2 > -1 ? string3.substring(0, n2) : string3;
                        String string5 = fileArray2[n].getName().toLowerCase();
                        if (string5.startsWith(string = string4.toLowerCase()) || string.startsWith(string5)) {
                            return fileArray2[n].toURI().toURL();
                        }
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    MTJCore.getMTJCore().getLog().log((IStatus)new Status(2, MTJCore.getPluginId(), "Error while matchin javadocs", (Throwable)iOException));
                }
            }
            fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            URL uRL = null;
            int n = 0;
            while (n < fileArray.length && uRL == null) {
                uRL = this.searchForLibraryDoc(fileArray[n], iLibrary);
                ++n;
            }
            return uRL;
        }
        return null;
    }
}

