/**
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation         - initial API and implementation
 *     Diego Sandin (Motorola) - Initial version  based on  
 *                               org.eclipse.pde
 **/
package org.eclipse.mtj.internal.ui.forms.parts;

import org.eclipse.ui.forms.events.IHyperlinkListener;

/**
 * Listener for FormEntry component events.
 */
public interface IFormEntryListener extends IHyperlinkListener {

    /**
     * The user pressed the 'Browse' button for the entry.
     * 
     * @param entry
     */
    void browseButtonSelected(FormEntry entry);

    /**
     * The user clicked on the text control and focus was transfered to it.
     * 
     * @param entry
     */
    void focusGained(FormEntry entry);

    /**
     * @param entry
     */
    void selectionChanged(FormEntry entry);

    /**
     * The user changed the text in the text control of the entry.
     * 
     * @param entry
     */
    void textDirty(FormEntry entry);

    /**
     * The value of the entry has been changed to be the text in the text
     * control (as a result of 'commit' action).
     * 
     * @param entry
     */
    void textValueChanged(FormEntry entry);
}
