/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.cinterion;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.project.ProjectType;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.internal.toolkit.cinterion.CinterionCore;
import org.eclipse.mtj.internal.toolkit.uei.UEIDeviceInternal;
import org.eclipse.mtj.internal.toolkit.uei.properties.DeviceSpecificProperties;
import org.eclipse.mtj.internal.toolkit.uei.properties.UEIDeviceDefinition;
import org.osgi.framework.Version;

public class CinterionDevice
extends UEIDeviceInternal {
    public CinterionDevice() {
    }

    public CinterionDevice(String string, String string2, String string3, Properties properties, UEIDeviceDefinition uEIDeviceDefinition, File file, IPreverifier iPreverifier) throws IllegalArgumentException {
        super(string, string2, string3, properties, uEIDeviceDefinition, file, iPreverifier);
        this.setBundle(CinterionCore.getDefault().getBundle().getSymbolicName());
    }

    protected IDeviceClasspath getBootClasspath(Properties properties) {
        IDeviceClasspath iDeviceClasspath = MTJCore.createNewDeviceClasspath();
        String string = properties.getProperty(DeviceSpecificProperties.BOOTCLASSPATH.toString(), "");
        iDeviceClasspath.addEntry(this.createLibraries(string));
        return iDeviceClasspath;
    }

    public String getBundle() {
        return CinterionCore.getDefault().getBundle().getSymbolicName();
    }

    private ILibrary createLibraries(String string) {
        ArrayList<IMIDPAPI> arrayList = new ArrayList<IMIDPAPI>();
        IMIDPAPI iMIDPAPI = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        iMIDPAPI.setIdentifier("IMP-NG");
        iMIDPAPI.setType(MIDPAPIType.PROFILE);
        iMIDPAPI.setName("Information Module Profile");
        iMIDPAPI.setVersion(new Version("2.0"));
        arrayList.add(iMIDPAPI);
        IMIDPAPI iMIDPAPI2 = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        iMIDPAPI2.setIdentifier("CLDC");
        iMIDPAPI2.setType(MIDPAPIType.CONFIGURATION);
        iMIDPAPI2.setName("Connected Limited Device Configuration");
        iMIDPAPI2.setVersion(new Version("1.1"));
        arrayList.add(iMIDPAPI2);
        IMIDPAPI iMIDPAPI3 = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        iMIDPAPI3.setIdentifier("SIEMENS-ICM");
        iMIDPAPI3.setType(MIDPAPIType.OPTIONAL);
        iMIDPAPI3.setName("Siemens Icm");
        iMIDPAPI3.setVersion(new Version("1.0"));
        arrayList.add(iMIDPAPI3);
        IMIDPLibrary iMIDPLibrary = (IMIDPLibrary)MTJCore.createNewLibrary((ProjectType)ProjectType.MIDLET_SUITE);
        iMIDPLibrary.setLibraryFile(new File(string));
        iMIDPLibrary.setApis(arrayList);
        return iMIDPLibrary;
    }
}

